/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.util.ResourceBundle;
import pl.com.kir.util.ParameterValidator;

public class StandardResourceManager {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("pl.com.kir.util.resources.StandardResourceManager");

    private StandardResourceManager() {
    }

    public static String getMonth(int month) {
        ParameterValidator.assertRange("month", month, 1, 12);
        String key = "month.";
        key = month < 10 ? key + "0" + Integer.toString(month) : key + Integer.toString(month);
        return resourceBundle.getString(key);
    }

    public static String[] getMonths() {
        String[] result = new String[12];
        for (int i2 = 0; i2 < 12; ++i2) {
            result[i2] = StandardResourceManager.getMonth(i2 + 1);
        }
        return result;
    }

    public static String getDayOfWeek(int day) {
        ParameterValidator.assertRange("day", day, 1, 7);
        return resourceBundle.getString("day." + Integer.toString(day));
    }

    public static String[] getDaysOfWeek() {
        String[] result = new String[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = StandardResourceManager.getDayOfWeek(i2 + 1);
        }
        return result;
    }
}

