/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.text.NumberFormat;
import pl.com.kir.util.StringUtil;

public class SizeFormatter {
    private SizeFormatter() {
    }

    public static String getBytes(long size) {
        return SizeFormatter.getBytes(size, 0);
    }

    public static String getBytes(long size, int fillLength) {
        String sizeText = NumberFormat.getInstance().format(size);
        sizeText = sizeText + " B";
        sizeText = StringUtil.fillLeft(sizeText, fillLength, ' ');
        return sizeText;
    }

    public static String getKilobytes(long size) {
        return SizeFormatter.getKilobytes(size, 0);
    }

    public static String getKilobytes(long size, int fractionDigits) {
        return SizeFormatter.getKilobytes(size, fractionDigits, 0);
    }

    public static String getKilobytes(long size, int fractionDigits, int fillLength) {
        NumberFormat formater = NumberFormat.getInstance();
        formater.setMinimumFractionDigits(fractionDigits);
        formater.setMaximumFractionDigits(fractionDigits);
        String sizeText = formater.format((double)size / 1024.0);
        if (fractionDigits > 0 && sizeText.indexOf(",") < 0) {
            sizeText = sizeText + "," + StringUtil.fillRight("", fractionDigits, '0');
        }
        sizeText = sizeText + " KB";
        sizeText = StringUtil.fillLeft(sizeText, fillLength, ' ');
        return sizeText;
    }

    public static String getMegabytes(long size) {
        return SizeFormatter.getMegabytes(size, 0);
    }

    public static String getMegabytes(long size, int fractionDigits) {
        return SizeFormatter.getMegabytes(size, fractionDigits, 0);
    }

    public static String getMegabytes(long size, int fractionDigits, int fillLength) {
        NumberFormat formater = NumberFormat.getInstance();
        formater.setMinimumFractionDigits(fractionDigits);
        formater.setMaximumFractionDigits(fractionDigits);
        String sizeText = formater.format((double)size / 1024.0 / 1024.0);
        if (fractionDigits > 0 && sizeText.indexOf(",") < 0) {
            sizeText = sizeText + "," + StringUtil.fillRight("", fractionDigits, '0');
        }
        sizeText = sizeText + " MB";
        sizeText = StringUtil.fillLeft(sizeText, fillLength, ' ');
        return sizeText;
    }

    public static String getSize(long size) {
        return SizeFormatter.getSize(size, 0);
    }

    public static String getSize(long size, int fractionDigits) {
        return SizeFormatter.getSize(size, fractionDigits, 0);
    }

    public static String getSize(long size, int fractionDigits, int fillLength) {
        String result = null;
        result = size > 0x100000L ? SizeFormatter.getMegabytes(size, fractionDigits, fillLength) : (size > 1024L ? SizeFormatter.getKilobytes(size, fractionDigits, fillLength) : SizeFormatter.getBytes(size, fillLength));
        return result;
    }
}

