/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.File;
import java.io.FileFilter;
import pl.com.kir.util.ParameterValidator;

public class SimpleFileFilter
implements FileFilter {
    private boolean directories = true;
    private boolean files = true;
    private boolean hidden = false;

    public SimpleFileFilter() {
    }

    public SimpleFileFilter(boolean directories, boolean files) {
        this(directories, files, false);
    }

    public SimpleFileFilter(boolean directories, boolean files, boolean hidden) {
        this.directories = directories;
        this.files = files;
        this.hidden = hidden;
    }

    @Override
    public boolean accept(File file) {
        ParameterValidator.assertNotNull("file", file);
        if (file.isFile() && this.files || file.isDirectory() && this.directories) {
            return !file.isHidden() || file.isHidden() && this.hidden;
        }
        return false;
    }

    public boolean isDirectories() {
        return this.directories;
    }

    public void setDirectories(boolean directories) {
        this.directories = directories;
    }

    public boolean isFiles() {
        return this.files;
    }

    public void setFiles(boolean files) {
        this.files = files;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

