/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import pl.com.kir.util.FileUtil;
import pl.com.kir.util.ParameterValidator;

public class SimpleCryptoHelper {
    public static final String TR_AES_CTR_NoPadding = "AES/CTR/NoPadding";
    private String transformation = null;
    private SecretKey key = null;
    private IvParameterSpec iv = null;

    public SimpleCryptoHelper(String transformation, SecretKey key, IvParameterSpec iv) {
        ParameterValidator.assertNotEmpty("transformation", transformation);
        ParameterValidator.assertNotNull("key", key);
        ParameterValidator.assertNotNull("iv", iv);
        this.transformation = transformation;
        this.key = key;
        this.iv = iv;
    }

    public byte[] load(File file) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        return SimpleCryptoHelper.load(file, this.transformation, this.key, this.iv);
    }

    public void save(File file, byte[] content) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        SimpleCryptoHelper.save(file, this.transformation, this.key, this.iv, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(File file, String transformation, SecretKey key, IvParameterSpec iv) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        ParameterValidator.assertNotNull("file", file);
        ParameterValidator.assertNotEmpty("transformation", transformation);
        ParameterValidator.assertNotNull("key", key);
        ParameterValidator.assertNotNull("iv", iv);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, (Key)key, iv);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(file);
            out = new CipherOutputStream(result, cipher);
            FileUtil.copy(in, out);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, String transformation, SecretKey key, IvParameterSpec iv, byte[] content) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        ParameterValidator.assertNotNull("file", file);
        ParameterValidator.assertNotEmpty("transformation", transformation);
        ParameterValidator.assertNotNull("key", key);
        ParameterValidator.assertNotNull("iv", iv);
        ParameterValidator.assertNotNull("content", content);
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, (Key)key, iv);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new CipherInputStream(new ByteArrayInputStream(content), cipher);
            out = new FileOutputStream(file);
            FileUtil.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static byte[] createRandomKey(int size) {
        byte[] result = new byte[size];
        SecureRandom rnd = new SecureRandom();
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (byte)rnd.nextInt(255);
        }
        return result;
    }

    public static void main(String[] args) {
        IvParameterSpec iv;
        SecretKeySpec key;
        byte[] keyBytes = SimpleCryptoHelper.createRandomKey(16);
        byte[] ivBytes = SimpleCryptoHelper.createRandomKey(16);
        try {
            int i2;
            key = new SecretKeySpec(keyBytes, "AES");
            iv = new IvParameterSpec(ivBytes);
            String text = "Test.";
            for (int i3 = 0; i3 < 9; ++i3) {
                text = text + text;
            }
            System.out.println(text);
            byte[] content = text.getBytes();
            SimpleCryptoHelper.save(new File("C:\\safeFaile.dat"), TR_AES_CTR_NoPadding, key, iv, content);
            System.out.println("Key:");
            for (i2 = 0; i2 < keyBytes.length; ++i2) {
                System.out.print(keyBytes[i2]);
                System.out.print(", ");
            }
            System.out.println();
            System.out.println("IV:");
            for (i2 = 0; i2 < ivBytes.length; ++i2) {
                System.out.print(ivBytes[i2]);
                System.out.print(", ");
            }
            System.out.println();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println();
        try {
            key = new SecretKeySpec(keyBytes, "AES");
            iv = new IvParameterSpec(ivBytes);
            byte[] content = SimpleCryptoHelper.load(new File("C:\\safeFaile.dat"), TR_AES_CTR_NoPadding, key, iv);
            String text = new String(content);
            System.out.println(text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

