/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import pl.com.kir.util.ParameterValidator;

public class SimpleCache
implements Serializable {
    private Map<Object, Element> cache = new TreeMap<Object, Element>();
    private long timeout = -1L;
    private int maxSize = -1;
    private static final long serialVersionUID = -2225101435025197722L;

    public SimpleCache(int maxSize) {
        this(maxSize, -1L);
    }

    public SimpleCache(int maxSize, long timeout) {
        ParameterValidator.assertRange("maxSize", maxSize, 1, Integer.MAX_VALUE);
        this.maxSize = maxSize;
        this.timeout = timeout;
    }

    public synchronized void put(Object key, Object value) {
        ParameterValidator.assertNotNull("key", key);
        ParameterValidator.assertNotNull("value", value);
        this.cache.put(key, new Element(key, value, System.currentTimeMillis()));
        if (this.cache.size() > this.maxSize) {
            this.check();
        }
    }

    public Object get(Object key) {
        Object result = null;
        Element element = this.cache.get(key);
        if (element != null) {
            if (this.timeout <= 0L || element.time + this.timeout > System.currentTimeMillis()) {
                result = element.value;
            } else {
                this.cache.remove(element.key);
            }
        }
        return result;
    }

    public Object remove(Object key) {
        Element element = this.cache.remove(key);
        if (element != null) {
            return element.value;
        }
        return null;
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        ParameterValidator.assertRange("maxSize", maxSize, 1, Integer.MAX_VALUE);
        this.maxSize = maxSize;
        this.check();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.check();
    }

    public Set<Object> keySet() {
        return new TreeSet<Object>(this.cache.keySet());
    }

    private void check() {
        long minTime = 0L;
        Object minKey = null;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Element element : this.cache.values()) {
            if (this.timeout > 0L && element.time + this.timeout < System.currentTimeMillis()) {
                list.add(element.key);
                continue;
            }
            if (minTime > 0L) {
                if (element.time >= minTime) continue;
                minTime = element.time;
                minKey = element.key;
                continue;
            }
            minTime = element.time;
            minKey = element.key;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.cache.remove(list.get(i2));
        }
        if (this.cache.size() > this.maxSize) {
            this.cache.remove(minKey);
        }
    }

    private class Element
    implements Serializable {
        private static final long serialVersionUID = -5943973600217735632L;
        public Object key = null;
        public Object value = null;
        public long time = 0L;

        public Element(Object key, Object value, long time) {
            this.key = key;
            this.value = value;
            this.time = time;
        }
    }
}

