/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import pl.com.kir.util.FileUtil;
import pl.com.kir.util.SimpleCache;

public class ResourceManager {
    private String resourceRoot = null;
    private ResourceBundle resourceBundle = null;
    private SimpleCache iconCache = null;

    public ResourceManager(String baseName, String resourceRoot, int iconCacheSize, long iconCacheTimeOut) {
        this(baseName, resourceRoot, iconCacheSize, iconCacheTimeOut, null);
    }

    public ResourceManager(String baseName, String resourceRoot, int iconCacheSize, long iconCacheTimeOut, Locale locale) {
        this.resourceBundle = locale != null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName);
        this.resourceRoot = resourceRoot;
        this.iconCache = new SimpleCache(iconCacheSize, iconCacheTimeOut);
    }

    private String getClassName(Class<?> clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public String getString(String key) {
        return this.getString(null, key);
    }

    public String getString(Class<?> clazz, String key) {
        if (clazz != null) {
            return this.resourceBundle.getString(this.getClassName(clazz) + "." + key);
        }
        return this.resourceBundle.getString("." + key);
    }

    public ImageIcon getImage(String path) {
        Image image;
        URL url;
        ImageIcon imageIcon = (ImageIcon)this.iconCache.get(path);
        if (imageIcon == null && (url = ResourceManager.class.getClassLoader().getResource(path)) != null && (image = Toolkit.getDefaultToolkit().createImage(url)) != null) {
            imageIcon = new ImageIcon(image);
            this.iconCache.put(path, imageIcon);
        }
        return imageIcon;
    }

    public ImageIcon getImageByRelativePath(String path) {
        return this.getImage(this.resourceRoot + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadResource(Class<?> clazz, String resource) throws IOException {
        byte[] result = null;
        try (InputStream is = null;){
            is = clazz.getResourceAsStream(resource);
            result = FileUtil.loadFile(is);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(Class<?> clazz, String resource, File file) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = clazz.getResourceAsStream(resource);
            os = new FileOutputStream(file);
            FileUtil.copy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.flush();
                ((FileOutputStream)os).close();
            }
        }
    }
}

