/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import pl.com.kir.util.ParameterValidator;

public class RectangleWrapper {
    private Point leftTopPoint = null;
    private Point rightBottomPoint = null;

    public RectangleWrapper(Point p1, Point p2) {
        ParameterValidator.assertNotNull("p1", p1);
        ParameterValidator.assertNotNull("p2", p2);
        this.leftTopPoint = p1;
        this.rightBottomPoint = p2;
        this.sortPoint();
    }

    public RectangleWrapper(Point point, int width, int height) {
        ParameterValidator.assertNotNull("point", point);
        this.leftTopPoint = point;
        this.rightBottomPoint = new Point(point.x + width, point.y + height);
        this.sortPoint();
    }

    public Point getLeftTopPoint() {
        return this.leftTopPoint;
    }

    public void setLeftTopPoint(Point leftTopPoint) {
        ParameterValidator.assertNotNull("leftTopPoint", leftTopPoint);
        this.leftTopPoint = leftTopPoint;
        this.sortPoint();
    }

    public Point getRightBottomPoint() {
        return this.rightBottomPoint;
    }

    public void setRightBottomPoint(Point rightBottomPoint) {
        ParameterValidator.assertNotNull("rightBottomPoint", rightBottomPoint);
        this.rightBottomPoint = rightBottomPoint;
        this.sortPoint();
    }

    public Point getLeftBottomPoint() {
        return new Point(this.leftTopPoint.x, this.rightBottomPoint.y);
    }

    public Point getRightTopPoint() {
        return new Point(this.rightBottomPoint.x, this.leftTopPoint.y);
    }

    public int getWidth() {
        return this.rightBottomPoint.x - this.leftTopPoint.x;
    }

    public void setWidth(int width) {
        this.rightBottomPoint.x = this.leftTopPoint.x + width;
        this.sortPoint();
    }

    public int getHeight() {
        return this.rightBottomPoint.y - this.leftTopPoint.y;
    }

    public void setHeight(int height) {
        this.rightBottomPoint.y = this.leftTopPoint.y + height;
        this.sortPoint();
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public void setSize(int width, int height) {
        this.rightBottomPoint.x = this.leftTopPoint.x + width;
        this.rightBottomPoint.y = this.leftTopPoint.y + height;
        this.sortPoint();
    }

    public void setSize(Dimension size) {
        ParameterValidator.assertNotNull("rightBottomPoint", this.rightBottomPoint);
        this.setSize(size.width, size.height);
    }

    public void move(int x2, int y2) {
        this.leftTopPoint.x += x2;
        this.leftTopPoint.y += y2;
        this.rightBottomPoint.x += x2;
        this.rightBottomPoint.y += y2;
        this.sortPoint();
    }

    public void moveLeftTopPoint(int x2, int y2) {
        this.leftTopPoint.x += x2;
        this.leftTopPoint.y += y2;
        this.sortPoint();
    }

    public void moveRightBottomPoint(int x2, int y2) {
        this.rightBottomPoint.x += x2;
        this.rightBottomPoint.y += y2;
        this.sortPoint();
    }

    public void moveLeftBottomPoint(int x2, int y2) {
        this.leftTopPoint.x += x2;
        this.rightBottomPoint.y += y2;
        this.sortPoint();
    }

    public void moveRightTopPoint(int x2, int y2) {
        this.leftTopPoint.y += y2;
        this.rightBottomPoint.x += x2;
        this.sortPoint();
    }

    public boolean contains(Point point) {
        ParameterValidator.assertNotNull("point", point);
        return this.leftTopPoint.x <= point.x && point.x <= this.rightBottomPoint.x && this.leftTopPoint.y <= point.y && point.y <= this.rightBottomPoint.y;
    }

    public Rectangle toAWTRectangle() {
        return new Rectangle(this.leftTopPoint.x, this.leftTopPoint.y, this.getWidth(), this.getHeight());
    }

    public String toString() {
        return "(" + this.leftTopPoint.x + ", " + this.leftTopPoint.y + ") -> (" + this.rightBottomPoint.x + ", " + this.rightBottomPoint.y + ")";
    }

    private void sortPoint() {
        if (this.rightBottomPoint.x < this.leftTopPoint.x || this.rightBottomPoint.y < this.leftTopPoint.y) {
            int x1 = Math.min(this.leftTopPoint.x, this.rightBottomPoint.x);
            int y1 = Math.min(this.leftTopPoint.y, this.rightBottomPoint.y);
            int x2 = Math.max(this.leftTopPoint.x, this.rightBottomPoint.x);
            int y2 = Math.max(this.leftTopPoint.y, this.rightBottomPoint.y);
            this.leftTopPoint = new Point(x1, y1);
            this.rightBottomPoint = new Point(x2, y2);
        }
    }
}

