/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.util.Comparator;

public class PolishStringComparator
implements Comparator<String> {
    public static final char[] POLISH_CHARSET = new char[]{'A', 'a', '\u0104', '\u0105', 'B', 'b', 'C', 'c', '\u0106', '\u0107', 'D', 'd', 'E', 'e', '\u0118', '\u0119', 'F', 'f', 'G', 'g', 'H', 'h', 'I', 'i', 'J', 'j', 'K', 'k', 'L', 'l', '\u0141', '\u0142', 'M', 'm', 'N', 'n', '\u0143', '\u0144', 'O', 'o', '\u00d3', '\u00f3', 'P', 'p', 'Q', 'q', 'R', 'r', 'S', 's', '\u015a', '\u015b', 'T', 't', 'U', 'u', 'V', 'v', 'W', 'w', 'X', 'x', 'Y', 'y', 'Z', 'z', '\u0179', '\u017a', '\u017b', '\u017c'};
    private char[] charset = POLISH_CHARSET;

    public PolishStringComparator() {
    }

    public PolishStringComparator(char[] charset) {
        if (charset != null && charset.length > 0) {
            this.charset = charset;
        }
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1.compareTo(s2) == 0) {
            return 0;
        }
        try {
            int t2 = 0;
            int k2 = 0;
            while ((t2 = this.compare(s1.charAt(k2), s2.charAt(k2))) == 0) {
                ++k2;
            }
            return t2;
        }
        catch (Exception ex) {
            if (s1.length() < s2.length()) {
                return -1;
            }
            return 1;
        }
    }

    @Override
    public int compare(char c1, char c2) {
        if (c1 == c2) {
            return 0;
        }
        int i1 = -1;
        int i2 = -1;
        for (int i3 = 0; i3 < this.charset.length && (i1 < 0 || i2 < 0); ++i3) {
            if (c1 == this.charset[i3]) {
                i1 = i3;
            }
            if (c2 != this.charset[i3]) continue;
            i2 = i3;
        }
        if (i1 < 0) {
            i1 = this.charset.length + Character.getNumericValue(c1);
        }
        if (i2 < 0) {
            i2 = this.charset.length + Character.getNumericValue(c2);
        }
        if (i1 < i2) {
            return -1;
        }
        return 1;
    }
}

