/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.util.Date;
import java.util.GregorianCalendar;
import pl.com.kir.util.DateTimeHelper;

public class PolishCalendar {
    private static final String[] DAYS_1 = new String[]{"Niedziela", "Poniedzia\u0142ek", "Wtorek", "\u015aroda", "Czwartek", "Pi\u0105tek", "Sobota"};
    private static final String[] DAYS_2 = new String[]{"ND", "PN", "WT", "\u015aR", "CZ", "PT", "SO"};
    private static final String[] MONTHS_1 = new String[]{"stycze\u0144", "luty", "marzec", "kwiecie\u0144", "maj", "czerwiec", "lipiec", "sierpie\u0144", "wrzesie\u0144", "pa\u017adziernik", "listopad", "grudzie\u0144"};
    private static final String[] MONTHS_2 = new String[]{"stycznia", "lutego", "marca", "kwietnia", "maja", "czerwca", "lipca", "sierpnia", "wrze\u015bnia", "pa\u017adziernika", "listopada", "grudnia"};

    private PolishCalendar() {
    }

    public static String getCurrentDate(boolean dayOfWeekVisible) {
        return PolishCalendar.getDate(new Date(), dayOfWeekVisible);
    }

    public static String getDate(Date date, boolean dayOfWeekVisible) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        StringBuffer buffer = new StringBuffer();
        if (dayOfWeekVisible) {
            buffer.append(DAYS_1[dayOfWeek - 1]);
            buffer.append(", ");
        }
        buffer.append(day);
        buffer.append(" ");
        buffer.append(MONTHS_2[month]);
        buffer.append(" ");
        buffer.append(year);
        buffer.append(" r.");
        return buffer.toString();
    }

    public static String getDate(int year, int month, int day, boolean dayOfWeekVisible) {
        return PolishCalendar.getDate(DateTimeHelper.toDate(year, month, day), dayOfWeekVisible);
    }

    public static String getCurrentDayOfWeek() {
        return PolishCalendar.getDayOfWeek(new Date());
    }

    public static String getDayOfWeek(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return DAYS_1[dayOfWeek - 1];
    }

    public static String getDayOfWeekShort(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return DAYS_2[dayOfWeek - 1];
    }

    public static String getMonthName(int month) {
        return MONTHS_1[month - 1];
    }
}

