/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

public class ParameterValidator {
    private ParameterValidator() {
    }

    public static void assertNotNull(String paramName, Object paramValue) {
        if (paramValue == null) {
            throw new IllegalArgumentException("Parametr '" + paramName + "' jest NULL.");
        }
    }

    public static void assertNotEmpty(String paramName, String paramValue) {
        ParameterValidator.assertNotNull(paramName, paramValue);
        if (paramValue.length() == 0) {
            throw new IllegalArgumentException("Parametr '" + paramName + "' jest PUSTY");
        }
    }

    public static void assertRange(String paramName, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Parametr z poza zakresu (" + min + " <= '" + paramName + "' <= " + max + ")");
        }
    }

    public static void assertRange(String paramName, int value, int min, int max) {
        ParameterValidator.assertRange(paramName, (long)value, (long)min, (long)max);
    }

    public static void assertRange(String paramName, double value, double min, double max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Parametr z poza zakresu (" + min + " <= '" + paramName + "' <= " + max + ")");
        }
    }

    public static void assertRange(String paramName, float value, float min, float max) {
        ParameterValidator.assertRange(paramName, (double)value, (double)min, (double)max);
    }

    public static void assertPositiveNumber(String paramName, long paramValue) {
        if (paramValue <= 0L) {
            throw new IllegalArgumentException("Argument '" + paramName + "' > 0");
        }
    }

    public static void assertPositiveNumber(String paramName, double paramValue) {
        if (paramValue <= 0.0) {
            throw new IllegalArgumentException("Argument '" + paramName + "' > 0");
        }
    }

    public static void assertPositiveNumber(String paramName, String paramValue) {
        try {
            ParameterValidator.assertPositiveNumber(paramName, Double.parseDouble(paramValue));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Argument '" + paramName + "' > 0");
        }
    }

    public static void assertUnnegativeNumber(String paramName, long paramValue) {
        if (paramValue < 0L) {
            throw new IllegalArgumentException("Argument '" + paramName + "' >= 0");
        }
    }

    public static void assertUnnegativeNumber(String paramName, double paramValue) {
        if (paramValue < 0.0) {
            throw new IllegalArgumentException("Argument '" + paramName + "' >= 0");
        }
    }

    public static void assertUnnegativeNumber(String paramName, String paramValue) {
        try {
            ParameterValidator.assertUnnegativeNumber(paramName, Double.parseDouble(paramValue));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Argument '" + paramName + "' >= 0");
        }
    }
}

