/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

public class OSHelper {
    private static String OS_NAME = System.getProperty("os.name").toLowerCase();

    private OSHelper() {
    }

    public static OS getOS() {
        if (OS_NAME.indexOf("win") >= 0) {
            return OS.Windows;
        }
        if (OS_NAME.indexOf("mac") >= 0) {
            return OS.Mac;
        }
        if (OS_NAME.indexOf("nix") >= 0 || OS_NAME.indexOf("nux") >= 0 || OS_NAME.indexOf("aix") > 0) {
            return OS.Unix;
        }
        if (OS_NAME.indexOf("sunos") >= 0) {
            return OS.Solaris;
        }
        return null;
    }

    public static boolean isWindows() {
        return OSHelper.getOS() == OS.Windows;
    }

    public static boolean isMac() {
        return OSHelper.getOS() == OS.Mac;
    }

    public static boolean isUnix() {
        return OSHelper.getOS() == OS.Unix;
    }

    public static boolean isSolaris() {
        return OSHelper.getOS() == OS.Solaris;
    }

    public static enum OS {
        Windows,
        Mac,
        Unix,
        Solaris;

    }
}

