/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.PrintStream;
import pl.com.kir.util.SizeFormatter;

public class MemoryReporter {
    private static long maxUsed = 0L;

    private MemoryReporter() {
    }

    public static String getTotalMemeory() {
        Runtime runtime = Runtime.getRuntime();
        return MemoryReporter.getSize(runtime.totalMemory());
    }

    public static String getMaxMemeory() {
        Runtime runtime = Runtime.getRuntime();
        return MemoryReporter.getSize(runtime.maxMemory());
    }

    public static String getFreeMemeory() {
        Runtime runtime = Runtime.getRuntime();
        return MemoryReporter.getSize(runtime.freeMemory());
    }

    public static String getUsedMemeory() {
        Runtime runtime = Runtime.getRuntime();
        long used = runtime.totalMemory() - runtime.freeMemory();
        if (used > maxUsed) {
            maxUsed = used;
        }
        return MemoryReporter.getSize(used);
    }

    public static String getReport() {
        StringBuffer result = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        long used = runtime.totalMemory() - runtime.freeMemory();
        if (used > maxUsed) {
            maxUsed = used;
        }
        result.append("Total memory        :" + MemoryReporter.getSize(runtime.totalMemory()));
        result.append("\r\n");
        result.append("Maximum memory      :" + MemoryReporter.getSize(runtime.maxMemory()));
        result.append("\r\n");
        result.append("Free memory         :" + MemoryReporter.getSize(runtime.freeMemory()));
        result.append("\r\n");
        result.append("Used memory         :" + MemoryReporter.getSize(used));
        result.append("\r\n");
        result.append("Maximum used memory :" + MemoryReporter.getSize(maxUsed));
        result.append("\r\n");
        return result.toString();
    }

    public static void print() {
        MemoryReporter.print(System.out);
    }

    public static void print(PrintStream out) {
        if (out != null) {
            out.println("----------------------------------------");
            out.print(MemoryReporter.getReport());
            out.println("----------------------------------------");
        }
    }

    private static String getSize(long size) {
        return SizeFormatter.getKilobytes(size, 1, 19);
    }

    public static void main(String[] args) {
        byte[] buffer = new byte[0x2000000];
        System.out.println("buffer.length = " + MemoryReporter.getSize(buffer.length));
        MemoryReporter.print();
        buffer = null;
        System.gc();
        MemoryReporter.print();
    }
}

