/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import pl.com.kir.util.FileUtil;
import pl.com.kir.util.ParameterValidator;

public class JARFileClassLoader
extends ClassLoader {
    private ArrayList<String> classList = new ArrayList();
    private ArrayList<DefClass> errorDefList = new ArrayList();

    public JARFileClassLoader() {
        super(JARFileClassLoader.class.getClassLoader());
    }

    private void defineClass(DefClass def) {
        try {
            Class<?> clazz = this.defineClass(def.name, def.content, 0, def.content.length);
            this.resolveClass(clazz);
            this.classList.add(def.name);
        }
        catch (Throwable th) {
            this.errorDefList.add(def);
        }
    }

    public void loadLibrary(File file) throws IOException {
        ParameterValidator.assertNotNull("file", file);
        if (file.exists()) {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryClassName = entry.getName();
                String ext = FileUtil.getExtension(entryClassName);
                if (!"class".equals(ext)) continue;
                entryClassName = entryClassName.substring(0, entryClassName.lastIndexOf(".class"));
                entryClassName = entryClassName.replace('/', '.');
                DefClass def = new DefClass();
                def.name = entryClassName;
                def.content = FileUtil.loadFile(jarFile.getInputStream(entry));
                this.defineClass(def);
            }
        }
        int size = this.errorDefList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            DefClass def = this.errorDefList.remove(0);
            this.defineClass(def);
        }
    }

    public void loadLibrary(String jarPathName) throws IOException {
        ParameterValidator.assertNotEmpty("jarName", jarPathName);
        this.loadLibrary(new File(jarPathName));
    }

    public void loadLibraries(File path) throws IOException {
        ParameterValidator.assertNotNull("path", path);
        if (path.exists() && path.isDirectory()) {
            File[] fileList = path.listFiles();
            for (int i2 = 0; i2 < fileList.length; ++i2) {
                File file = fileList[i2];
                if (file.isDirectory() || file.getName().indexOf(".jar") <= 0) continue;
                this.loadLibrary(file);
            }
        }
    }

    public void loadLibraries(String path) throws IOException {
        ParameterValidator.assertNotEmpty("path", path);
        this.loadLibraries(new File(path));
    }

    public String[] getClassNameArray() {
        return this.classList.toArray(new String[this.classList.size()]);
    }

    public Iterator<String> getClassNameIterator() {
        return this.classList.iterator();
    }

    private class DefClass {
        String name = null;
        byte[] content = null;

        private DefClass() {
        }
    }
}

