/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import pl.com.kir.util.ByteArrayUtil;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.SimpleFileFilter;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.lang.LongObject;

public class FileUtil {
    private static final int ZIP_BUFFER_SIZE = 262144;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(File file) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotNull("file", file);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int size = 0;
            while ((size = in.read(buffer)) != -1) {
                result.write(buffer, 0, size);
            }
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(String fileName) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (FileInputStream in = null;){
            in = new FileInputStream(fileName);
            byte[] buffer = new byte[1024];
            int size = 0;
            while ((size = in.read(buffer)) != -1) {
                result.write(buffer, 0, size);
            }
        }
        return result.toByteArray();
    }

    public static byte[] loadFile(InputStream is) throws IOException {
        ParameterValidator.assertNotNull("is", is);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int value = 0;
            while ((value = is.read()) != -1) {
                result.write(value);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(File file, long index, int size) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotNull("file", file);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (RandomAccessFile f2 = null;){
            f2 = new RandomAccessFile(file, "r");
            f2.seek(index);
            byte[] buffer = new byte[size];
            int readSize = f2.read(buffer);
            result.write(buffer, 0, readSize);
        }
        return result.toByteArray();
    }

    public static String loadTextFile(File file) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotNull("file", file);
        return StringUtil.toString(FileUtil.loadFile(file));
    }

    public static String loadTextFile(String fileName) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        return StringUtil.toString(FileUtil.loadFile(fileName));
    }

    public static String loadTextFile(String fileName, String charsetName) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        byte[] content = FileUtil.loadFile(fileName);
        if (charsetName != null) {
            return new String(content, charsetName);
        }
        return new String(content);
    }

    public static String loadTextFile(File file, String charsetName) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotNull("file", file);
        byte[] content = FileUtil.loadFile(file);
        if (charsetName != null) {
            return new String(content, charsetName);
        }
        return new String(content);
    }

    public static String loadTextFile(InputStream is) throws IOException {
        ParameterValidator.assertNotNull("is", is);
        byte[] content = FileUtil.loadFile(is);
        return StringUtil.toString(content);
    }

    public static String loadTextFile(InputStream is, String charsetName) throws IOException {
        ParameterValidator.assertNotNull("is", is);
        byte[] content = FileUtil.loadFile(is);
        if (charsetName != null) {
            return new String(content, charsetName);
        }
        return new String(content);
    }

    public static void saveFile(File file, byte[] content) throws IOException {
        ParameterValidator.assertNotNull("file", file);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(content);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void saveFile(String fileName, byte[] content) throws IOException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            out.write(content);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void saveTextFile(File file, String content) throws IOException {
        FileUtil.saveTextFile(file, content, null);
    }

    public static void saveTextFile(String fileName, String content) throws IOException {
        FileUtil.saveTextFile(fileName, content, null);
    }

    public static void saveTextFile(File file, String content, String charsetName) throws IOException {
        ParameterValidator.assertNotNull("file", file);
        if (content == null) {
            content = "";
        }
        if (charsetName != null) {
            FileUtil.saveFile(file, StringUtil.toByteArray(content, charsetName));
        } else {
            FileUtil.saveFile(file, content.getBytes());
        }
    }

    public static void saveTextFile(String fileName, String content, String charsetName) throws IOException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        if (content == null) {
            content = "";
        }
        if (charsetName != null) {
            FileUtil.saveFile(fileName, StringUtil.toByteArray(content, charsetName));
        } else {
            FileUtil.saveFile(fileName, content.getBytes());
        }
    }

    public static String getExtension(String fileName) {
        if (fileName != null) {
            int idx = fileName.lastIndexOf(".");
            if (idx >= 0) {
                return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            }
            return null;
        }
        return null;
    }

    public static String getExtension(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        return FileUtil.getExtension(file.getName());
    }

    public static void delete(File file) {
        ParameterValidator.assertNotNull("file", file);
        FileUtil.delete(file, false);
    }

    public static void delete(String path) {
        ParameterValidator.assertNotEmpty("path", path);
        FileUtil.delete(new File(path));
    }

    public static void delete(File file, boolean onlyContent) {
        ParameterValidator.assertNotNull("file", file);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] f2 = file.listFiles();
                for (int i2 = 0; i2 < f2.length; ++i2) {
                    if (f2[i2].isDirectory()) {
                        FileUtil.delete(f2[i2], false);
                    }
                    f2[i2].delete();
                }
                if (!onlyContent) {
                    file.delete();
                }
            } else {
                file.delete();
            }
        }
    }

    public static File[] getFiles(File path, boolean hidden) {
        File[] result = null;
        if (path != null) {
            result = path.listFiles(new SimpleFileFilter(false, true, hidden));
        }
        return result;
    }

    public static File[] getDirs(File path, boolean hidden) {
        File[] result = null;
        if (path != null) {
            result = path.listFiles(new SimpleFileFilter(true, false, hidden));
        }
        return result;
    }

    public static File[] getFilesAndDirs(File path, boolean hidden) {
        File[] result = null;
        if (path != null) {
            result = path.listFiles(new SimpleFileFilter(true, true, hidden));
        }
        return result;
    }

    public static File[] getFiles(File path, boolean hidden, Comparator<File> comparator) {
        File[] result = FileUtil.getFiles(path, hidden);
        if (result != null) {
            Arrays.sort(result, comparator);
        }
        return result;
    }

    public static File[] getDirs(File path, boolean hidden, Comparator<File> comparator) {
        File[] result = FileUtil.getDirs(path, hidden);
        if (result != null) {
            Arrays.sort(result, comparator);
        }
        return result;
    }

    public static File[] getFilesAndDirs(File path, boolean hidden, Comparator<File> comparator) {
        File[] result = FileUtil.getFilesAndDirs(path, hidden);
        if (result != null) {
            Arrays.sort(result, comparator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream source, OutputStream target) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(source);
            out = new BufferedOutputStream(target);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (out != null) {
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void copy(String source, String target) throws IOException {
        FileUtil.copy(new File(source), new File(target));
    }

    public static Object loadObject(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        ParameterValidator.assertNotNull("file", file);
        Object result = null;
        try (ObjectInputStream out = null;){
            out = new ObjectInputStream(new FileInputStream(file));
            result = out.readObject();
        }
        return result;
    }

    public static Object loadObject(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        Object result = null;
        try (ObjectInputStream out = null;){
            out = new ObjectInputStream(new FileInputStream(fileName));
            result = out.readObject();
        }
        return result;
    }

    public static void saveObject(File file, Object object) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotNull("file", file);
        ParameterValidator.assertNotNull("object", object);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(object);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void saveObject(String fileName, Object object) throws FileNotFoundException, IOException {
        ParameterValidator.assertNotEmpty("fileName", fileName);
        ParameterValidator.assertNotNull("object", object);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(fileName));
            out.writeObject(object);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) throws IOException {
        ParameterValidator.assertNotNull("file", file);
        long result = 0L;
        try (BufferedInputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(file));
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = is.read(buffer)) > 0) {
                crc.update(buffer, 0, len);
            }
            result = crc.getValue();
        }
        return result;
    }

    public static void extractZip(File fileZIP, String path) throws IOException, NoSuchAlgorithmException {
        ZipFile zipFile = new ZipFile(fileZIP);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (entry.getSize() == 0L) {
                File dir = new File(path + entry.getName());
                dir.mkdirs();
                continue;
            }
            byte[] content = FileUtil.loadFile(zipFile.getInputStream(entry));
            String name = path + entry.getName();
            try {
                FileUtil.saveFile(name, content);
            }
            catch (FileNotFoundException ex) {
                File filePath = new File(name).getParentFile();
                filePath.mkdirs();
                FileUtil.saveFile(name, content);
            }
        }
        zipFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(File f1, File f2) {
        ParameterValidator.assertNotNull("f1", f1);
        ParameterValidator.assertNotNull("f2", f2);
        boolean result = true;
        if (f1.exists() && f2.exists() && f1.length() == f2.length()) {
            FileInputStream is1 = null;
            InputStream is2 = null;
            try {
                is1 = new FileInputStream(f1);
                is2 = new FileInputStream(f2);
                byte[] bufferA1 = new byte[131072];
                byte[] bufferA2 = new byte[131072];
                int size1 = 0;
                int size2 = 0;
                while ((size1 = ((InputStream)is1).read(bufferA1)) > 0 && size1 == (size2 = is2.read(bufferA2))) {
                    byte[] bufferB1 = null;
                    bufferB1 = size1 == bufferA1.length ? bufferA1 : ByteArrayUtil.getArray(bufferA1, 0, size1);
                    byte[] bufferB2 = null;
                    bufferB2 = size2 == bufferA2.length ? bufferA2 : ByteArrayUtil.getArray(bufferA2, 0, size2);
                    if (ByteArrayUtil.equals(bufferB1, bufferB2)) continue;
                    break;
                }
                result = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (is1 != null) {
                    try {
                        ((InputStream)is1).close();
                    }
                    catch (IOException iOException) {}
                }
                if (is2 != null) {
                    try {
                        is2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static void archiveZip(File fileZIP, File sourcePath) throws IOException {
        FileUtil.archiveZip(fileZIP, sourcePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archiveZip(File fileZIP, File sourcePath, boolean onlyContent) throws IOException {
        ParameterValidator.assertNotNull("fileZIP", fileZIP);
        ParameterValidator.assertNotNull("sourcePath", sourcePath);
        ArrayList<String> fileList = new ArrayList<String>();
        LongObject dataSize = new LongObject(0L);
        FileUtil.readFileListToArchive(sourcePath, fileList, dataSize);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fileZIP));
        String root = sourcePath.getName();
        for (int i2 = 0; i2 < fileList.size(); ++i2) {
            String file = fileList.get(i2);
            String entryName = null;
            entryName = onlyContent ? file.substring(sourcePath.getAbsolutePath().length()).replace('\\', '/') : file.substring(sourcePath.getAbsolutePath().length() - root.length() - 1).replace('\\', '/');
            ZipEntry entry = new ZipEntry(entryName);
            File f2 = new File(file);
            out.putNextEntry(entry);
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(f2));
                byte[] buffer = new byte[262144];
                int len = 0;
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                continue;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                }
            }
        }
        out.flush();
        out.close();
    }

    private static void readFileListToArchive(File dir, List<String> resultList, LongObject dataSize) {
        File[] fileList = dir.listFiles();
        for (int i2 = 0; fileList != null && i2 < fileList.length; ++i2) {
            File f2 = fileList[i2];
            if (f2.isDirectory()) {
                FileUtil.readFileListToArchive(f2, resultList, dataSize);
                continue;
            }
            resultList.add(f2.getAbsolutePath());
            dataSize.value += f2.length();
        }
    }
}

