/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import pl.com.kir.util.ByteArrayUtil;
import pl.com.kir.util.FileUtil;
import pl.com.kir.util.IExtraFileTypeResolver;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.SimpleCache;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.lang.StringObject;
import pl.com.kir.util.xml.SimpleXMLErrorHandler;

public class FileTypeResolver {
    public static final String TYPE_TEXT = "document.text";
    public static final String TYPE_RTF = "document.rtf";
    public static final String TYPE_XML = "document.xml";
    public static final String TYPE_XML_MSWORD = "document.xml.msword";
    public static final String TYPE_PDF = "document.pdf";
    public static final String TYPE_BMP = "image.bmp";
    public static final String TYPE_GIF = "image.gif";
    public static final String TYPE_ANIMGIF = "image.gif.animated";
    public static final String TYPE_JPG = "image.jpg";
    public static final String TYPE_PNG = "image.png";
    public static final String TYPE_ZIP = "archive.zip";
    public static final String TYPE_JAR = "archive.jar";
    private static final Byte[][] PDF_FILE_SIG = new Byte[][]{{(byte)37, (byte)80, (byte)68, (byte)70}};
    private static final Byte[][] ZIP_FILE_SIG = new Byte[][]{{(byte)80, (byte)75, (byte)3, (byte)4}};
    private static final Byte[][] JPG_FILE_SIG = new Byte[][]{{(byte)-1, (byte)-40, (byte)-1, (byte)-32, null, null, (byte)74, (byte)70, (byte)73, (byte)70, (byte)0}, {(byte)-1, (byte)-40, (byte)-1, (byte)-31, null, null, (byte)69, (byte)120, (byte)105, (byte)102, (byte)0}, {(byte)-1, (byte)-40, (byte)-1, (byte)-24, null, null, (byte)83, (byte)80, (byte)73, (byte)70, (byte)70, (byte)0}};
    private static final Byte[][] PNG_FILE_SIG = new Byte[][]{{(byte)-119, (byte)80, (byte)78, (byte)71, (byte)13, (byte)10, (byte)26, (byte)10}};
    private static final Byte[][] BMP_FILE_SIG = new Byte[][]{{(byte)66, (byte)77}};
    private static final Byte[][] GIF_FILE_SIG = new Byte[][]{{(byte)71, (byte)73, (byte)70, (byte)56, (byte)55, (byte)97}, {(byte)71, (byte)73, (byte)70, (byte)56, (byte)57, (byte)97}};
    private boolean extraFileTypeResolverEnabled = true;
    private List<IExtraFileTypeResolver> resolverList = new ArrayList<IExtraFileTypeResolver>();
    private Map<String, Byte[][]> fileSignatureMap = new TreeMap<String, Byte[][]>();
    private Map<String, Byte[][]> fileSignatureBinaryMap = new TreeMap<String, Byte[][]>();
    private SimpleCache fileTypeCache = null;

    public FileTypeResolver() {
        this(null, null);
    }

    public FileTypeResolver(Integer cacheMaxSize, Long cacheTimeout) {
        this.fileSignatureMap.put(TYPE_PDF, PDF_FILE_SIG);
        this.fileSignatureMap.put(TYPE_JPG, JPG_FILE_SIG);
        this.fileSignatureMap.put(TYPE_PNG, PNG_FILE_SIG);
        this.fileSignatureMap.put(TYPE_ZIP, ZIP_FILE_SIG);
        this.fileSignatureBinaryMap.put(TYPE_BMP, BMP_FILE_SIG);
        this.fileSignatureBinaryMap.put(TYPE_GIF, GIF_FILE_SIG);
        int cacheMaxSizeValue = cacheMaxSize != null ? cacheMaxSize : 1024;
        long cahceTimeoutValue = cacheTimeout != null ? cacheTimeout : 240000L;
        this.fileTypeCache = new SimpleCache(cacheMaxSizeValue, cahceTimeoutValue);
    }

    public void addResolver(IExtraFileTypeResolver resolver) {
        ParameterValidator.assertNotNull("resolver", resolver);
        this.resolverList.add(resolver);
    }

    public void removeResolver(IExtraFileTypeResolver resolver) {
        ParameterValidator.assertNotNull("resolver", resolver);
        this.resolverList.remove(resolver);
    }

    public List<IExtraFileTypeResolver> getResolverList() {
        return new ArrayList<IExtraFileTypeResolver>(this.resolverList);
    }

    public boolean isExtraFileTypeResolverEnabled() {
        return this.extraFileTypeResolverEnabled;
    }

    public void setExtraFileTypeResolverEnabled(boolean extraFileTypeResolverEnabled) {
        if (this.extraFileTypeResolverEnabled != extraFileTypeResolverEnabled) {
            this.fileTypeCache.clear();
        }
        this.extraFileTypeResolverEnabled = extraFileTypeResolverEnabled;
    }

    public int getCacheMaxSize() {
        return this.fileTypeCache.getMaxSize();
    }

    public void setCacheMaxSize(int maxSize) {
        this.fileTypeCache.setMaxSize(maxSize);
    }

    public long getCacheTimeout() {
        return this.fileTypeCache.getTimeout();
    }

    public void setCacheTimeout(long timeout) {
        this.fileTypeCache.setTimeout(timeout);
    }

    public String getFileType(File file, boolean useCache) {
        ParameterValidator.assertNotNull("file", file);
        if (useCache) {
            String key = file.exists() ? file.getAbsolutePath() + "|" + file.lastModified() + "|" + file.length() : file.getAbsolutePath() + "|0|0";
            StringObject type = (StringObject)this.fileTypeCache.get(key);
            if (type != null) {
                return type.value;
            }
            String value = this.getFileType(file);
            this.fileTypeCache.put(key, new StringObject(value));
            return value;
        }
        return this.getFileType(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileType(File file) {
        Iterator<Object> iterator;
        ParameterValidator.assertNotNull("file", file);
        String result = null;
        if (this.extraFileTypeResolverEnabled) {
            Iterator<IExtraFileTypeResolver> iterator2 = this.resolverList.iterator();
            while (result == null && iterator2.hasNext()) {
                IExtraFileTypeResolver resolver = iterator2.next();
                if (resolver.getPriority() != 0) continue;
                result = resolver.getFileType(file);
            }
        }
        if (result != null) {
            return result;
        }
        byte[] buffer = null;
        try {
            buffer = FileUtil.loadFile(file, 0L, 131072);
        }
        catch (Exception ex) {
            buffer = null;
        }
        if (buffer != null && buffer.length > 0) {
            Object signature;
            Byte[] mask;
            iterator = this.fileSignatureMap.keySet().iterator();
            while (result == null && iterator.hasNext()) {
                String key = (String)iterator.next();
                Byte[][] sigArray = this.fileSignatureMap.get(key);
                for (int i2 = 0; result == null && i2 < sigArray.length; ++i2) {
                    mask = sigArray[i2];
                    if (buffer.length <= mask.length || !FileTypeResolver.equals(mask, (byte[])(signature = (Object)ByteArrayUtil.getArray(buffer, 0, mask.length)))) continue;
                    result = key;
                }
            }
            if (TYPE_ZIP.equals(result)) {
                block31: {
                    ZipInputStream zipIS = new ZipInputStream(new ByteArrayInputStream(buffer));
                    ZipEntry entry = zipIS.getNextEntry();
                    entry.getCrc();
                    ZipInputStream jarIS = null;
                    try {
                        jarIS = new JarInputStream(new ByteArrayInputStream(buffer));
                        ((JarInputStream)jarIS).getManifest().toString();
                        mask = TYPE_JAR;
                        if (jarIS == null) break block31;
                    }
                    catch (Exception ex) {
                        block32: {
                            try {
                                signature = TYPE_ZIP;
                                if (jarIS == null) break block32;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (jarIS != null) {
                                        jarIS.close();
                                    }
                                    throw throwable;
                                }
                                catch (Exception ex2) {
                                    result = null;
                                }
                            }
                            jarIS.close();
                        }
                        return signature;
                    }
                    jarIS.close();
                }
                return mask;
            }
            if (result == null) {
                boolean isBinaryFile = this.isBinaryFile(buffer);
                if (isBinaryFile) {
                    iterator = this.fileSignatureBinaryMap.keySet().iterator();
                    while (result == null && iterator.hasNext()) {
                        String key = (String)iterator.next();
                        Byte[][] sigArray = this.fileSignatureBinaryMap.get(key);
                        for (int i3 = 0; result == null && i3 < sigArray.length; ++i3) {
                            byte[] signature2;
                            Byte[] mask2 = sigArray[i3];
                            if (buffer.length <= mask2.length || !FileTypeResolver.equals(mask2, signature2 = ByteArrayUtil.getArray(buffer, 0, mask2.length))) continue;
                            result = key;
                        }
                    }
                    if (TYPE_GIF.equals(result)) {
                        byte gtc = buffer[10];
                        String gtcBinary = FileTypeResolver.toBinaryString(gtc);
                        boolean globalColorTableFlag = gtcBinary.charAt(0) == '1';
                        int sizeOfGlobalColorTable = 0;
                        if (globalColorTableFlag) {
                            sizeOfGlobalColorTable = (int)Math.pow(2.0, Integer.parseInt(gtcBinary.substring(5, 8), 2) + 1);
                        }
                        byte[] extension = ByteArrayUtil.getArray(buffer, 13 + 3 * sizeOfGlobalColorTable, 3);
                        if (ByteArrayUtil.equals(ByteArrayUtil.toByteArray("21FF0B"), extension)) {
                            result = TYPE_ANIMGIF;
                        }
                    }
                } else {
                    String text;
                    if (FileTypeResolver.isXML(file)) {
                        text = new String(buffer);
                        if (text.indexOf("<?mso-application") >= 0 && text.indexOf("Word.Document") >= 0) {
                            return TYPE_XML_MSWORD;
                        }
                        return TYPE_XML;
                    }
                    text = new String(buffer);
                    if (text.indexOf("{\\rtf") >= 0) {
                        return TYPE_RTF;
                    }
                    return TYPE_TEXT;
                }
            }
        }
        if (this.extraFileTypeResolverEnabled) {
            iterator = this.resolverList.iterator();
            while (result == null && iterator.hasNext()) {
                IExtraFileTypeResolver resolver = (IExtraFileTypeResolver)iterator.next();
                if (resolver.getPriority() == 0) continue;
                result = resolver.getFileType(file);
            }
        }
        return result;
    }

    private boolean isBinaryFile(byte[] buffer) {
        boolean result = false;
        int size = buffer.length > 131072 ? 131072 : buffer.length;
        int ch = 0;
        int count = 0;
        for (int i2 = 0; !result && i2 < size; ++i2) {
            int b2 = buffer[i2];
            if (b2 < 0) {
                b2 += 256;
            }
            if (b2 < 32 && b2 != 0 && b2 != 10 && b2 != 13 && b2 != 12 && b2 != 9) {
                result = true;
                continue;
            }
            if (i2 == 0) {
                ch = b2;
                count = 1;
                continue;
            }
            if (ch != b2) continue;
            ++count;
        }
        if (count == buffer.length) {
            result = true;
        }
        return result;
    }

    private static String toBinaryString(byte b2) {
        String result = null;
        int i2 = b2 >= 0 ? b2 : b2 + 256;
        result = Integer.toBinaryString(i2);
        result = StringUtil.fillLeft(result, 8, '0');
        return result;
    }

    private static boolean equals(Byte[] mask, byte[] buffer) {
        ParameterValidator.assertNotNull("mask", mask);
        ParameterValidator.assertNotNull("buffer", buffer);
        boolean result = true;
        if (mask.length != buffer.length) {
            result = false;
        } else {
            for (int i2 = 0; result && i2 < mask.length; ++i2) {
                if (mask[i2] == null) continue;
                result = mask[i2] == buffer[i2];
            }
        }
        return result;
    }

    public static boolean isXML(File file) {
        boolean result;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(file, (DefaultHandler)new SimpleXMLErrorHandler());
            result = true;
        }
        catch (Throwable ex) {
            result = false;
        }
        return result;
    }
}

