/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.File;
import java.util.Comparator;
import pl.com.kir.util.FileUtil;
import pl.com.kir.util.PolishStringComparator;

public class FileComparator
implements Comparator<File> {
    public static final int MODE_NAME = 0;
    public static final int MODE_EXT = 1;
    public static final char[] CHARSET = new char[]{' ', '!', '#', '$', '&', '(', ')', '+', '-', '=', '@', '[', ']', '^', '_', '{', '}', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'a', '\u0104', '\u0105', 'B', 'b', 'C', 'c', '\u0106', '\u0107', 'D', 'd', 'E', 'e', '\u0118', '\u0119', 'F', 'f', 'G', 'g', 'H', 'h', 'I', 'i', 'J', 'j', 'K', 'k', 'L', 'l', '\u0141', '\u0142', 'M', 'm', 'N', 'n', '\u0143', '\u0144', 'O', 'o', '\u00d3', '\u00f3', 'P', 'p', 'Q', 'q', 'R', 'r', 'S', 's', '\u015a', '\u015b', 'T', 't', 'U', 'u', 'V', 'v', 'W', 'w', 'X', 'x', 'Y', 'y', 'Z', 'z', '\u0179', '\u017a', '\u017b', '\u017c'};
    private int mode = 0;
    protected Comparator<String> stringComparator = null;

    public FileComparator() {
        this.stringComparator = new PolishStringComparator(CHARSET);
    }

    public FileComparator(int mode) {
        this.mode = mode;
        this.stringComparator = new PolishStringComparator(CHARSET);
    }

    public FileComparator(int mode, Comparator<String> stringComparator) {
        this.mode = mode;
        this.stringComparator = stringComparator;
    }

    @Override
    public int compare(File o1, File o2) {
        int result = 0;
        File f1 = o1;
        File f2 = o2;
        result = f1.isDirectory() && f2.isDirectory() ? this.compareName(f1, f2) : (f1.isFile() && f2.isFile() ? this.compareName(f1, f2) : (f1.isDirectory() ? -1 : 1));
        return result;
    }

    private int compareName(File f1, File f2) {
        int result = 0;
        String v1 = this.getValue(f1);
        String v2 = this.getValue(f2);
        result = this.stringComparator != null ? this.stringComparator.compare(v1, v2) : v1.compareTo(v2);
        return result;
    }

    private String getValue(File f2) {
        String result = null;
        if (this.mode != 1) {
            result = f2.getName();
        } else {
            String name = f2.getName();
            if (name.indexOf(".") == 0) {
                name = "";
            } else if (name.indexOf(".") > 0) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            String ext = FileUtil.getExtension(f2);
            result = ext == null ? "0||" + name : "1|" + ext + "|" + name;
        }
        return result;
    }
}

