/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import pl.com.kir.util.DateTimeFormat;
import pl.com.kir.util.ParameterValidator;

public class DateTimeHelper
implements DateTimeFormat {
    private DateTimeHelper() {
    }

    public static String toString(Date date) {
        return DateTimeHelper.toString(date, "yyyy-MM-dd");
    }

    public static String toString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date toDate(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(date);
    }

    public static String getCurrentDate() {
        return DateTimeHelper.toString(new Date(), "yyyy-MM-dd");
    }

    public static String getCurrentTime() {
        return DateTimeHelper.toString(new Date(), "HH:mm:ss");
    }

    public static String getCurrentDateTime() {
        return DateTimeHelper.toString(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDateTime(String format) {
        return DateTimeHelper.toString(new Date(), format);
    }

    public static Date toDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static Date toDate(int year, int month, int day, int hour, int minute, int second) {
        return DateTimeHelper.toDate(year, month, day, hour, minute, second, 0);
    }

    public static Date toDate(int year, int month, int day, int hour, int minute) {
        return DateTimeHelper.toDate(year, month, day, hour, minute, 0, 0);
    }

    public static Date toDate(int year, int month, int day) {
        return DateTimeHelper.toDate(year, month, day, 0, 0, 0, 0);
    }

    public static String toString(String date, String formatIN, String formatOUT) throws ParseException {
        Date temp = DateTimeHelper.toDate(date, formatIN);
        return DateTimeHelper.toString(temp, formatOUT);
    }

    public static boolean isInRange(Date value, Date min, Date max) {
        ParameterValidator.assertNotNull("value", value);
        boolean result = true;
        if (min == null && max == null) {
            throw new IllegalArgumentException("One of argument (min, max) must be definite");
        }
        if (min != null) {
            boolean bl2 = result = value.compareTo(min) >= 0;
        }
        if (max != null) {
            result = result && value.compareTo(max) <= 0;
        }
        return result;
    }
}

