/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import pl.com.kir.util.ParameterValidator;

public class CollectionHelper {
    private CollectionHelper() {
    }

    public static void sort(List list, Comparator comparator) {
        ParameterValidator.assertNotNull("list", list);
        ParameterValidator.assertNotNull("comparator", comparator);
        if (list.size() > 1) {
            CollectionHelper.sort(list, 0, list.size() - 1, comparator);
        }
    }

    private static void sort(List list, int indexMin, int indexMax, Comparator comparator) {
        int i2 = indexMin;
        int j2 = indexMax;
        Object x2 = list.get((indexMin + indexMax) / 2);
        while (true) {
            if (comparator.compare(list.get(i2), x2) < 0) {
                ++i2;
                continue;
            }
            while (comparator.compare(x2, list.get(j2)) < 0) {
                --j2;
            }
            if (i2 <= j2) {
                if (comparator.compare(list.get(i2), list.get(j2)) > 0) {
                    Object w2 = list.get(i2);
                    list.set(i2, list.get(j2));
                    list.set(j2, w2);
                }
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (indexMin < j2) {
            CollectionHelper.sort(list, indexMin, j2, comparator);
        }
        if (i2 < indexMax) {
            CollectionHelper.sort(list, i2, indexMax, comparator);
        }
    }

    public static void invertTheOrder(List list) {
        ParameterValidator.assertNotNull("list", list);
        ArrayList temp = new ArrayList(list);
        list.clear();
        while (!temp.isEmpty()) {
            list.add(temp.remove(temp.size() - 1));
        }
    }
}

