/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.StringUtil;

public class ByteArrayUtil {
    private ByteArrayUtil() {
    }

    public static byte[] clone(byte[] byteArray) {
        byte[] result = null;
        if (byteArray != null) {
            result = new byte[byteArray.length];
            for (int i2 = 0; i2 < byteArray.length; ++i2) {
                result[i2] = byteArray[i2];
            }
        }
        return result;
    }

    public static String toHexString(byte[] byteArray) {
        return ByteArrayUtil.toHexString(byteArray, null);
    }

    public static String toHexString(byte[] byteArray, String byteSeparator) {
        String result = null;
        if (byteArray != null) {
            result = "";
            for (int i2 = 0; i2 < byteArray.length; ++i2) {
                byte b2 = byteArray[i2];
                String value = b2 >= 0 ? Integer.toHexString(b2) : Integer.toHexString(b2 + 256);
                result = value.length() == 2 ? result + value : result + "0" + value;
                if (byteSeparator == null || i2 >= byteArray.length - 1) continue;
                result = result + byteSeparator;
            }
        }
        return result;
    }

    public static byte[] toByteArray(String hexString) {
        return ByteArrayUtil.toByteArray(hexString, null);
    }

    public static byte[] toByteArray(String hexString, String byteSeparator) {
        byte[] result = null;
        ParameterValidator.assertNotNull("hexString", hexString);
        if (StringUtil.isEmpty(byteSeparator) && hexString.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        String[] value = null;
        value = StringUtil.isEmpty(byteSeparator) ? StringUtil.toTokenArray(hexString, 2) : StringUtil.toTokenArray(hexString, byteSeparator);
        result = new byte[value.length];
        try {
            for (int i2 = 0; i2 < result.length; ++i2) {
                String hex = value[i2];
                if (hex.length() != 2) {
                    throw new IllegalArgumentException();
                }
                result[i2] = Integer.valueOf(value[i2], 16).byteValue();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static byte[] getArray(byte[] buffer, int index, int length) {
        ParameterValidator.assertNotNull("buffer", buffer);
        ParameterValidator.assertRange("index", index, 0, Integer.MAX_VALUE);
        ParameterValidator.assertRange("length", length, 0, Integer.MAX_VALUE);
        byte[] result = null;
        int size = -1;
        size = buffer.length < index ? 0 : (index + length <= buffer.length ? length : buffer.length - index);
        result = new byte[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result[i2] = buffer[index + i2];
        }
        return result;
    }

    public static boolean equals(byte[] bufferA, byte[] bufferB) {
        ParameterValidator.assertNotNull("bufferA", bufferA);
        ParameterValidator.assertNotNull("bufferB", bufferB);
        boolean result = true;
        if (bufferA.length != bufferB.length) {
            result = false;
        } else {
            for (int i2 = 0; result && i2 < bufferA.length; ++i2) {
                result = bufferA[i2] == bufferB[i2];
            }
        }
        return result;
    }

    public static int search(byte[] buffer, byte[] fragment) {
        ParameterValidator.assertNotNull("buffer", buffer);
        ParameterValidator.assertNotNull("fragment", fragment);
        int result = -1;
        if (buffer.length > 0 && fragment.length > 0) {
            for (int i2 = 0; result < 0 && i2 <= buffer.length - fragment.length; ++i2) {
                if (buffer[i2] != fragment[0]) continue;
                boolean flag = true;
                for (int q2 = 1; flag && q2 < fragment.length; ++q2) {
                    flag = buffer[i2 + q2] == fragment[q2];
                }
                if (!flag) continue;
                result = i2;
            }
        }
        return result;
    }

    public static boolean isEmpty(byte[] buffer) {
        return buffer == null || buffer.length == 0;
    }

    public static byte[] sum(byte[] array1, byte[] array2) {
        byte[] result = null;
        if (array1 != null || array2 != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (!ByteArrayUtil.isEmpty(array1)) {
                    out.write(array1);
                }
                if (!ByteArrayUtil.isEmpty(array2)) {
                    out.write(array2);
                }
                result = out.toByteArray();
            }
            catch (IOException ex) {
                return null;
            }
        }
        return result;
    }
}

