/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class AdvancedFileInputStream
extends FileInputStream {
    private long position = 0L;
    private long mark = 0L;
    private int readLimit = 0;

    public AdvancedFileInputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public AdvancedFileInputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public AdvancedFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
        this.readLimit = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result >= 0) {
            ++this.position;
        }
        if (this.readLimit > 0 && this.mark + (long)this.readLimit < this.position) {
            this.mark = 0L;
            this.readLimit = -1;
        }
        return result;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int result = super.read(b2);
        this.position += (long)result;
        if (this.readLimit > 0 && this.mark + (long)this.readLimit < this.position) {
            this.mark = 0L;
            this.readLimit = -1;
        }
        return result;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int result = super.read(b2, off, len);
        this.position += (long)result;
        if (this.readLimit > 0 && this.mark + (long)this.readLimit < this.position) {
            this.mark = 0L;
            this.readLimit = -1;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.getChannel().position(this.mark);
        this.position = this.mark;
    }
}

