/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_String
implements Serializable {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private String[] items = new String[this.max_size];

    public Vector_String(int number) {
        this.max_size = number;
        this.items = new String[this.max_size];
    }

    public Vector_String() {
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public final String[] get() {
        return this.items;
    }

    public final String elementAt(int id2) {
        String value = null;
        if (id2 < this.max_size) {
            value = this.items[id2];
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public final boolean contains(String value) {
        boolean flag = false;
        for (int i2 = 0; i2 < this.current_item; ++i2) {
            if (!this.items[i2].equals(value)) continue;
            i2 = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final void merge(int master, int child, String separator) {
        this.items[master] = this.items[master] + separator + this.items[child];
        this.items[child] = null;
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i2 = 0; i2 < this.current_item; ++i2) {
                this.items[i2] = null;
            }
        } else {
            for (int i3 = 0; i3 < this.max_size; ++i3) {
                this.items[i3] = null;
            }
        }
        this.current_item = 0;
    }

    public final void removeElementAt(int id2) {
        if (id2 >= 0) {
            System.arraycopy(this.items, id2 + 1, this.items, id2, this.current_item - 1 - id2);
            this.items[this.current_item - 1] = "";
        } else {
            this.items[0] = "";
        }
        --this.current_item;
    }

    public final void set(String[] new_items) {
        this.items = new_items;
    }

    public final void addElement(String value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(String new_name, int id2) {
        if (id2 >= this.max_size) {
            this.checkSize(id2);
        }
        this.items[id2] = new_name;
    }

    private void checkSize(int i2) {
        if (i2 >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i2) {
                this.max_size = i2 + this.increment_size + 2;
            }
            String[] temp = this.items;
            this.items = new String[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_String.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        String[] newItems = new String[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }
}

