/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.encoder.OutputFormat;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Path;

public class Vector_Object
implements Serializable {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private static final Integer GENERIC = 1;
    private static final Integer BASICSTROKE = 2;
    private static final Integer BUFFERED_IMAGE = 3;
    private static final Integer GENERAL_PATH = 4;
    private static final Integer T1GLYPH = 5;
    private static final Integer TTGLYPH = 6;
    private static final Integer AREA = 7;
    private static final Integer RECT = 8;
    private static final Integer T3GLYPH = 9;
    private static final Integer TEXTUREDPAINT = 10;
    private Object[] items = new Object[this.max_size];
    private int checkPoint = -1;

    public Vector_Object() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Object(int number) {
        this.max_size = number;
        this.items = new Object[this.max_size];
    }

    public final Object[] get() {
        return this.items;
    }

    public final Object pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(Object value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final boolean contains(Object value) {
        boolean flag = false;
        for (int i2 = 0; i2 < this.current_item; ++i2) {
            if (!this.items[i2].equals(value)) continue;
            i2 = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final void addElement(Object value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void setElementAt(Object new_name, int id2) {
        if (id2 >= this.max_size) {
            this.checkSize(id2);
        }
        this.items[id2] = new_name;
    }

    public final Object elementAt(int id2) {
        if (id2 >= this.max_size) {
            return null;
        }
        return this.items[id2];
    }

    public final void set(Object[] new_items) {
        this.items = new_items;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i2 = 0; i2 < this.current_item; ++i2) {
                this.items[i2] = null;
            }
        } else {
            for (int i3 = 0; i3 < this.max_size; ++i3) {
                this.items[i3] = null;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int id2) {
        if (id2 >= 0) {
            System.arraycopy(this.items, id2 + 1, this.items, id2, this.current_item - 1 - id2);
            this.items[this.current_item - 1] = null;
        } else {
            this.items[0] = null;
        }
        --this.current_item;
    }

    private void checkSize(int i2) {
        if (i2 >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i2) {
                this.max_size = i2 + this.increment_size + 2;
            }
            Object[] temp = this.items;
            this.items = new Object[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Object.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream bos) throws Exception {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(this.max_size);
        for (int i2 = 0; i2 < this.max_size; ++i2) {
            Object nextObj = this.items[i2];
            if (nextObj instanceof BasicStroke) {
                Vector_Object.writeBasicStroke(os, this.items[i2]);
                continue;
            }
            if (nextObj instanceof Rectangle2D) {
                Vector_Object.writeRectangle2D(os, this.items[i2]);
                continue;
            }
            if (nextObj instanceof BufferedImage) {
                Vector_Object.writeImage(os, (RenderedImage)nextObj);
                continue;
            }
            if (nextObj instanceof GeneralPath) {
                Vector_Object.writePath(os, this.items[i2]);
                continue;
            }
            if (nextObj instanceof T1Glyph) {
                Vector_Object.writeT1Glyph(os, nextObj);
                continue;
            }
            if (nextObj instanceof TTGlyph) {
                Vector_Object.writeTTGlpyh(os, nextObj);
                continue;
            }
            if (nextObj instanceof T3Glyph) {
                Vector_Object.writeT3Glyph(os, (T3Glyph)nextObj);
                continue;
            }
            if (nextObj instanceof PdfTexturePaint) {
                Vector_Object.writeTexturedPaint(os, (TexturePaint)nextObj);
                continue;
            }
            if (nextObj instanceof Area) {
                Vector_Object.writeArea(os, this.items[i2]);
                continue;
            }
            try {
                os.writeObject(GENERIC);
                os.writeObject(nextObj);
                continue;
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        os.close();
    }

    private static void writePath(ObjectOutput os, Object item) throws IOException {
        os.writeObject(GENERAL_PATH);
        PathSerializer.serializePath(os, ((Shape)item).getPathIterator(new AffineTransform()));
    }

    private static void writeImage(ObjectOutput os, RenderedImage nextObj) throws Exception {
        os.writeObject(BUFFERED_IMAGE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JDeli.write((BufferedImage)nextObj, OutputFormat.PNG, (OutputStream)baos);
        os.writeObject(baos.toByteArray());
    }

    private static void writeT1Glyph(ObjectOutput os, Object nextObj) throws IOException {
        os.writeObject(T1GLYPH);
        ((T1Glyph)nextObj).flushArea();
        os.writeObject(nextObj);
        ((T1Glyph)nextObj).writePathsToStream(os);
    }

    private static void writeTTGlpyh(ObjectOutput os, Object nextObj) throws IOException {
        os.writeObject(TTGLYPH);
        ((TTGlyph)nextObj).flushArea();
        os.writeObject(nextObj);
        ((TTGlyph)nextObj).writePathsToStream(os);
    }

    private static void writeT3Glyph(ObjectOutput os, T3Glyph nextObj) throws Exception {
        os.writeObject(T3GLYPH);
        nextObj.writePathsToStream(os);
    }

    private static void writeArea(ObjectOutput os, Object item) throws IOException {
        os.writeObject(AREA);
        Area area = (Area)item;
        PathIterator pathIterator = area.getPathIterator(new AffineTransform());
        PathSerializer.serializePath(os, pathIterator);
    }

    private static void writeTexturedPaint(ObjectOutput os, TexturePaint nextObj) throws Exception {
        os.writeObject(TEXTUREDPAINT);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JDeli.write(nextObj.getImage(), OutputFormat.PNG, (OutputStream)baos);
        os.writeObject(baos.toByteArray());
        Rectangle2D rect = nextObj.getAnchorRect();
        os.writeDouble(rect.getBounds2D().getX());
        os.writeDouble(rect.getBounds2D().getY());
        os.writeDouble(rect.getBounds2D().getWidth());
        os.writeDouble(rect.getBounds2D().getHeight());
    }

    private static void writeRectangle2D(ObjectOutput os, Object item) throws IOException {
        os.writeObject(RECT);
        Rectangle2D rect = (Rectangle2D)item;
        os.writeDouble(rect.getBounds2D().getX());
        os.writeDouble(rect.getBounds2D().getY());
        os.writeDouble(rect.getBounds2D().getWidth());
        os.writeDouble(rect.getBounds2D().getHeight());
    }

    private static void writeBasicStroke(ObjectOutput os, Object item) throws IOException {
        os.writeObject(BASICSTROKE);
        BasicStroke stroke = (BasicStroke)item;
        os.writeFloat(stroke.getLineWidth());
        os.writeInt(stroke.getEndCap());
        os.writeInt(stroke.getLineJoin());
        os.writeFloat(stroke.getMiterLimit());
        os.writeObject(stroke.getDashArray());
        os.writeFloat(stroke.getDashPhase());
    }

    public void restoreFromStream(ByteArrayInputStream bis) throws Exception {
        int size;
        ObjectInputStream os = new ObjectInputStream(bis);
        this.max_size = size = ((Integer)os.readObject()).intValue();
        this.items = new Object[size];
        for (int i2 = 0; i2 < size; ++i2) {
            Object nextObject;
            Integer type = (Integer)os.readObject();
            if (type.compareTo(BASICSTROKE) == 0) {
                nextObject = Vector_Object.handleBasicStroke(os);
            } else if (type.compareTo(RECT) == 0) {
                nextObject = Vector_Object.handleRect(os);
            } else if (type.compareTo(BUFFERED_IMAGE) == 0) {
                byte[] bytes = (byte[])os.readObject();
                nextObject = JDeli.read(bytes);
            } else {
                nextObject = type.compareTo(GENERAL_PATH) == 0 ? PathSerializer.deserializePath(os) : (type.compareTo(T1GLYPH) == 0 ? Vector_Object.handleT1Glyph(os) : (type.compareTo(TTGLYPH) == 0 ? Vector_Object.handleTTGlyph(os) : (type.compareTo(T3GLYPH) == 0 ? new T3Glyph(os) : (type.compareTo(TEXTUREDPAINT) == 0 ? Vector_Object.handleTexturedPaint(os) : (type.compareTo(AREA) == 0 ? Vector_Object.handleArea(os) : os.readObject())))));
            }
            this.items[i2] = nextObject;
        }
    }

    private static Object handleArea(ObjectInput os) throws ClassNotFoundException, IOException {
        GeneralPath path = PathSerializer.deserializePath(os);
        Area nextObject = path == null ? null : new Area(path);
        return nextObject;
    }

    private static Object handleTexturedPaint(ObjectInput os) throws Exception {
        byte[] bytes = (byte[])os.readObject();
        BufferedImage img = JDeli.read(bytes);
        float x2 = os.readFloat();
        float y2 = os.readFloat();
        float w2 = os.readFloat();
        float h2 = os.readFloat();
        Rectangle2D.Float anchor = new Rectangle2D.Float(x2, y2, w2, h2);
        return new PdfTexturePaint(img, anchor);
    }

    private static Object handleTTGlyph(ObjectInput os) throws ClassNotFoundException, IOException {
        TTGlyph glyph = (TTGlyph)os.readObject();
        int count = (Integer)os.readObject();
        GeneralPath[] paths = new GeneralPath[count];
        for (int j2 = 0; j2 < count; ++j2) {
            paths[j2] = PathSerializer.deserializePath(os);
        }
        Vector_Path vp = new Vector_Path();
        vp.set(paths);
        vp.setCurrent_item(paths.length);
        glyph.setPaths(vp);
        return glyph;
    }

    private static Object handleT1Glyph(ObjectInput os) throws IOException, ClassNotFoundException {
        T1Glyph glyph = (T1Glyph)os.readObject();
        int count = (Integer)os.readObject();
        GeneralPath[] paths = new GeneralPath[count];
        for (int j2 = 0; j2 < count; ++j2) {
            paths[j2] = PathSerializer.deserializePath(os);
        }
        Vector_Path vp = new Vector_Path();
        vp.set(paths);
        vp.setCurrent_item(paths.length);
        glyph.setPaths(vp);
        return glyph;
    }

    private static Object handleRect(ObjectInput os) throws IOException {
        float x2 = os.readFloat();
        float y2 = os.readFloat();
        float w2 = os.readFloat();
        float h2 = os.readFloat();
        return new Rectangle2D.Float(x2, y2, w2, h2);
    }

    private static Object handleBasicStroke(ObjectInput os) throws IOException, ClassNotFoundException {
        float w2 = os.readFloat();
        int current_line_cap_style = os.readInt();
        int current_line_join_style = os.readInt();
        float mitre_limit = os.readFloat();
        float[] current_line_dash_array = (float[])os.readObject();
        float current_line_dash_phase = os.readFloat();
        return new BasicStroke(w2, current_line_cap_style, current_line_join_style, mitre_limit, current_line_dash_array, current_line_dash_phase);
    }

    public void trim() {
        Object[] newItems = new Object[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }
}

