/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Int
implements Serializable {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private int[] items = new int[this.max_size];
    private int checkPoint = -1;

    public Vector_Int() {
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Int(int number) {
        this.max_size = number;
        this.items = new int[this.max_size];
    }

    public final synchronized int elementAt(int id2) {
        if (id2 >= this.max_size) {
            return 0;
        }
        return this.items[id2];
    }

    public final int[] get() {
        return this.items;
    }

    public final void setElementAt(int new_name, int id2) {
        if (id2 >= this.max_size) {
            this.checkSize(id2);
        }
        this.items[id2] = new_name;
    }

    public final void set(int[] new_items) {
        this.items = new_items;
    }

    public final void keep_larger(int master, int child) {
        if (this.items[master] < this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void keep_smaller(int master, int child) {
        if (this.items[master] > this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void clear() {
        this.checkPoint = -1;
        this.items = null;
        this.items = new int[this.max_size];
        if (this.current_item > 0) {
            for (int i2 = 0; i2 < this.current_item; ++i2) {
                this.items[i2] = 0;
            }
        } else {
            for (int i3 = 0; i3 < this.max_size; ++i3) {
                this.items[i3] = 0;
            }
        }
        this.current_item = 0;
    }

    public final synchronized int size() {
        return this.current_item + 1;
    }

    public final synchronized int getCapacity() {
        return this.items.length;
    }

    public final void removeElementAt(int id2) {
        if (id2 >= 0) {
            System.arraycopy(this.items, id2 + 1, this.items, id2, this.current_item - 1 - id2);
            this.items[this.current_item - 1] = 0;
        } else {
            this.items[0] = 0;
        }
        --this.current_item;
    }

    public final synchronized void deleteElementWithValue(int id2) {
        int currentSize = this.items.length;
        int[] newItems = new int[currentSize - 1];
        int counter = 0;
        for (int item : this.items) {
            if (item == id2) continue;
            newItems[counter] = item;
            ++counter;
        }
        this.items = newItems;
        --this.current_item;
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder("{");
        for (int item : this.items) {
            returnString.append(' ').append(item);
        }
        returnString.append("} ").append(this.current_item);
        return returnString.toString();
    }

    public final boolean contains(int value) {
        boolean flag = false;
        for (int i2 = 0; i2 < this.current_item; ++i2) {
            if (this.items[i2] != value) continue;
            i2 = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final int pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(int value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void addElement(int value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void add_together(int master, int child) {
        int n2 = master;
        this.items[n2] = this.items[n2] + this.items[child];
    }

    private void checkSize(int i2) {
        if (i2 >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i2) {
                this.max_size = i2 + this.increment_size + 2;
            }
            int[] temp = this.items;
            this.items = new int[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Int.incrementSize(this.increment_size);
        }
    }

    public final void reuse() {
        this.current_item = 0;
    }

    public void trim() {
        int[] newItems = new int[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }
}

