/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

class TextTokens {
    private final byte[] content;
    private int currentPointer;

    TextTokens(byte[] rawText) {
        this.content = rawText;
        this.currentPointer = 0;
    }

    boolean hasMoreTokens() {
        return this.currentPointer < this.content.length;
    }

    byte[] nextUnicode16Char() {
        byte[] first = this.nextUnicode16Token();
        if (first == null) {
            return null;
        }
        if ((first[0] & 0xFC) != 216) {
            return first;
        }
        byte[] second = this.nextUnicode16Token();
        if (second == null) {
            return null;
        }
        return new byte[]{first[0], first[1], second[0], second[1]};
    }

    private byte[] nextUnicode16Token() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        byte first = this.nextToken();
        if (!this.hasMoreTokens()) {
            return null;
        }
        return new byte[]{first, this.nextToken()};
    }

    byte[] nextUnicode8Char() {
        byte first = this.nextToken();
        if ((first & 0xE0) != 192) {
            return new byte[]{first};
        }
        if (!this.hasMoreTokens()) {
            return null;
        }
        byte second = this.nextToken();
        if ((first & 0xF0) != 224) {
            return new byte[]{first, second};
        }
        if (!this.hasMoreTokens()) {
            return null;
        }
        byte third = this.nextToken();
        if ((first & 0xF8) != 240) {
            return new byte[]{first, second, third};
        }
        if (!this.hasMoreTokens()) {
            return null;
        }
        return new byte[]{first, second, third, this.nextToken()};
    }

    byte nextToken() {
        if (!this.hasMoreTokens()) {
            return 0;
        }
        return this.getByte(this.currentPointer++);
    }

    private byte getByte(int pointer) {
        return this.content[pointer];
    }

    int getRawLength() {
        return this.content.length;
    }

    int getRemainingTokens() {
        return this.content.length - this.currentPointer;
    }

    boolean isUnicode16() {
        int currentPos = this.currentPointer;
        if (this.content.length >= 2 && this.nextToken() == -2 && this.nextToken() == -1) {
            return true;
        }
        this.currentPointer = currentPos;
        return false;
    }

    boolean isUnicode8() {
        int currentPos = this.currentPointer;
        if (this.content.length >= 3 && this.nextToken() == -17 && this.nextToken() == -69 && this.nextToken() == -65) {
            return true;
        }
        this.currentPointer = currentPos;
        return false;
    }
}

