/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import org.jpedal.utils.LogWriter;

public abstract class SwingWorker {
    private Object value;
    private final ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x2) {
        this.value = x2;
    }

    public abstract Object construct();

    public void interrupt() {
        Thread t2 = this.threadVar.get();
        if (t2 != null) {
            t2.interrupt();
            while (t2.isAlive()) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
        }
        this.threadVar.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        while (true) {
            Thread t2;
            if ((t2 = this.threadVar.get()) == null) {
                SwingWorker swingWorker = this;
                synchronized (swingWorker) {
                    return this.value;
                }
            }
            try {
                t2.join();
            }
            catch (InterruptedException e2) {
                LogWriter.writeLog("Exception in handling thread " + e2);
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    public SwingWorker() {
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Caught a Exception " + e2);
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
            }
        };
        Thread t2 = new Thread(doConstruct);
        t2.setDaemon(true);
        this.threadVar = new ThreadVar(t2);
    }

    public void start() {
        Thread t2 = this.threadVar.get();
        if (t2 != null) {
            t2.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t2) {
            this.thread = t2;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

