/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.UnsupportedEncodingException;
import org.jpedal.utils.LogWriter;

public final class Strip {
    private static final String strip_start_token_deliminator = "<&";
    private static final String strip_end_token_deliminator = ">;";

    private Strip() {
    }

    public static StringBuilder stripXML(String raw_data, boolean isXMLExtraction) {
        if (raw_data == null) {
            return null;
        }
        return Strip.stripXML(new StringBuilder(raw_data), isXMLExtraction);
    }

    public static StringBuilder stripXML(StringBuilder all_tags, boolean isXMLExtraction) {
        int rawLength = all_tags.length();
        StringBuilder general_buffer = new StringBuilder(rawLength);
        StringBuilder tag = new StringBuilder(rawLength);
        if (isXMLExtraction) {
            int start = 32;
            boolean inToken = false;
            boolean inAttributeValue = false;
            int length = all_tags.length();
            for (int i2 = 0; i2 < length; ++i2) {
                char next_token = all_tags.charAt(i2);
                boolean match = false;
                if (inToken && next_token == '\"') {
                    boolean bl2 = inAttributeValue = !inAttributeValue;
                }
                if (inToken && start == 38 && (next_token == '<' || next_token == '&')) {
                    general_buffer.append((CharSequence)tag);
                    tag = new StringBuilder(5);
                }
                if (!inAttributeValue && strip_start_token_deliminator.indexOf(next_token) != -1) {
                    inToken = true;
                    start = next_token;
                    match = true;
                }
                if (inToken && start == 38 && next_token == ' ') {
                    inToken = false;
                    general_buffer.append((CharSequence)tag);
                    tag = new StringBuilder(5);
                }
                if (!inToken) {
                    general_buffer.append(next_token);
                } else {
                    tag.append(next_token);
                }
                if (match) continue;
                int endPointer = strip_end_token_deliminator.indexOf(next_token);
                if (endPointer == 1 && start == 38) {
                    switch (tag.toString()) {
                        case "&lt;": {
                            general_buffer.append('<');
                            break;
                        }
                        case "&gt;": {
                            general_buffer.append('>');
                            break;
                        }
                        case "&amp;": {
                            general_buffer.append('&');
                            break;
                        }
                    }
                    inToken = false;
                    tag = new StringBuilder();
                    continue;
                }
                if (endPointer == 0 && start == 60) {
                    inToken = false;
                    tag = new StringBuilder();
                    continue;
                }
                if (inToken || next_token != '&') continue;
                general_buffer.append('&');
            }
        } else {
            general_buffer = all_tags;
        }
        return general_buffer;
    }

    public static StringBuilder stripXMLArrows(StringBuilder all_tags, boolean isXMLExtraction) {
        StringBuilder general_buffer = new StringBuilder();
        StringBuilder tag = new StringBuilder();
        if (all_tags == null) {
            return general_buffer;
        }
        if (isXMLExtraction) {
            int start = 32;
            boolean inToken = false;
            int length = all_tags.length();
            for (int i2 = 0; i2 < length; ++i2) {
                char next_token = all_tags.charAt(i2);
                if (strip_start_token_deliminator.indexOf(next_token) != -1) {
                    inToken = true;
                    start = next_token;
                }
                if (!inToken) {
                    general_buffer.append(next_token);
                } else {
                    tag.append(next_token);
                }
                int endPointer = strip_end_token_deliminator.indexOf(next_token);
                if (endPointer == 1 && start == 38) {
                    if (!"&lt;".equals(tag.toString()) && !"&gt;".equals(tag.toString())) {
                        general_buffer.append((CharSequence)tag);
                    }
                    inToken = false;
                    tag = new StringBuilder();
                    continue;
                }
                if (endPointer != 0 || start != 60) continue;
                inToken = false;
                tag = new StringBuilder();
            }
        } else {
            general_buffer = all_tags;
        }
        Strip.trim(general_buffer);
        return general_buffer;
    }

    public static StringBuilder trim(StringBuilder content_buffer) {
        char c2;
        int length = content_buffer.length();
        for (int i2 = length - 1; i2 > -1 && (c2 = content_buffer.charAt(i2)) == ' '; --i2) {
            content_buffer.deleteCharAt(i2);
        }
        return content_buffer;
    }

    public static String removeMultipleSpacesAndReturns(String data) {
        StringBuilder all_data = new StringBuilder(data);
        int i2 = 1;
        while (i2 < all_data.length()) {
            if (all_data.charAt(i2) == ' ' && all_data.charAt(i2 - 1) == ' ' || all_data.charAt(i2) == '\r' && all_data.charAt(i2 - 1) == '\r') {
                all_data.deleteCharAt(i2);
                continue;
            }
            ++i2;
        }
        return all_data.toString();
    }

    public static String stripSpaces(String data) {
        StringBuilder text = new StringBuilder(data);
        block0: while (text.length() > 0 && text.charAt(0) == ' ') {
            text.deleteCharAt(0);
            int pointer2 = text.length() - 1;
            while (pointer2 > 0 && text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
                if (--pointer2 >= 0) continue;
                continue block0;
            }
        }
        return text.toString();
    }

    public static String stripAllSpaces(String data) {
        StringBuilder text = new StringBuilder(data);
        int pointer2 = text.length() - 1;
        while (pointer2 > 0) {
            if (text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
            }
            if (--pointer2 >= 0) continue;
            break;
        }
        return text.toString();
    }

    public static void stripArrows(StringBuilder text) {
        int pointer2 = text.length() - 1;
        if (pointer2 >= 0) {
            do {
                if (text.charAt(pointer2) != '<' && text.charAt(pointer2) != '>') continue;
                text.deleteCharAt(pointer2);
            } while (--pointer2 >= 0);
        }
    }

    public static void stripAllSpaces(StringBuilder text) {
        int pointer2 = text.length() - 1;
        while (pointer2 > 0) {
            if (text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
            }
            if (--pointer2 >= 0) continue;
            break;
        }
    }

    public static String convertToText(String input, boolean isXMLExtraction) {
        StringBuilder output_data;
        if (isXMLExtraction) {
            byte[] rawData = Strip.toBytes(input);
            int length = rawData != null ? rawData.length : 0;
            int ptr = 0;
            boolean inToken = false;
            for (int i2 = 0; i2 < length; ++i2) {
                if (rawData[i2] == 60) {
                    inToken = true;
                    if (rawData[i2 + 1] != 83 || rawData[i2 + 2] != 112 || rawData[i2 + 3] != 97 || rawData[i2 + 4] != 99 || rawData[i2 + 5] != 101) continue;
                    rawData[ptr] = 9;
                    ++ptr;
                    continue;
                }
                if (rawData[i2] == 62) {
                    inToken = false;
                    continue;
                }
                if (inToken) continue;
                rawData[ptr] = rawData[i2];
                ++ptr;
            }
            byte[] cleanedString = new byte[ptr];
            System.arraycopy(rawData, 0, cleanedString, 0, ptr);
            output_data = new StringBuilder(new String(cleanedString));
        } else {
            output_data = new StringBuilder(input);
        }
        return output_data.toString();
    }

    public static String stripComment(String value) {
        if (value != null) {
            int pointer = value.indexOf("**");
            if (pointer > 0) {
                value = value.substring(0, pointer - 1).trim();
            }
            if (pointer == 0) {
                value = "";
            }
        }
        return value;
    }

    public static StringBuilder stripAmpHash(StringBuilder current_text) {
        StringBuilder sb = new StringBuilder();
        boolean inEscape = false;
        for (int i2 = 0; i2 < current_text.length(); ++i2) {
            char nextChar = current_text.charAt(i2);
            if (inEscape) {
                if (nextChar != ';') continue;
                inEscape = false;
                continue;
            }
            if (nextChar == '&') {
                inEscape = true;
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }

    public static byte[] toBytes(String value) {
        byte[] data = null;
        try {
            String name = System.getProperty("os.name");
            String enc = System.getProperty("file.encoding");
            if (!("UTF-8".equals(enc) || "MacRoman".equals(enc) || "Cp1252".equals(enc))) {
                enc = "Mac OS X".equals(name) ? "MacRoman" : (name.startsWith("Windows") ? "Cp1252" : "UTF-8");
            }
            data = value.getBytes(enc);
        }
        catch (UnsupportedEncodingException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return data;
    }
}

