/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TextTokens;

public final class StringUtils {
    private static String enc = System.getProperty("file.encoding");

    private StringUtils() {
    }

    public static String convertHexChars(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int escapeChar = value.indexOf(35);
        if (escapeChar == -1) {
            return value;
        }
        StringBuilder newString = new StringBuilder();
        int length = value.length();
        for (int ii = 0; ii < length; ++ii) {
            char c2 = value.charAt(ii);
            if (c2 == '#') {
                int end;
                if ((end = ++ii + 2) > length) {
                    end = length;
                }
                String key = value.substring(ii, end);
                c2 = (char)Integer.parseInt(key, 16);
                ++ii;
                if (c2 == ' ') continue;
                newString.append(c2);
                continue;
            }
            newString.append(c2);
        }
        return newString.toString();
    }

    public static boolean isNumber(String textString) {
        byte[] data = StringUtils.toBytes(textString);
        if (data == null) {
            throw new IllegalArgumentException("Bad String passed: " + textString);
        }
        int strLength = data.length;
        for (int j2 = 0; j2 < strLength; ++j2) {
            if (data[j2] >= 48 && data[j2] <= 57 || data[j2] == 46 || j2 == 0 && data[j2] == 45) continue;
            return false;
        }
        return true;
    }

    public static String getTextString(byte[] rawText, boolean keepReturns) {
        return StringUtils.getTextString(rawText, keepReturns, false);
    }

    public static String getTextString(byte[] rawText, boolean keepReturns, boolean keepTabs) {
        if (rawText == null) {
            return null;
        }
        StandardFonts.checkLoaded(6);
        TextTokens rawChars = new TextTokens(rawText);
        if (rawChars.isUnicode16()) {
            byte[] nextChar;
            byte[] text = new byte[rawChars.getRemainingTokens()];
            int nextIndex = 0;
            while (rawChars.hasMoreTokens() && (nextChar = rawChars.nextUnicode16Char()) != null) {
                if (nextChar.length > 2 || nextChar[0] != 0) {
                    for (byte nextByte : nextChar) {
                        text[nextIndex++] = nextByte;
                    }
                    continue;
                }
                int nextByte = nextChar[1];
                if (0 <= nextByte && nextByte < 32) {
                    if (nextByte == 10 || nextByte == 13) {
                        text[nextIndex++] = nextChar[0];
                        text[nextIndex++] = keepReturns ? nextByte : 32;
                        continue;
                    }
                    if (nextByte != 9) continue;
                    text[nextIndex++] = nextChar[0];
                    text[nextIndex++] = keepTabs ? nextByte : 32;
                    continue;
                }
                text[nextIndex++] = nextChar[0];
                text[nextIndex++] = nextByte;
            }
            return new String(text, 0, nextIndex, StandardCharsets.UTF_16);
        }
        if (rawChars.isUnicode8()) {
            byte[] nextChar;
            byte[] text = new byte[rawChars.getRemainingTokens()];
            int nextIndex = 0;
            while (rawChars.hasMoreTokens() && (nextChar = rawChars.nextUnicode8Char()) != null) {
                if (nextChar.length > 1) {
                    for (byte nextByte : nextChar) {
                        text[nextIndex++] = nextByte;
                    }
                    continue;
                }
                int nextByte = nextChar[0];
                if (0 <= nextByte && nextByte < 32) {
                    if (nextByte == 10 || nextByte == 13) {
                        text[nextIndex++] = keepReturns ? nextByte : 32;
                        continue;
                    }
                    if (nextByte != 9) continue;
                    text[nextIndex++] = keepTabs ? nextByte : 32;
                    continue;
                }
                text[nextIndex++] = nextByte;
            }
            return new String(text, 0, nextIndex, StandardCharsets.UTF_8);
        }
        char[] chars = new char[rawText.length * 2];
        int ii = 0;
        while (rawChars.hasMoreTokens()) {
            char nextChar = (char)(rawChars.nextToken() & 0xFF);
            String c2 = null;
            if (!keepTabs && nextChar == '\t' || !keepReturns && (nextChar == '\n' || nextChar == '\r')) {
                c2 = " ";
            } else if (keepReturns && (nextChar == '\n' || nextChar == '\r') || keepTabs && nextChar == '\t') {
                c2 = String.valueOf(nextChar).intern();
            } else if (nextChar > '\u001f' && nextChar < '\u00fd') {
                c2 = StandardFonts.getEncodedChar(6, nextChar);
            }
            if (c2 == null) continue;
            int len = c2.length();
            if (ii + len >= chars.length) {
                char[] tmp = new char[len + ii + 10];
                System.arraycopy(chars, 0, tmp, 0, chars.length);
                chars = tmp;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                chars[ii] = c2.charAt(i2);
                ++ii;
            }
        }
        return String.copyValueOf(chars, 0, ii);
    }

    public static byte[] toBytes(String value) {
        byte[] data = null;
        try {
            data = value.getBytes(enc);
        }
        catch (UnsupportedEncodingException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return data;
    }

    public static byte[] encodeString(String value) {
        return value.getBytes(StandardCharsets.UTF_16);
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder idBuilder = new StringBuilder();
        char[] values = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (byte idByte : bytes) {
            idBuilder.append(values[idByte >> 4 & 0xF]);
            idBuilder.append(values[idByte & 0xF]);
        }
        return idBuilder.toString();
    }

    static {
        if (!("UTF-8".equals(enc) || "MacRoman".equals(enc) || "Cp1252".equals(enc))) {
            enc = DecoderOptions.isRunningOnMac ? "MacRoman" : (DecoderOptions.isRunningOnWindows ? "Cp1252" : "UTF-8");
        }
    }
}

