/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.utils.LogWriter;

public class SecureDocumentBuilderFactory {
    private final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private String feature = null;

    public SecureDocumentBuilderFactory() {
        this(false);
    }

    public SecureDocumentBuilderFactory(boolean enableDTD) {
        try {
            if (enableDTD) {
                this.allowDoctypes();
            } else {
                this.disallowDoctypes();
            }
        }
        catch (ParserConfigurationException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
            LogWriter.writeLog("ParserConfigurationException was thrown. The feature '" + this.feature + "' is not configuring correctly.");
        }
    }

    private void disallowDoctypes() throws ParserConfigurationException {
        this.feature = "http://apache.org/xml/features/disallow-doctype-decl";
        this.dbf.setFeature(this.feature, true);
    }

    private void allowDoctypes() throws ParserConfigurationException {
        this.feature = "http://xml.org/sax/features/external-general-entities";
        this.dbf.setFeature(this.feature, false);
        this.feature = "http://xml.org/sax/features/external-parameter-entities";
        this.dbf.setFeature(this.feature, false);
        this.feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        this.dbf.setFeature(this.feature, false);
        this.dbf.setXIncludeAware(false);
        this.dbf.setExpandEntityReferences(false);
    }

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return this.dbf.newDocumentBuilder();
    }

    public void setIgnoringElementContentWhitespace(boolean bln) {
        this.dbf.setIgnoringElementContentWhitespace(bln);
    }

    public void setNamespaceAware(boolean bln) {
        this.dbf.setNamespaceAware(bln);
    }
}

