/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.jpedal.external.RemoteTracker;
import org.jpedal.utils.LogWriter;

public class RemoteTrackerInternal {
    private String uuid;
    private RemoteTracker remoteTrackerStub;

    public RemoteTrackerInternal() {
        try {
            String port = System.getProperty("com.idrsolutions.remoteTracker.port");
            String uuid = System.getProperty("com.idrsolutions.remoteTracker.uuid");
            if (port != null && uuid != null) {
                if (port.matches("^\\d+$")) {
                    Registry registry = LocateRegistry.getRegistry("localhost", Integer.parseInt(port));
                    this.remoteTrackerStub = (RemoteTracker)registry.lookup("com.idrsolutions.remoteTracker.stub");
                    this.uuid = uuid;
                } else {
                    LogWriter.writeLog("Unable to use RemoteTacker. RemoteTracker port value of \"" + port + "\" is not valid. Value number be a port number, anything other than a digit is invalid.");
                }
            }
        }
        catch (NotBoundException | RemoteException e2) {
            LogWriter.writeLog(e2);
        }
    }

    public void finishedPageDecoding(int rawPage) {
        if (this.remoteTrackerStub != null) {
            try {
                this.remoteTrackerStub.finishedPageDecoding(this.uuid, rawPage);
            }
            catch (RemoteException e2) {
                LogWriter.writeLog(e2);
            }
        }
    }
}

