/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpedal.utils.LogWriter;

public final class PolygonOffset {
    private PolygonOffset() {
    }

    public static Shape polygonOffset(Shape clipShape, int windingRule, float offsetAmount) {
        if (clipShape == null || offsetAmount == 0.0f) {
            return clipShape;
        }
        List<List<double[]>> shapes = PolygonOffset.extractVertices(clipShape);
        if (shapes == null) {
            return clipShape;
        }
        Rectangle2D clipBounds = clipShape.getBounds2D();
        double longLine = Math.sqrt(clipBounds.getWidth() * clipBounds.getWidth() + clipBounds.getHeight() * clipBounds.getHeight()) * 1.1;
        ArrayList<List<double[]>> newShapes = new ArrayList<List<double[]>>(shapes.size());
        for (int shapeIndex = 0; shapeIndex < shapes.size(); ++shapeIndex) {
            List<double[]> shape = shapes.get(shapeIndex);
            ArrayList<double[]> newShape = new ArrayList<double[]>(shape.size());
            for (int vertexIndex = 0; vertexIndex < shape.size(); ++vertexIndex) {
                double[] lVertex = shape.get((vertexIndex == 0 ? shape.size() : vertexIndex) - 1);
                double[] vertex = shape.get(vertexIndex);
                double[] rVertex = shape.get((vertexIndex + 1) % shape.size());
                double[] lDir = PolygonOffset.normaliseVector(new double[]{lVertex[0] - vertex[0], lVertex[1] - vertex[1]});
                double[] rDir = PolygonOffset.normaliseVector(new double[]{rVertex[0] - vertex[0], rVertex[1] - vertex[1]});
                double[] midDir = Math.abs(lDir[0] * rDir[0] + lDir[1] * rDir[1]) > 0.9999 ? new double[]{-lDir[1], lDir[0]} : PolygonOffset.normaliseVector(new double[]{lDir[0] + (rDir[0] - lDir[0]) * 0.5, lDir[1] + (rDir[1] - lDir[1]) * 0.5});
                double[] midLine = new double[]{midDir[0] * longLine, midDir[1] * longLine};
                double[][] testSegment = new double[][]{vertex, {vertex[0] + midLine[0], vertex[1] + midLine[1]}};
                if (windingRule == 0 && PolygonOffset.evenOddTest(testSegment, shapes, shapeIndex, vertexIndex) || windingRule == 1 && PolygonOffset.nonZeroTest(testSegment, shapes, shapeIndex, vertexIndex)) {
                    midDir = new double[]{-midDir[0], -midDir[1]};
                }
                newShape.add(new double[]{vertex[0] + midDir[0] * (double)offsetAmount, vertex[1] + midDir[1] * (double)offsetAmount});
            }
            newShapes.add(newShape);
        }
        return PolygonOffset.buildArea(windingRule, newShapes);
    }

    private static List<List<double[]>> extractVertices(Shape clipShape) {
        ArrayList<List<double[]>> shapes = new ArrayList<List<double[]>>();
        PathIterator it = clipShape.getPathIterator(null);
        ArrayList<double[]> vertices = new ArrayList<double[]>();
        double[] lastCoord = new double[]{0.0, 0.0};
        while (!it.isDone()) {
            double[] coords = new double[6];
            int command = it.currentSegment(coords);
            switch (command) {
                case 1: {
                    if (vertices.isEmpty()) {
                        vertices.add(Arrays.copyOf(lastCoord, 2));
                    }
                    lastCoord = Arrays.copyOf(coords, 2);
                    vertices.add(lastCoord);
                    break;
                }
                case 0: {
                    if (!vertices.isEmpty()) {
                        LogWriter.writeLog("Subpath not closed before MoveTo called, discarding open subpath");
                        vertices.clear();
                    }
                    lastCoord = Arrays.copyOf(coords, 2);
                    vertices.add(lastCoord);
                    break;
                }
                case 4: {
                    if (Arrays.equals((double[])vertices.get(vertices.size() - 1), (double[])vertices.get(0))) {
                        vertices.remove(vertices.size() - 1);
                    }
                    shapes.add(vertices);
                    lastCoord = (double[])vertices.get(0);
                    vertices = new ArrayList();
                    break;
                }
                default: {
                    LogWriter.writeLog("Encountered unhandled command: " + command + ", cannot proceed with polygon offsetting");
                    return null;
                }
            }
            it.next();
        }
        return shapes;
    }

    private static Area buildArea(int windingRule, List<List<double[]>> newShapes) {
        Path2D.Double path = new Path2D.Double(windingRule);
        for (List<double[]> shape : newShapes) {
            path.moveTo(shape.get(0)[0], shape.get(0)[1]);
            for (int i2 = 1; i2 < shape.size(); ++i2) {
                double[] vertex = shape.get(i2);
                path.lineTo(vertex[0], vertex[1]);
            }
            path.closePath();
        }
        return new Area(path);
    }

    private static double[] normaliseVector(double[] vertex) {
        double magnitude = Math.sqrt(vertex[0] * vertex[0] + vertex[1] * vertex[1]);
        return new double[]{vertex[0] / magnitude, vertex[1] / magnitude};
    }

    private static boolean pointSideOfSegment(double[][] segment, double[] point) {
        double cross = (segment[1][0] - segment[0][0]) * (point[1] - segment[0][1]) - (segment[1][1] - segment[0][1]) * (point[0] - segment[0][0]);
        return cross > 0.0;
    }

    private static boolean checkSegmentIntersection(double[][] segment1, double[][] segment2) {
        return PolygonOffset.pointSideOfSegment(segment2, segment1[0]) != PolygonOffset.pointSideOfSegment(segment2, segment1[1]) && PolygonOffset.pointSideOfSegment(segment1, segment2[0]) != PolygonOffset.pointSideOfSegment(segment1, segment2[1]);
    }

    private static boolean evenOddTest(double[][] testSegment, List<List<double[]>> shapes, int skipShapeIndex, int skipVertexIndex) {
        int intersections = 0;
        for (int shapeIndex = 0; shapeIndex < shapes.size(); ++shapeIndex) {
            List<double[]> shape = shapes.get(shapeIndex);
            for (int vertexIndex = 0; vertexIndex < shape.size(); ++vertexIndex) {
                if (shapeIndex == skipShapeIndex && (vertexIndex == skipVertexIndex || (vertexIndex == 0 ? shape.size() : vertexIndex) - 1 == skipVertexIndex) || !PolygonOffset.checkSegmentIntersection(testSegment, new double[][]{shape.get(vertexIndex), shape.get((vertexIndex + 1) % shape.size())})) continue;
                ++intersections;
            }
        }
        return intersections % 2 == 0;
    }

    private static boolean nonZeroTest(double[][] testSegment, List<List<double[]>> shapes, int skipShapeIndex, int skipVertexIndex) {
        int winding = 0;
        for (int shapeIndex = 0; shapeIndex < shapes.size(); ++shapeIndex) {
            List<double[]> shape = shapes.get(shapeIndex);
            for (int vertexIndex = 0; vertexIndex < shape.size(); ++vertexIndex) {
                double[][] segment;
                if (shapeIndex == skipShapeIndex && (vertexIndex == skipVertexIndex || (vertexIndex == shape.size() - 1 ? 0 : vertexIndex + 1) == skipVertexIndex) || !PolygonOffset.checkSegmentIntersection(testSegment, segment = new double[][]{shape.get(vertexIndex), shape.get((vertexIndex + 1) % shape.size())})) continue;
                winding += PolygonOffset.pointSideOfSegment(testSegment, segment[0]) ? 1 : -1;
            }
        }
        return winding != 0;
    }
}

