/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterResolution;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.utils.PdfPageFormat;

public class PdfBook
extends Book {
    private MediaSizeName pageSize;
    private boolean chooseSourceByPdfPageSize;
    private final boolean useExactPdfPageSize;
    private final PdfDecoderInt pdfDecoder;
    private final PrintService printingDevice;

    public PdfBook(PdfDecoderInt pdfDecoder, PrintService printingDevice, PrintRequestAttributeSet attributes) {
        Attribute res;
        if (printingDevice.isAttributeCategorySupported(PrinterResolution.class) && (res = attributes.get(PrinterResolution.class)) == null) {
            Attribute defaultRes = (Attribute)printingDevice.getDefaultAttributeValue(PrinterResolution.class);
            if (defaultRes == null) {
                PdfBook.setResolutionClosestTo(printingDevice, attributes);
            } else {
                attributes.add(defaultRes);
            }
        }
        ((PdfDecoder)pdfDecoder).swingPrinter.legacyPrintMode = false;
        this.pdfDecoder = pdfDecoder;
        this.printingDevice = printingDevice;
        boolean pageSizeSet = false;
        if (attributes != null) {
            Attribute[] aa2 = attributes.toArray();
            for (int i2 = 0; i2 < aa2.length; ++i2) {
                if (!(aa2[i2] instanceof MediaSizeName)) continue;
                this.pageSize = (MediaSizeName)aa2[i2];
                if (!printingDevice.isAttributeValueSupported(this.pageSize, new DocFlavor.BYTE_ARRAY(DocFlavor.BYTE_ARRAY.PNG.getMimeType()), attributes)) continue;
                pageSizeSet = true;
                i2 = aa2.length;
            }
        }
        if (!pageSizeSet) {
            this.pageSize = PdfPageFormat.getDefaultMediaSizeName(printingDevice);
        }
        this.chooseSourceByPdfPageSize = false;
        this.useExactPdfPageSize = false;
        ((PdfDecoder)pdfDecoder).setUsePDFPaperSize(false);
        for (int i3 = 0; i3 < pdfDecoder.getPageCount(); ++i3) {
            if (((PdfDecoder)pdfDecoder).getUserSetPageFormat(i3) == null) {
                this.append((Printable)((Object)pdfDecoder), PdfPageFormat.createPdfPageFormat(this.pageSize, printingDevice));
                continue;
            }
            this.append((Printable)((Object)pdfDecoder), ((PdfDecoder)pdfDecoder).getUserSetPageFormat(i3));
        }
    }

    private static void setResolutionClosestTo(PrintService printingDevice, AttributeSet attributes) {
        PrinterResolution[] supportedRes = (PrinterResolution[])printingDevice.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (supportedRes != null && supportedRes.length > 0) {
            int crossRes = 300;
            int feedRes = 300;
            PrinterResolution closestToRes = supportedRes[0];
            int closestToFeed = Math.abs(supportedRes[0].getFeedResolution(100) - 300);
            int closestToCross = Math.abs(supportedRes[0].getCrossFeedResolution(100) - 300);
            for (int i2 = 1; i2 < supportedRes.length; ++i2) {
                int feed = Math.abs(supportedRes[i2].getFeedResolution(100) - 300);
                int cross = Math.abs(supportedRes[i2].getCrossFeedResolution(100) - 300);
                if (feed >= closestToFeed || cross >= closestToCross) continue;
                closestToRes = supportedRes[i2];
                closestToFeed = feed;
                closestToCross = cross;
            }
            attributes.add(closestToRes);
        }
    }

    public void setChooseSourceByPdfPageSize(boolean b2) {
        ((PdfDecoder)this.pdfDecoder).setUsePDFPaperSize(b2);
        this.chooseSourceByPdfPageSize = b2;
        this.updatePages();
    }

    private void updatePages() {
        for (int i2 = 0; i2 < this.pdfDecoder.getPageCount(); ++i2) {
            PageFormat pf;
            if (this.chooseSourceByPdfPageSize) {
                pf = PdfPageFormat.getPageFormat(i2 + 1, this.pdfDecoder);
            } else if (this.useExactPdfPageSize) {
                Paper paper = new Paper();
                pf = new PageFormat();
                int w2 = this.pdfDecoder.getPdfPageData().getCropBoxWidth(i2);
                int h2 = this.pdfDecoder.getPdfPageData().getCropBoxHeight(i2);
                paper.setSize(w2, h2);
                paper.setImageableArea(0.0, 0.0, w2, h2);
                pf.setPaper(paper);
            } else {
                pf = ((PdfDecoder)this.pdfDecoder).getUserSetPageFormat(i2) == null ? PdfPageFormat.createPdfPageFormat(this.pageSize, this.printingDevice) : ((PdfDecoder)this.pdfDecoder).getUserSetPageFormat(i2);
            }
            this.setPage(i2, (Printable)((Object)this.pdfDecoder), pf);
        }
    }
}

