/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.jpedal.utils.LogWriter;

public final class ObjectCloneFactory {
    private ObjectCloneFactory() {
    }

    public static byte[] cloneArray(byte[] array) {
        if (array == null) {
            return null;
        }
        int count = array.length;
        byte[] returnValue = new byte[count];
        System.arraycopy(array, 0, returnValue, 0, count);
        return returnValue;
    }

    public static byte[][] cloneDoubleArray(byte[][] byteDArray) {
        if (byteDArray == null) {
            return null;
        }
        byte[][] tmp = new byte[byteDArray.length][];
        for (int b2 = 0; b2 < byteDArray.length; ++b2) {
            tmp[b2] = (byte[])byteDArray[b2].clone();
        }
        return tmp;
    }

    public static BufferedImage deepCopy(BufferedImage bi2) {
        if (bi2 == null) {
            return null;
        }
        ColorModel cm = bi2.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi2.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static Map<String, String> cloneMap(Map<String, String> optValues) {
        if (optValues != null) {
            try {
                Map tmpMap = (Map)optValues.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tmpMap.putAll(optValues);
                return tmpMap;
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        return null;
    }
}

