/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.jpedal.utils.LogWriter;

public final class Messages {
    private static Set<String> reportedValueMissing = new HashSet<String>();
    private static ResourceBundle bundle;
    private static boolean isInitialised;

    private Messages() {
    }

    public static void setBundle(ResourceBundle newBundle) {
        bundle = newBundle;
        if (!isInitialised) {
            Messages.init();
        }
    }

    public static String getMessage(String key) {
        String message = null;
        try {
            message = bundle.getString(key);
        }
        catch (Exception e2) {
            if (LogWriter.isRunningFromIDE && !reportedValueMissing.contains(key)) {
                System.err.println("error resource bundle expected for key " + key);
                reportedValueMissing.add(key);
            }
            LogWriter.writeLog("Exception: " + e2.getMessage() + " key=" + key);
        }
        if (message == null) {
            message = key;
        }
        if (message.isEmpty()) {
            message = key + "<<";
        }
        return message;
    }

    private static void init() {
        isInitialised = true;
        try {
            LogWriter.writeLog("Unable to open messages.properties from jar");
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String element = keys.nextElement();
                String line = (String)bundle.getObject(element);
                StringBuilder newMessage = new StringBuilder();
                StringTokenizer t2 = new StringTokenizer(line, "\\&;", true);
                boolean isAmpersand = false;
                while (t2.hasMoreTokens()) {
                    String ascii;
                    String nextValue;
                    if (isAmpersand) {
                        nextValue = "&";
                        isAmpersand = false;
                    } else {
                        nextValue = t2.nextToken();
                    }
                    if (t2.hasMoreTokens() && "\\".equals(nextValue)) {
                        ascii = t2.nextToken();
                        char c2 = ascii.charAt(0);
                        if (c2 == 'n') {
                            newMessage.append('\n');
                        } else if (c2 == ' ') {
                            newMessage.append(' ');
                        }
                        newMessage.append(ascii.substring(1));
                        continue;
                    }
                    if (t2.hasMoreTokens() && "&".equals(nextValue)) {
                        ascii = t2.nextToken();
                        if (t2.hasMoreTokens()) {
                            String end = t2.nextToken();
                            if ("&".equals(end)) {
                                newMessage.append('&');
                                newMessage.append(ascii);
                                isAmpersand = true;
                                continue;
                            }
                            if (";".equals(end)) {
                                if (ascii.startsWith("#")) {
                                    ascii = ascii.substring(1);
                                }
                                char c3 = (char)Integer.parseInt(ascii);
                                newMessage.append(c3);
                                continue;
                            }
                            if (t2.hasMoreTokens()) {
                                newMessage.append('&');
                            }
                            newMessage.append(ascii);
                            continue;
                        }
                        newMessage.append('&');
                        newMessage.append(ascii);
                        continue;
                    }
                    newMessage.append(nextValue);
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
            LogWriter.writeLog("Exception " + e2 + " loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            System.err.println("Exception loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
        }
    }

    public static void dispose() {
        reportedValueMissing = null;
        bundle = null;
        isInitialised = false;
    }
}

