/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jpedal.utils.LogWriter;

public final class Matrix {
    private Matrix() {
    }

    public static float[][] multiply(float[][] matrix1, float[][] matrix2) {
        float[][] output_matrix = new float[3][3];
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                output_matrix[row][col] = matrix1[row][0] * matrix2[0][col] + matrix1[row][1] * matrix2[1][col] + matrix1[row][2] * matrix2[2][col];
            }
        }
        return output_matrix;
    }

    private static double[][] multiply(double[][] matrix1, double[][] matrix2) {
        double[][] output_matrix = new double[3][3];
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                output_matrix[row][col] = matrix1[row][0] * matrix2[0][col] + matrix1[row][1] * matrix2[1][col] + matrix1[row][2] * matrix2[2][col];
            }
        }
        return output_matrix;
    }

    public static float[][] inverse(float[][] input_matrix) {
        float d2 = input_matrix[2][0] * input_matrix[0][1] * input_matrix[1][2] - input_matrix[2][0] * input_matrix[0][2] * input_matrix[1][1] - input_matrix[1][0] * input_matrix[0][1] * input_matrix[2][2] + input_matrix[1][0] * input_matrix[0][2] * input_matrix[2][1] + input_matrix[0][0] * input_matrix[1][1] * input_matrix[2][2] - input_matrix[0][0] * input_matrix[1][2] * input_matrix[2][1];
        float t00 = (input_matrix[1][1] * input_matrix[2][2] - input_matrix[1][2] * input_matrix[2][1]) / d2;
        float t01 = -(input_matrix[0][1] * input_matrix[2][2] - input_matrix[0][2] * input_matrix[2][1]) / d2;
        float t02 = (input_matrix[0][1] * input_matrix[1][2] - input_matrix[0][2] * input_matrix[1][1]) / d2;
        float t10 = -(-input_matrix[2][0] * input_matrix[1][2] + input_matrix[1][0] * input_matrix[2][2]) / d2;
        float t11 = (-input_matrix[2][0] * input_matrix[0][2] + input_matrix[0][0] * input_matrix[2][2]) / d2;
        float t12 = -(-input_matrix[1][0] * input_matrix[0][2] + input_matrix[0][0] * input_matrix[1][2]) / d2;
        float t20 = (-input_matrix[2][0] * input_matrix[1][1] + input_matrix[1][0] * input_matrix[2][1]) / d2;
        float t21 = -(-input_matrix[2][0] * input_matrix[0][1] + input_matrix[0][0] * input_matrix[2][1]) / d2;
        float t22 = (-input_matrix[1][0] * input_matrix[0][1] + input_matrix[0][0] * input_matrix[1][1]) / d2;
        float[][] output_matrix = new float[3][3];
        output_matrix[0][0] = t00;
        output_matrix[0][1] = t01;
        output_matrix[0][2] = t02;
        output_matrix[1][0] = t10;
        output_matrix[1][1] = t11;
        output_matrix[1][2] = t12;
        output_matrix[2][0] = t20;
        output_matrix[2][1] = t21;
        output_matrix[2][2] = t22;
        return output_matrix;
    }

    public static double[][] inverse(double[][] input_matrix) {
        double d2 = input_matrix[2][0] * input_matrix[0][1] * input_matrix[1][2] - input_matrix[2][0] * input_matrix[0][2] * input_matrix[1][1] - input_matrix[1][0] * input_matrix[0][1] * input_matrix[2][2] + input_matrix[1][0] * input_matrix[0][2] * input_matrix[2][1] + input_matrix[0][0] * input_matrix[1][1] * input_matrix[2][2] - input_matrix[0][0] * input_matrix[1][2] * input_matrix[2][1];
        double t00 = (input_matrix[1][1] * input_matrix[2][2] - input_matrix[1][2] * input_matrix[2][1]) / d2;
        double t01 = -(input_matrix[0][1] * input_matrix[2][2] - input_matrix[0][2] * input_matrix[2][1]) / d2;
        double t02 = (input_matrix[0][1] * input_matrix[1][2] - input_matrix[0][2] * input_matrix[1][1]) / d2;
        double t10 = -(-input_matrix[2][0] * input_matrix[1][2] + input_matrix[1][0] * input_matrix[2][2]) / d2;
        double t11 = (-input_matrix[2][0] * input_matrix[0][2] + input_matrix[0][0] * input_matrix[2][2]) / d2;
        double t12 = -(-input_matrix[1][0] * input_matrix[0][2] + input_matrix[0][0] * input_matrix[1][2]) / d2;
        double t20 = (-input_matrix[2][0] * input_matrix[1][1] + input_matrix[1][0] * input_matrix[2][1]) / d2;
        double t21 = -(-input_matrix[2][0] * input_matrix[0][1] + input_matrix[0][0] * input_matrix[2][1]) / d2;
        double t22 = (-input_matrix[1][0] * input_matrix[0][1] + input_matrix[0][0] * input_matrix[1][1]) / d2;
        double[][] output_matrix = new double[3][3];
        output_matrix[0][0] = t00;
        output_matrix[0][1] = t01;
        output_matrix[0][2] = t02;
        output_matrix[1][0] = t10;
        output_matrix[1][1] = t11;
        output_matrix[1][2] = t12;
        output_matrix[2][0] = t20;
        output_matrix[2][1] = t21;
        output_matrix[2][2] = t22;
        return output_matrix;
    }

    public static float[][] concatenate(float[][] m1, float[][] m2) {
        return Matrix.multiply(m2, m1);
    }

    public static double[][] concatenate(double[][] m1, double[][] m2) {
        return Matrix.multiply(m2, m1);
    }

    public static float[] transformPoint(float[][] mm, float x2, float y2) {
        float x_ = mm[0][0] * x2 + mm[1][0] * y2 + mm[2][0];
        float y_ = mm[0][1] * x2 + mm[1][1] * y2 + mm[2][1];
        return new float[]{x_, y_};
    }

    public static void transformPixel(double[][] mm, double[] xy) {
        double x2 = xy[0];
        double y2 = xy[1];
        xy[0] = mm[0][0] * x2 + mm[1][0] * y2 + mm[2][0];
        xy[1] = mm[0][1] * x2 + mm[1][1] * y2 + mm[2][1];
    }

    public static void transformPixel(float[][] mm, float[] xy) {
        float x2 = xy[0];
        float y2 = xy[1];
        xy[0] = mm[0][0] * x2 + mm[1][0] * y2 + mm[2][0];
        xy[1] = mm[0][1] * x2 + mm[1][1] * y2 + mm[2][1];
    }

    public static void show(float[][] matrix1) {
        for (int row = 0; row < 3; ++row) {
            LogWriter.writeLog(row + "((" + matrix1[row][0] + " , " + matrix1[row][1] + " , " + matrix1[row][2] + " ))");
        }
    }

    public static AffineTransform toAffine(float[][] ctm) {
        return new AffineTransform(ctm[0][0], ctm[0][1], ctm[1][0], ctm[1][1], ctm[2][0], ctm[2][1]);
    }

    public static float[][] fromAffine(AffineTransform affine) {
        return new float[][]{{(float)affine.getScaleX(), (float)affine.getShearX(), 0.0f}, {(float)affine.getShearY(), (float)affine.getScaleY(), 0.0f}, {(float)affine.getTranslateX(), (float)affine.getTranslateY(), 1.0f}};
    }

    public static float[][] getIdentity() {
        return new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
    }

    public static float[] transformBBOX(float[] bbox, float[][] ctm) {
        AffineTransform af2 = Matrix.toAffine(ctm);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(bbox[0], bbox[1]);
        gp.lineTo(bbox[2], bbox[1]);
        gp.lineTo(bbox[2], bbox[3]);
        gp.lineTo(bbox[0], bbox[3]);
        gp.lineTo(bbox[0], bbox[1]);
        gp.closePath();
        Shape sh = af2.createTransformedShape(gp);
        Rectangle2D rect = sh.getBounds2D();
        float[] result = new float[]{(float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY()};
        return result;
    }

    public static float[] transformBBOX(float[] bbox, float[] mm) {
        AffineTransform af2 = new AffineTransform(mm);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(bbox[0], bbox[1]);
        gp.lineTo(bbox[2], bbox[1]);
        gp.lineTo(bbox[2], bbox[3]);
        gp.lineTo(bbox[0], bbox[3]);
        gp.lineTo(bbox[0], bbox[1]);
        gp.closePath();
        Shape sh = af2.createTransformedShape(gp);
        Rectangle2D rect = sh.getBounds2D();
        float[] result = new float[]{(float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY()};
        return result;
    }

    public static boolean hasShears(float[][] mm) {
        return mm[0][1] != 0.0f || mm[1][0] != 0.0f;
    }
}

