/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.jpedal.utils.LogWriter;

public final class JavaFXHelper {
    private static boolean javaFXAvailable = true;
    private static boolean javaFXTested;

    private JavaFXHelper() {
    }

    public static boolean isJavaFXAvailable() {
        if (!javaFXTested) {
            try {
                Class.forName("javafx.scene.image.WritableImage");
                javaFXAvailable = true;
            }
            catch (ClassNotFoundException | Error e2) {
                if (JavaFXHelper.tryToLoadFX()) {
                    javaFXAvailable = true;
                }
                LogWriter.writeLog("JavaFX Unavailable. Exception " + e2);
                javaFXAvailable = false;
            }
            javaFXTested = true;
        }
        return javaFXAvailable;
    }

    private static boolean tryToLoadFX() {
        try {
            File jfxrt = new File(System.getProperty("java.home") + "/lib/jfxrt.jar");
            if (!jfxrt.exists()) {
                throw new Exception("jfxrt.jar not found.");
            }
            URL url = jfxrt.toURI().toURL();
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            try {
                Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)sysloader, url);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException t2) {
                throw new IOException("Error, could not add URL to system classloader " + t2);
            }
            return true;
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception in handling JavaFX " + e2);
            return false;
        }
    }
}

