/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.tools;

import java.io.File;
import java.io.IOException;
import javax.print.attribute.standard.PageRanges;
import org.jpedal.examples.PdfUtilities;
import org.jpedal.exception.PdfException;
import org.jpedal.tools.PdfPageDeletion;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public final class PdfPageSplit {
    private PdfPageSplit() {
    }

    public static void main(String[] args) throws IOException {
        int argCount = args.length;
        if (argCount == 3) {
            File input = new File(args[0]);
            File output = new File(args[1]);
            if (StringUtils.isNumber(args[2])) {
                int splitPage = Integer.parseInt(args[2]);
                PdfPageSplit.splitIn2(input, output, splitPage);
            } else {
                LogWriter.writeLog("PdfPageSplit requires the third variable to be an integer");
            }
        } else {
            LogWriter.writeLog("PdfPageSplit requires 3 args to split a file. [Input filename, Output filename, Page to split the document at (included in the first half)");
        }
    }

    public static void splitIn2(File input, File outputDirectory, int splitPage) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageSplit requires input file to be a PDF");
            return;
        }
        if (!outputDirectory.isDirectory()) {
            LogWriter.writeLog("PdfPageSplit requires output to be a directory");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        if (splitPage < 1 && splitPage > pageCount) {
            LogWriter.writeLog("PdfPageSplit.splitIn2 requires the split page to be within the range of 1 - PageCount");
            return;
        }
        String name = input.getName();
        String outputFilename = name.substring(0, name.length() - 4);
        PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + "_1.pdf"), new PageRanges(splitPage + 1, Integer.MAX_VALUE));
        PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + "_2.pdf"), new PageRanges(1, splitPage));
    }

    public static void splitAllPages(File input, File outputDirectory) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageSplit requires input file to be a PDF");
            return;
        }
        if (!outputDirectory.isDirectory()) {
            LogWriter.writeLog("PdfPageSplit requires output to be a directory");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        String name = input.getName();
        String outputFilename = name.substring(0, name.length() - 4);
        for (int page = 1; page <= pageCount; ++page) {
            String firstRange = "";
            if (page != 1) {
                firstRange = "1-" + (page - 1) + ',';
            }
            String secondRange = "";
            if (page != pageCount) {
                secondRange = page + 1 + "-" + pageCount;
            }
            PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + '_' + page + ".pdf"), new PageRanges(firstRange + secondRange));
        }
    }

    public static void splitToNPagePDFs(File input, File outputDirectory, int pages) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageSplit requires input file to be a PDF");
            return;
        }
        if (!outputDirectory.isDirectory()) {
            LogWriter.writeLog("PdfPageSplit requires output to be a directory");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        String name = input.getName();
        String outputFilename = name.substring(0, name.length() - 4);
        for (int page = 1; page <= pageCount; page += pages) {
            int currentOutputPages = Math.min(pages, pageCount - page - 1);
            String firstRange = "";
            if (page != 1) {
                firstRange = "1-" + (page - 1) + ',';
            }
            String secondRange = "";
            if (page + currentOutputPages != pageCount) {
                secondRange = page + currentOutputPages + "-" + pageCount;
            }
            PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + '_' + page + ".pdf"), new PageRanges(firstRange + secondRange));
        }
    }
}

