/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.tools;

import java.io.File;
import java.io.IOException;
import javax.print.attribute.standard.PageRanges;
import org.jpedal.examples.PdfUtilities;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.tools.PdfPageDeletion;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public final class PdfPageExtraction {
    private PdfPageExtraction() {
    }

    public static void main(String[] args) throws IOException {
        int argCount = args.length;
        if (argCount == 3) {
            File input = new File(args[0]);
            File output = new File(args[1]);
            if (StringUtils.isNumber(args[2])) {
                int pageToExtract = Integer.parseInt(args[2]);
                PdfPageExtraction.extractSinglePage(input, output, pageToExtract);
            } else {
                LogWriter.writeLog("PdfPageExtraction requires the third variable to be an integer");
            }
        } else {
            LogWriter.writeLog("PdfPageExtraction requires 3 args to split a file. [Input filename, Output filename, Page to extract");
        }
    }

    public static void extractSinglePage(File input, File outputDirectory, int pageToExtract) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageExtraction requires input file to be a PDF");
            return;
        }
        if (!outputDirectory.isDirectory()) {
            LogWriter.writeLog("PdfPageExtraction requires output to be a directory");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        if (pageToExtract < 1 && pageToExtract > pageCount) {
            LogWriter.writeLog("PdfPageExtraction.extractSinglePage requires the page to extract to be within the range of 1 - PageCount");
            return;
        }
        String name = input.getName();
        String outputFilename = name.substring(0, name.length() - 4);
        String firstRange = "";
        if (pageToExtract != 1) {
            firstRange = "1-" + (pageToExtract - 1) + ',';
        }
        String secondRange = "";
        if (pageToExtract != pageCount) {
            secondRange = pageToExtract + 1 + "-" + pageCount;
        }
        PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + '_' + pageToExtract + ".pdf"), new PageRanges(firstRange + secondRange));
    }

    public static void extractPageRange(File input, File outputDirectory, int rangeStart, int rangeEnd) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageExtraction requires input file to be a PDF");
            return;
        }
        if (!outputDirectory.isDirectory()) {
            LogWriter.writeLog("PdfPageExtraction requires output to be a directory");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        if (rangeStart < 1 && rangeStart > pageCount) {
            LogWriter.writeLog("PdfPageExtraction.extractPageRange requires the page to extract to be within the range of 1 - PageCount");
            return;
        }
        if (rangeEnd < 1 && rangeEnd > pageCount) {
            LogWriter.writeLog("PdfPageExtraction.extractPageRange requires the page to extract to be within the range of 1 - PageCount");
            return;
        }
        if (rangeEnd < rangeStart) {
            LogWriter.writeLog("PdfPageExtraction.extractPageRange requires rangeEnd to be larger then rangeStart");
            return;
        }
        String name = input.getName();
        String outputFilename = name.substring(0, name.length() - 4);
        String firstRange = "";
        if (rangeStart != 1) {
            firstRange = "1-" + (rangeStart - 1) + ',';
        }
        String secondRange = "";
        if (rangeEnd != pageCount) {
            secondRange = rangeEnd + 1 + "-" + pageCount;
        }
        PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + '_' + rangeStart + '-' + rangeEnd + ".pdf"), new PageRanges(firstRange + secondRange));
    }

    public static void extractPageRange(File input, File outputDirectory, PageRanges pagesToExtract) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageExtraction requires input file to be a PDF");
            return;
        }
        if (!outputDirectory.isDirectory()) {
            LogWriter.writeLog("PdfPageExtraction requires output to be a directory");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        StringBuilder pagesToRemove = new StringBuilder();
        boolean allPagesRemoved = true;
        for (int page = 1; page <= pageCount; ++page) {
            if (!pagesToExtract.contains(page)) {
                if (pagesToRemove.length() > 0) {
                    pagesToRemove.append(',');
                }
                pagesToRemove.append(page);
                continue;
            }
            allPagesRemoved = false;
        }
        if (allPagesRemoved) {
            LogWriter.writeLog("PdfPageExtraction.extractPageRange variable pagesToExtract will remove all pages so not output produced");
            return;
        }
        String name = input.getName();
        String outputFilename = name.substring(0, name.length() - 4);
        if (pagesToRemove.length() > 0) {
            PdfPageDeletion.deletePages(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + pagesToExtract + ".pdf"), new PageRanges(pagesToRemove.toString()));
        } else {
            LogWriter.writeLog("PdfPageExtraction.extractPageRange variable pagesToExtract will extract all pages so a direct copy was made");
            ObjectStore.copy(input, new File(outputDirectory.getAbsolutePath() + File.separator + outputFilename + pagesToExtract + ".pdf"));
        }
    }
}

