/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.stream.IntStream;
import javax.print.attribute.standard.PageRanges;
import org.jpedal.examples.PdfUtilities;
import org.jpedal.exception.PdfException;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotOREF;
import org.jpedal.tools.PdfOptimizer;
import org.jpedal.utils.LogWriter;

public final class PdfPageDeletion {
    private PdfPageDeletion() {
    }

    public static void deleteSinglePage(File input, File outputFile, int pageToDelete) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageDeletion requires input file to be a PDF");
            return;
        }
        if (outputFile.isDirectory()) {
            LogWriter.writeLog("PdfPageDeletion requires output to be a file");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        if (pageToDelete < 1 && pageToDelete > pageCount) {
            LogWriter.writeLog("PdfPageDeletion.deleteSinglePage requires the page to delete to be within the range of 1 - PageCount");
            return;
        }
        PdfPageDeletion.deletePages(input, outputFile, new PageRanges(pageToDelete));
    }

    public static void deletePageRange(File input, File outputFile, int rangeStart, int rangeEnd) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageDeletion requires input file to be a PDF");
            return;
        }
        if (outputFile.isDirectory()) {
            LogWriter.writeLog("PdfPageDeletion requires output to be a file");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        if (rangeStart < 1 && rangeStart > pageCount) {
            LogWriter.writeLog("PdfPageDeletion.deletePageRange requires the pages to delete to be within the range of 1 - PageCount");
            return;
        }
        if (rangeEnd < 1 && rangeEnd > pageCount) {
            LogWriter.writeLog("PdfPageDeletion.deletePageRange requires the pages to delete to be within the range of 1 - PageCount");
            return;
        }
        if (rangeEnd < rangeStart) {
            LogWriter.writeLog("PdfPageDeletion.deletePageRange requires rangeEnd to be larger then rangeStart");
            return;
        }
        PdfPageDeletion.deletePages(input, outputFile, new PageRanges(rangeStart + "-" + rangeEnd));
    }

    public static void deletePageRange(File input, File outputFile, PageRanges pagesToDelete) throws IOException {
        int pageCount;
        if (!input.getName().endsWith(".pdf")) {
            LogWriter.writeLog("PdfPageDeletion requires input file to be a PDF");
            return;
        }
        if (outputFile.isDirectory()) {
            LogWriter.writeLog("PdfPageDeletion requires output to be a file");
            return;
        }
        PdfUtilities utils = new PdfUtilities(input.getAbsolutePath());
        try {
            utils.openPDFFile();
            pageCount = utils.getPageCount();
            utils.closePDFfile();
        }
        catch (PdfException e2) {
            throw new IOException("Unable to open file");
        }
        boolean allPagesRemoved = true;
        for (int page = 1; page <= pageCount; ++page) {
            if (pagesToDelete.contains(page)) continue;
            allPagesRemoved = false;
            break;
        }
        if (allPagesRemoved) {
            LogWriter.writeLog("PdfPageDeletion.deletePageRange variable pagesToDelete will remove all pages so not output produced");
            return;
        }
        PdfPageDeletion.deletePages(input, outputFile, pagesToDelete);
    }

    static void deletePages(File input, File output, PageRanges pagesToDelete) throws IOException {
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            LogWriter.writeLog("Unable to create output file");
            return;
        }
        PdfOptimizer optimizer = new PdfOptimizer();
        optimizer.loadFile(input);
        PdfPageDeletion.removePageReferences(optimizer.info, pagesToDelete);
        optimizer.removeUnusedObjects();
        try (FileOutputStream fos = new FileOutputStream(output);){
            optimizer.writeoptimizedFileToStream(fos);
            fos.flush();
        }
        optimizer.closePDF();
    }

    private static void removePageReferences(AnnotInfo info, PageRanges range) {
        AnnotOREF[] pageRefs = info.pageOffsets;
        info.pageOffsets = (AnnotOREF[])IntStream.range(0, pageRefs.length).filter(i2 -> !range.contains(i2 + 1)).mapToObj(i2 -> pageRefs[i2]).toArray(AnnotOREF[]::new);
    }

    public static void main(String[] args) {
        int argCount = args.length;
        if (argCount == 3) {
            File input = new File(args[0]);
            File output = new File(args[1]);
            PageRanges pages = new PageRanges(args[2]);
            try {
                PdfPageDeletion.deletePages(input, output, pages);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            LogWriter.writeLog("PdfPageDeletion requires 3 args to split a file. [Input filename, Output filename, Pagerange of pages to delete");
        }
    }
}

