/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.jpedal.io.annotation.utils.AnnotArray;
import org.jpedal.io.annotation.utils.AnnotBuffer;
import org.jpedal.io.annotation.utils.AnnotDict;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.annotation.utils.AnnotName;
import org.jpedal.io.annotation.utils.AnnotNumber;
import org.jpedal.io.annotation.utils.AnnotOBJOFF;
import org.jpedal.io.annotation.utils.AnnotOREF;
import org.jpedal.io.annotation.utils.AnnotObject;
import org.jpedal.utils.LogWriter;

public class PdfOptimizer {
    private static final byte[] CONTENT_HEADER = new byte[]{37, -30, -29, -49, -45, 10};
    final AnnotInfo info = new AnnotInfo();

    public void loadFile(File input) throws IOException {
        AnnotBuffer mainBuff;
        this.info.mainBuffer = mainBuff = new AnnotBuffer(input, this.info);
        int prev = mainBuff.findFirstXREFOffset();
        mainBuff.movePos(prev);
        mainBuff.readSimpleXREF();
        mainBuff.updateAllObjStm();
        mainBuff.updatePageOffsets();
    }

    public void closePDF() throws IOException {
        this.info.mainBuffer.close();
    }

    public byte[] getoptimizedFileAsBytes() throws IOException {
        ByteArrayOutputStream newContentToAppend = new ByteArrayOutputStream();
        this.writeoptimizedFileToStream(newContentToAppend);
        return newContentToAppend.toByteArray();
    }

    public void writeoptimizedFileToStream(OutputStream outputStream) throws IOException {
        int offset = 0;
        byte[] fileHeader = AnnotLEX.textToBytes("%PDF-1.5\n");
        outputStream.write(fileHeader);
        offset += fileHeader.length;
        outputStream.write(CONTENT_HEADER);
        offset += CONTENT_HEADER.length;
        AnnotOBJOFF[] xref = this.info.offsetMap.offs;
        int[] newXRefOffsets = new int[xref.length];
        int[] objectOrder = this.info.mainBuffer.getObjectOrderForFile();
        if (objectOrder == null) {
            objectOrder = IntStream.rangeClosed(0, this.info.offsetMap.maxKey).toArray();
        }
        for (int i2 = 0; i2 != objectOrder.length; ++i2) {
            int objectNumber = objectOrder[i2];
            AnnotOBJOFF xrefEntry = xref[objectNumber];
            if (xrefEntry == null) continue;
            if (xrefEntry.inUse) {
                AnnotOREF refFOrPage = new AnnotOREF(objectNumber, 0);
                AnnotObject fieldDict = this.info.mainBuffer.getObjectValue(refFOrPage);
                newXRefOffsets[objectNumber] = offset;
                String dictionaryStr = objectNumber + " 0 obj\n";
                byte[] dictBytes = AnnotLEX.textToBytes(dictionaryStr);
                outputStream.write(dictBytes);
                offset += dictBytes.length;
                byte[] fieldBytes = fieldDict.toByteArray();
                outputStream.write(fieldBytes);
                offset += fieldBytes.length;
                if (fieldDict.getType() == 5 && ((AnnotDict)fieldDict).rawStream != null) {
                    byte[] streamBytes = ((AnnotDict)fieldDict).rawStream.getByteData();
                    String startStream = "stream\n";
                    String endStream = "endstream";
                    byte[] startStreamBytes = AnnotLEX.textToBytes("stream\n");
                    byte[] endStreamBytes = AnnotLEX.textToBytes("endstream");
                    outputStream.write(startStreamBytes);
                    offset += startStreamBytes.length;
                    outputStream.write(streamBytes);
                    offset += streamBytes.length;
                    outputStream.write(endStreamBytes);
                    offset += endStreamBytes.length;
                }
                byte[] endObj = AnnotLEX.textToBytes("\nendobj\n");
                outputStream.write(endObj);
                offset += endObj.length;
                continue;
            }
            newXRefOffsets[objectNumber] = 0;
        }
        int xrefStartOffset = offset;
        int xrefSize = this.info.offsetMap.maxKey + 1;
        if (this.info.xrefType == 1) {
            byte[] wBytes;
            StringBuilder sb = new StringBuilder("[");
            try (ByteArrayOutputStream wBos = new ByteArrayOutputStream();){
                for (int i3 = 0; i3 != xrefSize; ++i3) {
                    int offsetEntry = newXRefOffsets[i3];
                    if (offsetEntry == -1) continue;
                    wBos.write(1);
                    wBos.write(AnnotLEX.toBytes32(offsetEntry));
                    wBos.write(0);
                    sb.append(i3);
                    sb.append(" 1 ");
                }
                sb.append(']');
                wBos.close();
                wBytes = wBos.toByteArray();
            }
            String dictStr = this.info.offsetMap.maxKey + " 0 obj\n<</Type /XRef /Root " + this.info.mainCatalog.ref + " /Index " + sb + " /W [1 4 1] /Size " + xrefSize + "/Length " + wBytes.length + ">>stream\n";
            outputStream.write(AnnotLEX.textToBytes(dictStr));
            outputStream.write(wBytes);
            dictStr = "\nendstream\nendobj\nstartxref\n" + xrefStartOffset + "\n%%EOF\n";
            outputStream.write(AnnotLEX.textToBytes(dictStr));
        } else {
            outputStream.write(AnnotLEX.textToBytes("xref\n"));
            ByteArrayOutputStream xrefEntryBuilder = new ByteArrayOutputStream();
            for (int i4 = 0; i4 != xrefSize; ++i4) {
                int offsetEntry = newXRefOffsets[i4];
                xrefEntryBuilder.write(AnnotLEX.textToBytes(AnnotLEX.getZeroLead(offsetEntry) + (xref[i4] != null && xref[i4].inUse ? " 00000 n" : " 65535 f") + "\r\n"));
            }
            outputStream.write(AnnotLEX.textToBytes("0 " + xrefSize + '\n'));
            outputStream.write(xrefEntryBuilder.toByteArray());
            outputStream.write(AnnotLEX.textToBytes("trailer\n"));
            AnnotDict trailer = new AnnotDict();
            trailer.keys.put("Size", new AnnotNumber(xrefSize));
            trailer.keys.put("Root", this.info.trailer.keys.get("Root"));
            trailer.keys.put("Info", this.info.trailer.keys.get("Info"));
            trailer.keys.put("Encrypt", this.info.trailer.keys.get("Encrypt"));
            trailer.keys.put("ID", this.info.trailer.keys.get("ID"));
            outputStream.write(trailer.toByteArray());
            outputStream.write(10);
            outputStream.write(AnnotLEX.textToBytes("startxref\n"));
            outputStream.write(AnnotLEX.textToBytes(xrefStartOffset + "\n"));
            outputStream.write(AnnotLEX.textToBytes("%%EOF\n"));
        }
    }

    public static void optimizePDF(File input, File output) throws IOException {
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            LogWriter.writeLog("Unable to create output file");
            return;
        }
        if (input.exists()) {
            if (input.getName().endsWith(".pdf")) {
                PdfOptimizer optimizer = new PdfOptimizer();
                optimizer.loadFile(input);
                optimizer.removeUnusedObjects();
                try (FileOutputStream fos = new FileOutputStream(output);){
                    optimizer.writeoptimizedFileToStream(fos);
                    fos.flush();
                }
                optimizer.closePDF();
            } else {
                LogWriter.writeLog("File is not a PDF, can not optimize.");
            }
        } else {
            LogWriter.writeLog("Input file does not exist.");
        }
    }

    public void removeUnusedObjects() throws IOException {
        AnnotObject structTreeRootObj;
        AnnotOREF[] pagesToKeep = this.info.pageOffsets;
        HashMap<Integer, Boolean> objectsToRemove = new HashMap<Integer, Boolean>();
        AnnotDict mc = (AnnotDict)this.info.mainBuffer.getObjectValue(this.info.mainCatalog);
        AnnotOREF pagesObjectRef = (AnnotOREF)mc.keys.get("Pages");
        AnnotDict pagesObject = (AnnotDict)this.info.mainBuffer.getObjectValue(pagesObjectRef);
        PdfOptimizer.scanPagesObject(this.info, pagesObject, pagesToKeep, objectsToRemove, pagesObjectRef);
        objectsToRemove.entrySet().removeIf(entry -> (Boolean)entry.getValue() == false);
        AnnotOBJOFF[] xref = this.info.offsetMap.offs;
        Set<Integer> remove = objectsToRemove.keySet();
        for (Integer r2 : remove) {
            xref[r2.intValue()].inUse = false;
        }
        PdfOptimizer.removeUnusedPages(this.info, pagesToKeep, pagesObjectRef, pagesObject);
        PdfOptimizer.removeUnusedOutlines(this.info, objectsToRemove);
        PdfOptimizer.removeUnusedAcroform(this.info, objectsToRemove);
        PdfOptimizer.removeUnusedOpenAction(this.info, objectsToRemove);
        AnnotObject structTreeRoot = mc.keys.get("StructTreeRoot");
        if (structTreeRoot != null && structTreeRoot.getType() != 7 && (structTreeRootObj = this.info.mainBuffer.getObjectValue(structTreeRoot)).getType() == 5) {
            AnnotOREF structTreeRootRef = structTreeRoot.getType() == 8 ? (AnnotOREF)structTreeRoot : null;
            PdfOptimizer.removeUnusedStructTreeRoot(this.info, structTreeRootRef, (AnnotDict)structTreeRootObj, objectsToRemove);
        }
        PdfOptimizer.removeUnusedOCPropterties(this.info, objectsToRemove);
    }

    private static void removeUnusedOCPropterties(AnnotInfo info, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotDict mc = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
        AnnotObject ocProperties = mc.keys.get("OCProperties");
        if (ocProperties != null) {
            AnnotDict ocPropertiesObj;
            AnnotOREF ocPropertiesRef;
            if (ocProperties.getType() == 8) {
                ocPropertiesRef = (AnnotOREF)ocProperties;
                ocPropertiesObj = (AnnotDict)info.mainBuffer.getObjectValue(ocProperties);
            } else {
                ocPropertiesRef = null;
                ocPropertiesObj = (AnnotDict)ocProperties;
            }
            PdfOptimizer.removeUnusedOCProperties(info, ocPropertiesRef, ocPropertiesObj, objectsToRemove);
            if (ocPropertiesRef != null) {
                info.mainBuffer.updateObject(ocPropertiesRef.num, ocPropertiesObj);
            } else {
                info.mainBuffer.updateObject(info.mainCatalog.num, mc);
            }
        }
    }

    private static void removeUnusedOpenAction(AnnotInfo info, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotDict mc = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
        AnnotObject openAction = mc.keys.get("OpenAction");
        if (openAction != null) {
            AnnotObject openActionObject = info.mainBuffer.getObjectValue(openAction);
            if (openActionObject.getType() == 5) {
                PdfOptimizer.removeAction(info, openActionObject, objectsToRemove);
                if (PdfOptimizer.removeAction(info, openActionObject, objectsToRemove)) {
                    mc.keys.remove("OpenAction");
                    info.mainBuffer.updateObject(info.mainCatalog.num, mc);
                }
            } else if (openActionObject.getType() == 6) {
                if (PdfOptimizer.removeDestination(info, openActionObject, objectsToRemove)) {
                    mc.keys.remove("OpenAction");
                    info.mainBuffer.updateObject(info.mainCatalog.num, mc);
                }
            } else {
                LogWriter.writeLog("Unknown OpenAction type");
            }
        }
    }

    private static void removeUnusedAcroform(AnnotInfo info, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotDict mc = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
        AnnotObject acroForms = mc.keys.get("AcroForm");
        if (acroForms != null) {
            AnnotDict acroFormsDict;
            AnnotOREF acroFormsRef;
            if (acroForms.getType() == 8) {
                acroFormsRef = (AnnotOREF)acroForms;
                AnnotObject acroFormObj = info.mainBuffer.getObjectValue(acroForms);
                acroFormsDict = acroFormObj.getType() == 5 ? (AnnotDict)info.mainBuffer.getObjectValue(acroForms) : null;
            } else {
                acroFormsRef = null;
                acroFormsDict = (AnnotDict)acroForms;
            }
            if (acroFormsDict != null) {
                PdfOptimizer.removeUnusedAcroForms(info, acroFormsRef, acroFormsDict, objectsToRemove);
            }
        }
    }

    private static void removeUnusedOutlines(AnnotInfo info, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotDict mc = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
        AnnotObject outlines = mc.keys.get("Outlines");
        if (outlines != null) {
            AnnotDict outlinesDict;
            AnnotOREF outlinesRef;
            if (outlines.getType() == 8) {
                outlinesRef = (AnnotOREF)outlines;
                AnnotObject acroFormObj = info.mainBuffer.getObjectValue(outlines);
                outlinesDict = acroFormObj.getType() == 5 ? (AnnotDict)info.mainBuffer.getObjectValue(outlines) : null;
            } else {
                outlinesRef = null;
                outlinesDict = (AnnotDict)outlines;
            }
            if (outlinesDict != null) {
                PdfOptimizer.removeUnusedOutlines(info, outlinesRef, outlinesDict, objectsToRemove);
            }
        }
    }

    private static void removeUnusedPages(AnnotInfo info, AnnotOREF[] pagesToKeep, AnnotOREF pagesObjectRef, AnnotDict pagesObject) throws IOException {
        AnnotOBJOFF[] xref = info.offsetMap.offs;
        int pageCount = pagesToKeep.length;
        AnnotArray kids = new AnnotArray();
        kids.items.addAll(Arrays.asList(pagesToKeep));
        pagesObject.keys.put("Kids", kids);
        pagesObject.keys.put("Count", new AnnotNumber(pageCount));
        info.mainBuffer.updateObject(pagesObjectRef.num, pagesObject);
        for (int i2 = 0; i2 != xref.length; ++i2) {
            AnnotOREF refFOrPage;
            AnnotObject fieldDict;
            AnnotOBJOFF xrefEntry = xref[i2];
            if (xrefEntry == null || !xrefEntry.inUse || (fieldDict = info.mainBuffer.getObjectValue(refFOrPage = new AnnotOREF(i2, 0))).getType() != 5) continue;
            AnnotDict dict = (AnnotDict)fieldDict;
            AnnotName type = (AnnotName)dict.keys.get("Type");
            if (type == null || !"Page".equals(type.name)) continue;
            dict.keys.put("Parent", pagesObjectRef);
            info.mainBuffer.updateObject(refFOrPage.num, dict);
        }
    }

    private static void removeUnusedOCProperties(AnnotInfo info, AnnotObject ocPropertiesRef, AnnotDict ocPropertiesObj, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        String[] keys;
        block4: for (String key : keys = ocPropertiesObj.keys.keySet().toArray(new String[0])) {
            AnnotObject value = ocPropertiesObj.keys.get(key);
            while (value.getType() == 8) {
                if (objectsToRemove.containsKey(((AnnotOREF)value).num)) {
                    ocPropertiesObj.keys.remove(key);
                    if (ocPropertiesRef == null) continue;
                    info.mainBuffer.updateObject(((AnnotOREF)ocPropertiesRef).num, ocPropertiesObj);
                    continue;
                }
                value = info.mainBuffer.getObjectValue(value);
            }
            switch (value.getType()) {
                case 5: {
                    PdfOptimizer.removeUnusedOCProperties(info, null, (AnnotDict)value, objectsToRemove);
                    continue block4;
                }
                case 6: {
                    AnnotObject[] items;
                    for (AnnotObject item : items = ((AnnotArray)value).items.toArray(new AnnotObject[0])) {
                        if (item.getType() != 8 || !objectsToRemove.containsKey(((AnnotOREF)item).num)) continue;
                        ((AnnotArray)value).items.remove(item);
                        if (ocPropertiesRef == null) continue;
                        info.mainBuffer.updateObject(((AnnotOREF)ocPropertiesRef).num, ocPropertiesObj);
                    }
                    continue block4;
                }
            }
        }
    }

    private static void removeUnusedStructTreeRoot(AnnotInfo info, AnnotOREF structTreeRootRef, AnnotDict structTreeRootObj, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotObject K2 = structTreeRootObj.keys.get("K");
        if (K2 != null) {
            AnnotObject KObj;
            AnnotOREF KRef;
            if (K2.getType() == 8) {
                KRef = (AnnotOREF)K2;
                KObj = info.mainBuffer.getObjectValue(K2);
            } else {
                KRef = null;
                KObj = K2;
            }
            if (KObj.getType() == 5) {
                PdfOptimizer.removeStructTreeDict(info, structTreeRootRef, structTreeRootObj, KRef, (AnnotDict)KObj, objectsToRemove);
            } else if (KObj.getType() == 6) {
                PdfOptimizer.removeStructTreeArray(info, structTreeRootRef, structTreeRootObj, KRef, (AnnotArray)KObj, objectsToRemove);
            } else if (KObj.getType() == 3) {
                AnnotObject pg = structTreeRootObj.keys.get("Pg");
                if (structTreeRootRef != null && pg.getType() == 8 && objectsToRemove.containsKey(((AnnotOREF)pg).num)) {
                    structTreeRootObj.keys.remove("K");
                    structTreeRootObj.keys.remove("Pg");
                    AnnotOBJOFF[] xref = info.offsetMap.offs;
                    xref[structTreeRootRef.num].inUse = false;
                }
            }
        } else {
            PdfOptimizer.removeStructTreeDict(info, structTreeRootRef, structTreeRootObj, structTreeRootRef, structTreeRootObj, objectsToRemove);
        }
    }

    private static void removeStructTreeDict(AnnotInfo info, AnnotOREF parentRef, AnnotDict parentObj, AnnotOREF kRef, AnnotDict kObj, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotObject pg = kObj.keys.get("Pg");
        if (pg != null && pg.getType() == 8 && objectsToRemove.containsKey(((AnnotOREF)pg).num)) {
            kObj.keys.remove("Pg");
            if (kRef != null) {
                parentObj.keys.remove("K");
                AnnotOBJOFF[] xref = info.offsetMap.offs;
                xref[kRef.num].inUse = false;
            } else if (parentRef != null) {
                parentObj.keys.remove("K");
                info.mainBuffer.updateObject(parentRef.num, parentObj);
            }
        } else if (kObj.keys.containsKey("K")) {
            PdfOptimizer.removeUnusedStructTreeRoot(info, kRef, kObj, objectsToRemove);
            if (parentRef != null) {
                info.mainBuffer.updateObject(parentRef.num, parentObj);
            }
        }
    }

    private static void removeStructTreeArray(AnnotInfo info, AnnotOREF parentRef, AnnotObject parentObj, AnnotOREF kRef, AnnotArray kArray, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotObject[] values;
        for (AnnotObject item : values = kArray.items.toArray(new AnnotObject[0])) {
            AnnotObject itemObj;
            if (item == null) continue;
            if (item.getType() == 8) {
                itemObj = info.mainBuffer.getObjectValue(item);
                PdfOptimizer.removeUnusedStructTreeRoot(info, (AnnotOREF)item, (AnnotDict)itemObj, objectsToRemove);
                if (((AnnotDict)itemObj).keys.containsKey("Pg") || ((AnnotDict)itemObj).keys.containsKey("K")) continue;
                AnnotOBJOFF[] xref = info.offsetMap.offs;
                xref[((AnnotOREF)item).num].inUse = false;
                kArray.items.remove(item);
                continue;
            }
            if (item.getType() != 5) continue;
            itemObj = info.mainBuffer.getObjectValue(item);
            PdfOptimizer.removeUnusedStructTreeRoot(info, null, (AnnotDict)itemObj, objectsToRemove);
            if (((AnnotDict)itemObj).keys.containsKey("Pg") || ((AnnotDict)itemObj).keys.containsKey("K")) continue;
            kArray.items.remove(item);
        }
        if (kRef != null) {
            if (kArray.items.isEmpty()) {
                AnnotOBJOFF[] xref = info.offsetMap.offs;
                xref[kRef.num].inUse = false;
                ((AnnotDict)parentObj).keys.remove("K");
                info.mainBuffer.updateObject(parentRef.num, parentObj);
            } else {
                info.mainBuffer.updateObject(kRef.num, kArray);
            }
        } else if (kArray.items.isEmpty()) {
            if (parentObj.getType() == 5) {
                ((AnnotDict)parentObj).keys.remove("K");
                info.mainBuffer.updateObject(parentRef.num, parentObj);
            }
        } else if (parentObj.getType() == 5) {
            ((AnnotDict)parentObj).keys.put("K", kArray);
            info.mainBuffer.updateObject(parentRef.num, parentObj);
        }
    }

    private static void removeUnusedAcroForms(AnnotInfo info, AnnotOREF acroFormRef, AnnotDict acroFormObject, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotObject dr;
        AnnotObject fields;
        AnnotObject co = acroFormObject.keys.get("CO");
        if (co != null) {
            PdfOptimizer.removeUnusedAcroFormsCOObject(info, co, acroFormRef, acroFormObject, objectsToRemove);
        }
        if ((fields = acroFormObject.keys.get("Fields")) != null) {
            PdfOptimizer.removeUnusedAcroFormsFieldsObject(info, fields, acroFormRef, acroFormObject, objectsToRemove);
        }
        if ((dr = acroFormObject.keys.get("DR")) != null) {
            PdfOptimizer.removeUnusedAcroFormsDRObject(info, dr, objectsToRemove);
        }
    }

    private static void removeUnusedAcroFormsCOObject(AnnotInfo info, AnnotObject co, AnnotOREF acroFormRef, AnnotDict acroFormObject, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotArray coObj;
        AnnotOREF coRef;
        if (co.getType() == 8) {
            coRef = (AnnotOREF)co;
            coObj = (AnnotArray)info.mainBuffer.getObjectValue(co);
        } else {
            coRef = null;
            coObj = (AnnotArray)co;
        }
        AnnotArray newCO = new AnnotArray();
        for (AnnotObject obj : coObj.items) {
            AnnotObject childObj = info.mainBuffer.getObjectValue(obj);
            if (childObj.getType() != 5 || PdfOptimizer.removeUnusedAcroFormEntries(info, (AnnotOREF)obj, (AnnotDict)childObj, objectsToRemove)) continue;
            newCO.items.add(obj);
        }
        if (newCO.items.isEmpty()) {
            if (coRef != null) {
                AnnotOBJOFF[] xref = info.offsetMap.offs;
                xref[coRef.num].inUse = false;
            }
        } else if (coRef != null) {
            info.mainBuffer.updateObject(coRef.num, newCO);
        } else {
            acroFormObject.keys.put("CO", newCO);
            info.mainBuffer.updateObject(acroFormRef.num, acroFormObject);
        }
    }

    private static void removeUnusedAcroFormsFieldsObject(AnnotInfo info, AnnotObject fields, AnnotOREF acroFormRef, AnnotDict acroFormObject, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotArray fieldsObj;
        AnnotOREF fieldsRef;
        if (fields.getType() == 8) {
            fieldsRef = (AnnotOREF)fields;
            fieldsObj = (AnnotArray)info.mainBuffer.getObjectValue(fields);
        } else {
            fieldsRef = null;
            fieldsObj = (AnnotArray)fields;
        }
        AnnotArray newFields = new AnnotArray();
        for (AnnotObject obj : fieldsObj.items) {
            AnnotObject fieldChild;
            if (obj == null || (fieldChild = info.mainBuffer.getObjectValue(obj)).getType() != 5 || PdfOptimizer.removeUnusedAcroFormEntries(info, (AnnotOREF)obj, (AnnotDict)fieldChild, objectsToRemove)) continue;
            newFields.items.add(obj);
        }
        if (newFields.items.isEmpty()) {
            if (fieldsRef != null) {
                AnnotOBJOFF[] xref = info.offsetMap.offs;
                xref[fieldsRef.num].inUse = false;
            }
        } else if (fieldsRef != null) {
            info.mainBuffer.updateObject(fieldsRef.num, newFields);
        } else {
            acroFormObject.keys.put("Fields", newFields);
            if (acroFormRef != null) {
                info.mainBuffer.updateObject(acroFormRef.num, acroFormObject);
            }
        }
    }

    private static void removeUnusedAcroFormsDRObject(AnnotInfo info, AnnotObject dr, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        String[] keys;
        AnnotDict drObj;
        AnnotOREF drRef;
        if (dr.getType() == 8) {
            drRef = (AnnotOREF)dr;
            drObj = (AnnotDict)info.mainBuffer.getObjectValue(dr);
        } else {
            drRef = null;
            drObj = (AnnotDict)dr;
        }
        for (String child : keys = drObj.keys.keySet().toArray(new String[0])) {
            AnnotObject childObj = drObj.keys.get(child);
            if (childObj.getType() == 8) {
                childObj = info.mainBuffer.getObjectValue(childObj);
            }
            if (childObj.getType() != 5 || !PdfOptimizer.removeAcroFormResource((AnnotDict)childObj, objectsToRemove)) continue;
            drObj.keys.remove(child);
            if (drRef == null) continue;
            AnnotOBJOFF[] xref = info.offsetMap.offs;
            xref[drRef.num].inUse = false;
        }
        if (drRef != null) {
            info.mainBuffer.updateObject(drRef.num, drObj);
        }
    }

    private static boolean removeAcroFormResource(AnnotDict resourceDirectory, HashMap<Integer, Boolean> objectsToRemove) {
        String[] keys;
        for (String child : keys = resourceDirectory.keys.keySet().toArray(new String[0])) {
            AnnotObject childObj = resourceDirectory.keys.get(child);
            if (childObj.getType() != 8 || !objectsToRemove.containsKey(((AnnotOREF)childObj).num)) continue;
            resourceDirectory.keys.remove(child);
        }
        return resourceDirectory.keys.isEmpty();
    }

    private static boolean removeUnusedAcroFormEntries(AnnotInfo info, AnnotOREF formRef, AnnotDict formObject, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotObject pValue = formObject.keys.get("P");
        if (pValue != null && pValue.getType() == 8 && objectsToRemove.containsKey(((AnnotOREF)pValue).num)) {
            return true;
        }
        AnnotObject kidsRef = formObject.keys.get("Kids");
        if (kidsRef != null) {
            AnnotObject kidsValue = info.mainBuffer.getObjectValue(kidsRef);
            AnnotArray newKids = new AnnotArray();
            for (AnnotObject obj : ((AnnotArray)kidsValue).items) {
                AnnotDict dictObj;
                AnnotOREF dictRef;
                if (obj == null || obj.getType() != 5 && obj.getType() != 8) continue;
                if (obj.getType() == 8) {
                    dictRef = (AnnotOREF)obj;
                    dictObj = (AnnotDict)info.mainBuffer.getObjectValue(obj);
                } else {
                    dictRef = null;
                    dictObj = (AnnotDict)obj;
                }
                if (PdfOptimizer.removeUnusedAcroFormEntries(info, dictRef, dictObj, objectsToRemove)) continue;
                newKids.items.add(obj);
            }
            if (kidsRef.getType() == 8) {
                info.mainBuffer.updateObject(((AnnotOREF)kidsRef).num, newKids);
            } else {
                formObject.keys.put("Kids", newKids);
                info.mainBuffer.updateObject(formRef.num, formObject);
            }
            return newKids.items.isEmpty();
        }
        return false;
    }

    private static void removeUnusedOutlines(AnnotInfo info, AnnotOREF outlinesRef, AnnotDict outlinesObject, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        AnnotObject count;
        int iCount;
        AnnotObject first = outlinesObject.keys.get("First");
        if (first != null) {
            AnnotDict firstObj;
            AnnotOREF firstRef;
            if (first.getType() == 8) {
                firstRef = (AnnotOREF)first;
                firstObj = (AnnotDict)info.mainBuffer.getObjectValue(first);
            } else {
                firstRef = null;
                firstObj = (AnnotDict)first;
            }
            HashSet<Integer> previousOutlineRefs = new HashSet<Integer>();
            iCount = PdfOptimizer.removeUnusedOutlineItems(info, firstRef, firstObj, objectsToRemove, 0, previousOutlineRefs);
        } else {
            iCount = 0;
        }
        if (iCount > 0 && (count = outlinesObject.keys.get("Count")) != null) {
            if (count.getType() == 8) {
                count = info.mainBuffer.getObjectValue(count);
            }
            if (count.getType() == 3) {
                int origValue = ((AnnotNumber)count).toValue().intValue();
                if (origValue < 0) {
                    iCount = -iCount;
                }
                outlinesObject.keys.put("Count", new AnnotNumber(iCount));
            } else {
                LogWriter.writeLog("Count Value is not a number");
            }
        }
        AnnotOBJOFF[] xref = info.offsetMap.offs;
        if (outlinesRef != null && !xref[outlinesRef.num].inUse) {
            AnnotDict mc = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
            mc.keys.remove("Outlines");
            info.mainBuffer.updateObject(info.mainCatalog.num, mc);
        }
    }

    private static int removeUnusedOutlineItems(AnnotInfo info, AnnotOREF outlinesRef, AnnotDict outlinesObject, HashMap<Integer, Boolean> objectsToRemove, int currentCount, Set<Integer> previousOutlineRefs) throws IOException {
        AnnotObject first;
        AnnotObject a10;
        AnnotDict prevObj;
        AnnotOREF prevRef;
        AnnotDict nextObj;
        AnnotOREF nextRef;
        AnnotObject next;
        if (outlinesRef != null) {
            previousOutlineRefs.add(outlinesRef.num);
        }
        if ((next = outlinesObject.keys.get("Next")) != null) {
            if (next.getType() == 8) {
                nextRef = (AnnotOREF)next;
                nextObj = (AnnotDict)info.mainBuffer.getObjectValue(next);
            } else {
                nextRef = null;
                nextObj = (AnnotDict)next;
            }
        } else {
            nextRef = null;
            nextObj = null;
        }
        AnnotObject prev = outlinesObject.keys.get("Prev");
        if (prev != null) {
            if (prev.getType() == 8) {
                prevRef = (AnnotOREF)prev;
                prevObj = (AnnotDict)info.mainBuffer.getObjectValue(prev);
            } else {
                prevRef = null;
                prevObj = (AnnotDict)prev;
            }
        } else {
            prevRef = null;
            prevObj = null;
        }
        ++currentCount;
        AnnotObject dest = outlinesObject.keys.get("Dest");
        if (PdfOptimizer.removeDestination(info, dest, objectsToRemove)) {
            PdfOptimizer.removeUnusedOutline(info, outlinesRef, outlinesObject, prevRef, nextRef, prevObj, nextObj);
            --currentCount;
        }
        if (PdfOptimizer.removeAction(info, a10 = outlinesObject.keys.get("A"), objectsToRemove)) {
            PdfOptimizer.removeUnusedOutline(info, outlinesRef, outlinesObject, prevRef, nextRef, prevObj, nextObj);
            --currentCount;
        }
        if ((first = outlinesObject.keys.get("First")) != null) {
            AnnotObject count;
            int iCount;
            AnnotDict firstObj;
            AnnotOREF firstRef;
            if (first.getType() == 8) {
                firstRef = (AnnotOREF)first;
                firstObj = (AnnotDict)info.mainBuffer.getObjectValue(first);
            } else {
                firstRef = null;
                firstObj = (AnnotDict)first;
            }
            if (!(firstRef != null && previousOutlineRefs.contains(firstRef.num) || (iCount = PdfOptimizer.removeUnusedOutlineItems(info, firstRef, firstObj, objectsToRemove, 0, previousOutlineRefs)) <= 0 || (count = outlinesObject.keys.get("Count")) == null)) {
                if (count.getType() == 8) {
                    count = info.mainBuffer.getObjectValue(count);
                }
                if (count.getType() == 3) {
                    int origValue = ((AnnotNumber)count).toValue().intValue();
                    if (origValue < 0) {
                        iCount = -iCount;
                    }
                    outlinesObject.keys.put("Count", new AnnotNumber(iCount));
                } else {
                    LogWriter.writeLog("Count Value is not a number");
                }
            }
        }
        if (!(next == null || nextRef != null && previousOutlineRefs.contains(nextRef.num))) {
            currentCount = PdfOptimizer.removeUnusedOutlineItems(info, nextRef, nextObj, objectsToRemove, currentCount, previousOutlineRefs);
        }
        return currentCount;
    }

    private static boolean removeDestination(AnnotInfo info, AnnotObject dest, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        if (dest != null) {
            AnnotOREF destRef;
            if (dest.getType() == 8) {
                destRef = (AnnotOREF)dest;
                dest = info.mainBuffer.getObjectValue(dest);
            } else {
                destRef = null;
            }
            if (dest.getType() == 6) {
                for (AnnotObject obj : ((AnnotArray)dest).items) {
                    AnnotObject destObj;
                    if (obj == null || (destObj = info.mainBuffer.getObjectValue(obj)).getType() != 5 || !PdfOptimizer.containsRemovedObjectsRef(info, (AnnotDict)destObj, objectsToRemove)) continue;
                    if (destRef != null) {
                        AnnotOBJOFF[] xref = info.offsetMap.offs;
                        xref[destRef.num].inUse = false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean removeAction(AnnotInfo info, AnnotObject a10, HashMap<Integer, Boolean> objectsToRemove) throws IOException {
        if (a10 != null) {
            AnnotDict aObj;
            AnnotOREF aRef;
            if (a10.getType() == 8) {
                aRef = (AnnotOREF)a10;
                aObj = (AnnotDict)info.mainBuffer.getObjectValue(a10);
            } else {
                aRef = null;
                aObj = (AnnotDict)a10;
            }
            if (PdfOptimizer.containsRemovedObjectsRef(info, aObj, objectsToRemove)) {
                if (aRef != null) {
                    AnnotOBJOFF[] xref = info.offsetMap.offs;
                    xref[aRef.num].inUse = false;
                }
                return true;
            }
        }
        return false;
    }

    private static void removeUnusedOutline(AnnotInfo info, AnnotOREF outlinesRef, AnnotDict outlinesObject, AnnotOREF prevRef, AnnotOREF nextRef, AnnotDict prevObj, AnnotDict nextObj) throws IOException {
        AnnotDict parentObj;
        AnnotOREF parentRef;
        AnnotObject parent;
        AnnotOBJOFF[] xref = info.offsetMap.offs;
        xref[outlinesRef.num].inUse = false;
        if (prevObj != null) {
            if (nextRef != null) {
                prevObj.keys.put("Next", nextRef);
            } else {
                prevObj.keys.remove("Next");
            }
            if (prevRef != null) {
                info.mainBuffer.updateObject(prevRef.num, prevObj);
            }
        } else {
            parent = outlinesObject.keys.get("Parent");
            if (parent.getType() == 8) {
                parentRef = (AnnotOREF)parent;
                parentObj = (AnnotDict)info.mainBuffer.getObjectValue(parent);
            } else {
                parentRef = null;
                parentObj = (AnnotDict)parent;
            }
            if (nextRef == null) {
                parentObj.keys.remove("First");
                parentObj.keys.remove("Last");
                if (parentRef != null) {
                    xref[parentRef.num].inUse = false;
                }
            } else {
                parentObj.keys.put("First", nextRef);
            }
            if (parentRef != null) {
                info.mainBuffer.updateObject(parentRef.num, parentObj);
            }
        }
        if (nextObj != null) {
            if (prevRef != null) {
                nextObj.keys.put("Prev", prevRef);
            } else {
                nextObj.keys.remove("Prev");
            }
            if (nextRef != null) {
                info.mainBuffer.updateObject(nextRef.num, nextObj);
            }
        } else {
            parent = outlinesObject.keys.get("Parent");
            if (parent.getType() == 8) {
                parentRef = (AnnotOREF)parent;
                parentObj = (AnnotDict)info.mainBuffer.getObjectValue(parent);
            } else {
                parentRef = null;
                parentObj = (AnnotDict)parent;
            }
            if (prevRef == null) {
                parentObj.keys.remove("First");
                parentObj.keys.remove("Last");
                if (parentRef != null) {
                    xref[parentRef.num].inUse = false;
                }
            } else {
                parentObj.keys.put("Last", nextRef);
            }
            if (parentRef != null) {
                info.mainBuffer.updateObject(parentRef.num, parentObj);
            }
        }
    }

    private static boolean containsRemovedObjectsRef(AnnotInfo info, AnnotDict pageObject, HashMap<Integer, Boolean> objectsToRemove) {
        Collection<AnnotObject> values = pageObject.keys.values();
        block9: for (AnnotObject valueObject : values) {
            switch (valueObject.getType()) {
                case 8: {
                    if (objectsToRemove.containsKey(((AnnotOREF)valueObject).num)) {
                        return true;
                    }
                    try {
                        AnnotObject kidObj = info.mainBuffer.getObjectValue(valueObject);
                        if (kidObj.getType() != 5 || !PdfOptimizer.containsRemovedObjectsRef(info, (AnnotDict)kidObj, objectsToRemove)) continue block9;
                        return true;
                    }
                    catch (IOException e2) {
                        LogWriter.writeLog(e2);
                        break;
                    }
                }
                case 5: {
                    if (!PdfOptimizer.containsRemovedObjectsRef(info, (AnnotDict)valueObject, objectsToRemove)) break;
                    return true;
                }
                case 6: {
                    List<AnnotObject> children = ((AnnotArray)valueObject).items;
                    for (AnnotObject child : children) {
                        if (child == null) continue;
                        if (child.getType() == 8) {
                            if (objectsToRemove.containsKey(((AnnotOREF)child).num)) {
                                return true;
                            }
                            try {
                                AnnotObject kidObj = info.mainBuffer.getObjectValue(valueObject);
                                if (kidObj.getType() == 5 && PdfOptimizer.containsRemovedObjectsRef(info, (AnnotDict)kidObj, objectsToRemove)) {
                                    return true;
                                }
                            }
                            catch (IOException e3) {
                                LogWriter.writeLog(e3);
                            }
                        }
                        if (child.getType() != 5 || !PdfOptimizer.containsRemovedObjectsRef(info, (AnnotDict)child, objectsToRemove)) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    private static void scanPagesObject(AnnotInfo info, AnnotDict pagesObject, AnnotOREF[] pagesToKeep, HashMap<Integer, Boolean> objectsToRemove, AnnotOREF topLevelPages) throws IOException {
        objectsToRemove.put(topLevelPages.num, false);
        AnnotArray kidsArray = (AnnotArray)info.mainBuffer.getObjectValue(pagesObject.keys.get("Kids"));
        List<AnnotObject> kids = kidsArray.items;
        for (AnnotObject kid : kids) {
            if (kid.getType() != 5 && kid.getType() != 8) continue;
            AnnotDict kidObj = (AnnotDict)info.mainBuffer.getObjectValue(kid);
            AnnotName type = (AnnotName)kidObj.keys.get("Type");
            AnnotObject subKids = kidObj.keys.get("Kids");
            if (type != null && "Pages".equals(type.name) || subKids != null) {
                PdfOptimizer.scanPagesObject(info, kidObj, pagesToKeep, objectsToRemove, (AnnotOREF)kid);
                continue;
            }
            boolean removePage = Arrays.stream(pagesToKeep).noneMatch(keep -> ((AnnotOREF)kid).num == keep.num);
            int refNum = ((AnnotOREF)kid).num;
            objectsToRemove.put(refNum, removePage);
            kidObj.keys.put("Parent", topLevelPages);
            HashSet<Integer> currentStack = new HashSet<Integer>();
            currentStack.add(refNum);
            PdfOptimizer.scanObject(info, kidObj, objectsToRemove, removePage, currentStack);
        }
    }

    private static void scanObject(AnnotInfo info, AnnotDict pageObject, HashMap<Integer, Boolean> objectsToRemove, boolean onRemovedPage, Set<Integer> currentStack) {
        Set<String> keys = pageObject.keys.keySet();
        for (String key : keys) {
            AnnotObject valueObject = pageObject.keys.get(key);
            if ("Parent".equals(key)) continue;
            switch (valueObject.getType()) {
                case 8: {
                    int refNum = ((AnnotOREF)valueObject).num;
                    if (currentStack.contains(refNum)) {
                        return;
                    }
                    currentStack.add(refNum);
                    if (onRemovedPage) {
                        PdfOptimizer.flagForRemoval(objectsToRemove, refNum);
                    } else {
                        objectsToRemove.put(refNum, false);
                    }
                    try {
                        AnnotObject kidObj = info.mainBuffer.getObjectValue(valueObject);
                        if (kidObj.getType() == 5) {
                            PdfOptimizer.scanObject(info, (AnnotDict)kidObj, objectsToRemove, onRemovedPage, currentStack);
                        }
                    }
                    catch (IOException e2) {
                        LogWriter.writeLog(e2);
                    }
                    currentStack.remove(refNum);
                    break;
                }
                case 5: {
                    PdfOptimizer.scanObject(info, (AnnotDict)valueObject, objectsToRemove, onRemovedPage, currentStack);
                }
            }
        }
    }

    private static void flagForRemoval(HashMap<Integer, Boolean> objectsToRemove, int ref) {
        Boolean isForRemoval = objectsToRemove.getOrDefault(ref, true);
        objectsToRemove.put(ref, isForRemoval);
    }

    public static void main(String[] args) {
        int argCount = args.length;
        if (argCount == 2) {
            File input = new File(args[0]);
            File output = new File(args[1]);
            try {
                PdfOptimizer.optimizePDF(input, output);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            LogWriter.writeLog("PDFOptimizer requires 2 args. [Input filename, Output filename]");
        }
    }
}

