/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.tika;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.jpedal.examples.images.ExtractImages;
import org.jpedal.examples.text.ExtractStructuredText;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfImageData;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PDFParser
implements Parser {
    private final Ability ability;
    private final Set<MediaType> supportedTypes = Collections.singleton(MediaType.application((String)"pdf"));
    public static final String PASSWORD = "com.idrsolutions.tika.password";

    public PDFParser(Ability ability) {
        this.ability = ability;
    }

    public PDFParser() {
        this.ability = Ability.UNSTRUCTURED_TEXT;
    }

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.supportedTypes;
    }

    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        TikaInputStream tikaStream = TikaInputStream.cast((InputStream)inputStream);
        if (tikaStream == null) {
            throw new UnsupportedOperationException("File path should be passed as a TikaInputStream");
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(contentHandler, metadata);
        xhtml.startDocument();
        switch (this.ability) {
            case UNSTRUCTURED_TEXT: {
                PDFParser.unstructuredText(tikaStream, xhtml, metadata);
                break;
            }
            case STRUCTURED_TEXT: {
                PDFParser.structuredText(tikaStream, xhtml, metadata);
                break;
            }
            case IMAGE_METADATA: {
                PDFParser.imageMetadata(tikaStream, xhtml, metadata);
                break;
            }
        }
        xhtml.endDocument();
    }

    private static void unstructuredText(TikaInputStream tikaStream, XHTMLContentHandler xhtml, Metadata metadata) throws IOException, SAXException, TikaException {
        ExtractTextInRectangle extract = new ExtractTextInRectangle(tikaStream.getFile().getAbsolutePath());
        extract.setOutputFormat(ExtractTextInRectangle.OUTPUT_FORMAT.TXT);
        extract.setPassword(metadata.get(PASSWORD));
        try {
            if (!extract.openPDFFile()) {
                throw new IOException("Problem opening PDF file");
            }
            for (int page = 1; page <= extract.getPageCount(); ++page) {
                xhtml.startElement("p");
                xhtml.characters(extract.getTextOnPage(page));
                xhtml.endElement("p");
            }
        }
        catch (PdfException e2) {
            throw new TikaException(e2.getMessage());
        }
        finally {
            extract.closePDFfile();
        }
    }

    private static void structuredText(TikaInputStream tikaStream, XHTMLContentHandler xhtml, Metadata metadata) throws IOException, SAXException, TikaException {
        ExtractStructuredText extract = new ExtractStructuredText(tikaStream.getFile().getAbsolutePath());
        extract.setPassword(metadata.get(PASSWORD));
        try {
            if (!extract.openPDFFile()) {
                throw new IOException("Problem opening PDF file");
            }
            try {
                DOMSource domSource = new DOMSource(extract.getStructuredTextContent());
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.transform(domSource, streamResult);
                xhtml.characters(stringWriter.toString());
            }
            catch (TransformerException e2) {
                throw new TikaException(e2.getMessage());
            }
        }
        catch (PdfException e3) {
            throw new TikaException(e3.getMessage());
        }
        finally {
            extract.closePDFfile();
        }
    }

    private static void imageMetadata(TikaInputStream tikaStream, XHTMLContentHandler xhtml, Metadata metadata) throws IOException, SAXException, TikaException {
        ExtractImages extract = new ExtractImages(tikaStream.getFile().getAbsolutePath());
        extract.setPassword(metadata.get(PASSWORD));
        try {
            if (!extract.openPDFFile()) {
                throw new IOException("Problem opening PDF file");
            }
            AttributesImpl metaAttr = new AttributesImpl();
            metaAttr.addAttribute("", "name", "name", "CDATA", "fileSource");
            metaAttr.addAttribute("", "content", "content", "CDATA", tikaStream.getFile().getAbsolutePath());
            xhtml.startElement("meta", metaAttr);
            xhtml.endElement("meta");
            for (int page = 1; page <= extract.getPageCount(); ++page) {
                int imageCount = extract.getImageCount(page);
                if (imageCount == 0) continue;
                AttributesImpl pageAttrs = new AttributesImpl();
                pageAttrs.addAttribute("", "class", "class", "CDATA", "page");
                pageAttrs.addAttribute("", "data-page-number", "data-page-number", "CDATA", String.valueOf(page));
                xhtml.startElement("div", pageAttrs);
                PdfImageData imageData = extract.getImageData(page);
                for (int image = 0; image < imageCount; ++image) {
                    AttributesImpl imageAttrs = new AttributesImpl();
                    imageAttrs.addAttribute("", "class", "class", "CDATA", "image");
                    imageAttrs.addAttribute("", "data-image-index", "data-image-index", "CDATA", String.valueOf(image));
                    xhtml.startElement("div", imageAttrs);
                    xhtml.startElement("table");
                    xhtml.startElement("tr");
                    xhtml.startElement("th");
                    xhtml.characters("x1");
                    xhtml.endElement("th");
                    xhtml.startElement("th");
                    xhtml.characters("y1");
                    xhtml.endElement("th");
                    xhtml.startElement("th");
                    xhtml.characters("x2");
                    xhtml.endElement("th");
                    xhtml.startElement("th");
                    xhtml.characters("y2");
                    xhtml.endElement("th");
                    xhtml.endElement("tr");
                    xhtml.startElement("tr");
                    float x1 = imageData.getImageXCoord(image);
                    float y1 = imageData.getImageYCoord(image);
                    float w2 = imageData.getImageWidth(image);
                    float h2 = imageData.getImageHeight(image);
                    xhtml.startElement("td");
                    xhtml.characters(String.valueOf(x1));
                    xhtml.endElement("td");
                    xhtml.startElement("td");
                    xhtml.characters(String.valueOf(y1 + h2));
                    xhtml.endElement("td");
                    xhtml.startElement("td");
                    xhtml.characters(String.valueOf(x1 + w2));
                    xhtml.endElement("td");
                    xhtml.startElement("td");
                    xhtml.characters(String.valueOf(y1));
                    xhtml.endElement("td");
                    xhtml.endElement("tr");
                    xhtml.endElement("table");
                    xhtml.endElement("div");
                }
                xhtml.endElement("div");
            }
        }
        catch (PdfException e2) {
            throw new TikaException(e2.getMessage(), (Throwable)e2);
        }
        finally {
            extract.closePDFfile();
        }
    }

    public static enum Ability {
        UNSTRUCTURED_TEXT,
        STRUCTURED_TEXT,
        IMAGE_METADATA;

    }
}

