/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.sun;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class PrintfFormat {
    private final ArrayList<ConversionSpecification> vFmt = new ArrayList();
    private int cPos;
    private final DecimalFormatSymbols dfs;

    public PrintfFormat(String fmtArg) throws IllegalArgumentException {
        this(Locale.getDefault(), fmtArg);
    }

    public PrintfFormat(Locale locale, String fmtArg) throws IllegalArgumentException {
        ConversionSpecification sFmt;
        this.dfs = new DecimalFormatSymbols(locale);
        String unCS = this.nonControl(fmtArg, 0);
        if (unCS != null) {
            sFmt = new ConversionSpecification();
            sFmt.setLiteral(unCS);
            this.vFmt.add(sFmt);
        }
        while (this.cPos != -1 && this.cPos < fmtArg.length()) {
            char c2;
            int ePos;
            for (ePos = this.cPos + 1; ePos < fmtArg.length() && (c2 = fmtArg.charAt(ePos)) != 'i' && c2 != 'd' && c2 != 'f' && c2 != 'g' && c2 != 'G' && c2 != 'o' && c2 != 'x' && c2 != 'X' && c2 != 'e' && c2 != 'E' && c2 != 'c' && c2 != 's' && c2 != '%'; ++ePos) {
            }
            ePos = Math.min(ePos + 1, fmtArg.length());
            sFmt = new ConversionSpecification(fmtArg.substring(this.cPos, ePos));
            this.vFmt.add(sFmt);
            unCS = this.nonControl(fmtArg, ePos);
            if (unCS == null) continue;
            sFmt = new ConversionSpecification();
            sFmt.setLiteral(unCS);
            this.vFmt.add(sFmt);
        }
    }

    private String nonControl(String s2, int start) {
        this.cPos = s2.indexOf(37, start);
        if (this.cPos == -1) {
            this.cPos = s2.length();
        }
        return s2.substring(start, this.cPos);
    }

    public String sprintf(Object[] o2) {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        int i2 = 0;
        StringBuilder sb = new StringBuilder();
        block4: while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            switch (c2) {
                case '\u0000': {
                    sb.append(cs.getLiteral());
                    continue block4;
                }
                case '%': {
                    sb.append('%');
                    continue block4;
                }
            }
            if (cs.isPositionalSpecification()) {
                i2 = cs.getArgumentPosition() - 1;
                if (cs.isPositionalFieldWidth()) {
                    int ifw = cs.getArgumentPositionForFieldWidth() - 1;
                    cs.setFieldWidthWithArg((Integer)o2[ifw]);
                }
                if (cs.isPositionalPrecision()) {
                    int ipr = cs.getArgumentPositionForPrecision() - 1;
                    cs.setPrecisionWithArg((Integer)o2[ipr]);
                }
            } else {
                if (cs.isVariableFieldWidth()) {
                    cs.setFieldWidthWithArg((Integer)o2[i2]);
                    ++i2;
                }
                if (cs.isVariablePrecision()) {
                    cs.setPrecisionWithArg((Integer)o2[i2]);
                    ++i2;
                }
            }
            if (o2[i2] instanceof Byte) {
                sb.append(cs.internalsprintf(((Number)o2[i2]).byteValue()));
            } else if (o2[i2] instanceof Short) {
                sb.append(cs.internalsprintf(((Number)o2[i2]).shortValue()));
            } else if (o2[i2] instanceof Integer) {
                sb.append(cs.internalsprintf(((Number)o2[i2]).intValue()));
            } else if (o2[i2] instanceof Long) {
                sb.append(cs.internalsprintf(((Number)o2[i2]).longValue()));
            } else if (o2[i2] instanceof Float) {
                sb.append(cs.internalsprintf(((Number)o2[i2]).floatValue()));
            } else if (o2[i2] instanceof Double) {
                sb.append(cs.internalsprintf(((Number)o2[i2]).doubleValue()));
            } else if (o2[i2] instanceof Character) {
                sb.append(cs.internalsprintf(((Character)o2[i2]).charValue()));
            } else if (o2[i2] instanceof String) {
                sb.append(cs.internalsprintf((String)o2[i2]));
            } else {
                sb.append(cs.internalsprintf(o2[i2]));
            }
            if (cs.isPositionalSpecification()) continue;
            ++i2;
        }
        return sb.toString();
    }

    public String sprintf() {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        StringBuilder sb = new StringBuilder();
        while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            if (c2 == '\u0000') {
                sb.append(cs.getLiteral());
                continue;
            }
            if (c2 != '%') continue;
            sb.append('%');
        }
        return sb.toString();
    }

    public String sprintf(int x2) throws IllegalArgumentException {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        StringBuilder sb = new StringBuilder();
        block4: while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            switch (c2) {
                case '\u0000': {
                    sb.append(cs.getLiteral());
                    continue block4;
                }
                case '%': {
                    sb.append('%');
                    continue block4;
                }
            }
            sb.append(cs.internalsprintf(x2));
        }
        return sb.toString();
    }

    public String sprintf(long x2) throws IllegalArgumentException {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        StringBuilder sb = new StringBuilder();
        block4: while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            switch (c2) {
                case '\u0000': {
                    sb.append(cs.getLiteral());
                    continue block4;
                }
                case '%': {
                    sb.append('%');
                    continue block4;
                }
            }
            sb.append(cs.internalsprintf(x2));
        }
        return sb.toString();
    }

    public String sprintf(double x2) throws IllegalArgumentException {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        StringBuilder sb = new StringBuilder();
        block4: while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            switch (c2) {
                case '\u0000': {
                    sb.append(cs.getLiteral());
                    continue block4;
                }
                case '%': {
                    sb.append('%');
                    continue block4;
                }
            }
            sb.append(cs.internalsprintf(x2));
        }
        return sb.toString();
    }

    public String sprintf(String x2) throws IllegalArgumentException {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        StringBuilder sb = new StringBuilder();
        block4: while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            switch (c2) {
                case '\u0000': {
                    sb.append(cs.getLiteral());
                    continue block4;
                }
                case '%': {
                    sb.append('%');
                    continue block4;
                }
            }
            sb.append(cs.internalsprintf(x2));
        }
        return sb.toString();
    }

    public String sprintf(Object x2) throws IllegalArgumentException {
        Iterator<ConversionSpecification> e2 = this.vFmt.iterator();
        StringBuilder sb = new StringBuilder();
        block4: while (e2.hasNext()) {
            ConversionSpecification cs = e2.next();
            char c2 = cs.getConversionCharacter();
            switch (c2) {
                case '\u0000': {
                    sb.append(cs.getLiteral());
                    continue block4;
                }
                case '%': {
                    sb.append('%');
                    continue block4;
                }
            }
            if (x2 instanceof Byte) {
                sb.append(cs.internalsprintf(((Number)x2).byteValue()));
                continue;
            }
            if (x2 instanceof Short) {
                sb.append(cs.internalsprintf(((Number)x2).shortValue()));
                continue;
            }
            if (x2 instanceof Integer) {
                sb.append(cs.internalsprintf(((Number)x2).intValue()));
                continue;
            }
            if (x2 instanceof Long) {
                sb.append(cs.internalsprintf(((Number)x2).longValue()));
                continue;
            }
            if (x2 instanceof Float) {
                sb.append(cs.internalsprintf(((Number)x2).floatValue()));
                continue;
            }
            if (x2 instanceof Double) {
                sb.append(cs.internalsprintf(((Number)x2).doubleValue()));
                continue;
            }
            if (x2 instanceof Character) {
                sb.append(cs.internalsprintf(((Character)x2).charValue()));
                continue;
            }
            if (x2 instanceof String) {
                sb.append(cs.internalsprintf((String)x2));
                continue;
            }
            sb.append(cs.internalsprintf(x2));
        }
        return sb.toString();
    }

    private class ConversionSpecification {
        private boolean thousands;
        private boolean leftJustify;
        private boolean leadingSign;
        private boolean leadingSpace;
        private boolean alternateForm;
        private boolean leadingZeros;
        private boolean variableFieldWidth;
        private int fieldWidth;
        private boolean fieldWidthSet;
        private int precision;
        private static final int defaultDigits = 6;
        private boolean variablePrecision;
        private boolean precisionSet;
        private boolean positionalSpecification;
        private int argumentPosition;
        private boolean positionalFieldWidth;
        private int argumentPositionForFieldWidth;
        private boolean positionalPrecision;
        private int argumentPositionForPrecision;
        private boolean optionalh;
        private boolean optionall;
        private boolean optionalL;
        private char conversionCharacter;
        private int pos;
        private String fmt;

        ConversionSpecification() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ConversionSpecification(String fmtArg) throws IllegalArgumentException {
            if (fmtArg == null) {
                throw new IllegalArgumentException("ConversionSpecification expects a non-null value ");
            }
            if (fmtArg.isEmpty()) {
                throw new IllegalArgumentException("Control strings must have positive lengths.");
            }
            if (fmtArg.charAt(0) != '%') throw new IllegalArgumentException("Control strings must begin with %.");
            this.fmt = fmtArg;
            this.pos = 1;
            this.setArgPosition();
            this.setFlagCharacters();
            this.setFieldWidth();
            this.setPrecision();
            this.setOptionalHL();
            if (!this.setConversionCharacter()) throw new IllegalArgumentException("Malformed conversion specification=" + fmtArg);
            if (this.pos != fmtArg.length()) throw new IllegalArgumentException("Malformed conversion specification=" + fmtArg);
            if (this.leadingZeros && this.leftJustify) {
                this.leadingZeros = false;
            }
            if ((!this.precisionSet || !this.leadingZeros || this.conversionCharacter != 'd') && this.conversionCharacter != 'i' && this.conversionCharacter != 'o' && this.conversionCharacter != 'x') return;
            this.leadingZeros = false;
        }

        void setLiteral(String s2) {
            this.fmt = s2;
        }

        String getLiteral() {
            return this.fmt;
        }

        char getConversionCharacter() {
            return this.conversionCharacter;
        }

        boolean isVariableFieldWidth() {
            return this.variableFieldWidth;
        }

        void setFieldWidthWithArg(int fw) {
            if (fw < 0) {
                this.leftJustify = true;
            }
            this.fieldWidthSet = true;
            this.fieldWidth = Math.abs(fw);
        }

        boolean isVariablePrecision() {
            return this.variablePrecision;
        }

        void setPrecisionWithArg(int pr) {
            this.precisionSet = true;
            this.precision = Math.max(pr, 0);
        }

        String internalsprintf(int s2) throws IllegalArgumentException {
            String s22;
            switch (this.conversionCharacter) {
                case 'd': 
                case 'i': {
                    if (this.optionalh) {
                        s22 = this.printDFormat((short)s2);
                        break;
                    }
                    if (this.optionall) {
                        s22 = this.printDFormat((long)s2);
                        break;
                    }
                    s22 = this.printDFormat(s2);
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.optionalh) {
                        s22 = this.printXFormat((short)s2);
                        break;
                    }
                    if (this.optionall) {
                        s22 = this.printXFormat((long)s2);
                        break;
                    }
                    s22 = this.printXFormat(s2);
                    break;
                }
                case 'o': {
                    if (this.optionalh) {
                        s22 = this.printOFormat((short)s2);
                        break;
                    }
                    if (this.optionall) {
                        s22 = this.printOFormat((long)s2);
                        break;
                    }
                    s22 = this.printOFormat(s2);
                    break;
                }
                case 'C': 
                case 'c': {
                    s22 = this.printCFormat((char)s2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a int with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return s22;
        }

        String internalsprintf(long s2) throws IllegalArgumentException {
            String s22;
            switch (this.conversionCharacter) {
                case 'd': 
                case 'i': {
                    if (this.optionalh) {
                        s22 = this.printDFormat((short)s2);
                        break;
                    }
                    if (this.optionall) {
                        s22 = this.printDFormat(s2);
                        break;
                    }
                    s22 = this.printDFormat((int)s2);
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.optionalh) {
                        s22 = this.printXFormat((short)s2);
                        break;
                    }
                    if (this.optionall) {
                        s22 = this.printXFormat(s2);
                        break;
                    }
                    s22 = this.printXFormat((int)s2);
                    break;
                }
                case 'o': {
                    if (this.optionalh) {
                        s22 = this.printOFormat((short)s2);
                        break;
                    }
                    if (this.optionall) {
                        s22 = this.printOFormat(s2);
                        break;
                    }
                    s22 = this.printOFormat((int)s2);
                    break;
                }
                case 'C': 
                case 'c': {
                    s22 = this.printCFormat((char)s2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a long with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return s22;
        }

        String internalsprintf(double s2) throws IllegalArgumentException {
            String s22;
            switch (this.conversionCharacter) {
                case 'f': {
                    s22 = this.printFFormat(s2);
                    break;
                }
                case 'E': 
                case 'e': {
                    s22 = this.printEFormat(s2);
                    break;
                }
                case 'G': 
                case 'g': {
                    s22 = this.printGFormat(s2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a double with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return s22;
        }

        String internalsprintf(String s2) throws IllegalArgumentException {
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            String s22 = this.printSFormat(s2);
            return s22;
        }

        String internalsprintf(Object s2) {
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            String s22 = this.printSFormat(s2.toString());
            return s22;
        }

        private char[] fFormatDigits(double x2) {
            int dp;
            char[] ca5;
            char[] ca4;
            char[] ca3;
            int k2;
            String sx;
            int expon = 0;
            boolean minusSign = false;
            if (x2 > 0.0) {
                sx = Double.toString(x2);
            } else if (x2 < 0.0) {
                sx = Double.toString(-x2);
                minusSign = true;
            } else {
                sx = Double.toString(x2);
                if (sx.charAt(0) == '-') {
                    minusSign = true;
                    sx = sx.substring(1);
                }
            }
            int ePos = sx.indexOf(69);
            int rPos = sx.indexOf(46);
            int n1In = rPos != -1 ? rPos : (ePos != -1 ? ePos : sx.length());
            int n2In = rPos != -1 ? (ePos != -1 ? ePos - rPos - 1 : sx.length() - rPos - 1) : 0;
            if (ePos != -1) {
                int ie = ePos + 1;
                expon = 0;
                if (sx.charAt(ie) == '-') {
                    ++ie;
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = -Integer.parseInt(sx.substring(ie));
                    }
                } else {
                    if (sx.charAt(ie) == '+') {
                        ++ie;
                    }
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = Integer.parseInt(sx.substring(ie));
                    }
                }
            }
            int p2 = this.precisionSet ? this.precision : 5;
            char[] ca1 = sx.toCharArray();
            char[] ca2 = new char[n1In + n2In];
            int j2 = n1In;
            System.arraycopy(ca1, 0, ca2, 0, n1In);
            int i2 = j2 + 1;
            for (k2 = 0; k2 < n2In; ++k2) {
                ca2[j2] = ca1[i2];
                ++j2;
                ++i2;
            }
            if (n1In + expon <= 0) {
                ca3 = new char[-expon + n2In];
                j2 = 0;
                k2 = 0;
                while (k2 < -n1In - expon) {
                    ca3[j2] = 48;
                    ++k2;
                    ++j2;
                }
                i2 = 0;
                while (i2 < n1In + n2In) {
                    ca3[j2] = ca2[i2];
                    ++i2;
                    ++j2;
                }
            } else {
                ca3 = ca2;
            }
            boolean carry = false;
            if (p2 < -expon + n2In && (carry = this.checkForCarry(ca3, i2 = expon < 0 ? p2 : p2 + n1In))) {
                carry = this.startSymbolicCarry(ca3, i2 - 1, 0);
            }
            if (n1In + expon <= 0) {
                ca4 = new char[2 + p2];
                ca4[0] = !carry ? 48 : 49;
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    ca4[1] = 46;
                    i2 = 0;
                    j2 = 2;
                    while (i2 < Math.min(p2, ca3.length)) {
                        ca4[j2] = ca3[i2];
                        ++i2;
                        ++j2;
                    }
                    while (j2 < ca4.length) {
                        ca4[j2] = 48;
                        ++j2;
                    }
                }
            } else {
                if (!carry) {
                    ca4 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n1In + expon + p2 + 1] : new char[n1In + expon];
                    j2 = 0;
                } else {
                    ca4 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n1In + expon + p2 + 2] : new char[n1In + expon + 1];
                    ca4[0] = 49;
                    j2 = 1;
                }
                i2 = 0;
                while (i2 < Math.min(n1In + expon, ca3.length)) {
                    ca4[j2] = ca3[i2];
                    ++i2;
                    ++j2;
                }
                while (i2 < n1In + expon) {
                    ca4[j2] = 48;
                    ++i2;
                    ++j2;
                }
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    ca4[j2] = 46;
                    ++j2;
                    for (k2 = 0; i2 < ca3.length && k2 < p2; ++k2) {
                        ca4[j2] = ca3[i2];
                        ++i2;
                        ++j2;
                    }
                    while (j2 < ca4.length) {
                        ca4[j2] = 48;
                        ++j2;
                    }
                }
            }
            int nZeros = 0;
            if (!this.leftJustify && this.leadingZeros) {
                int xThousands = 0;
                if (this.thousands) {
                    int xdp;
                    int xlead = 0;
                    if (ca4[0] == '+' || ca4[0] == '-' || ca4[0] == ' ') {
                        xlead = 1;
                    }
                    for (xdp = xlead; xdp < ca4.length && ca4[xdp] != '.'; ++xdp) {
                    }
                    xThousands = (xdp - xlead) / 3;
                }
                if (this.fieldWidthSet) {
                    nZeros = this.fieldWidth - ca4.length;
                }
                if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                    --nZeros;
                }
                if ((nZeros -= xThousands) < 0) {
                    nZeros = 0;
                }
            }
            j2 = 0;
            if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                ca5 = new char[ca4.length + nZeros + 1];
                ++j2;
            } else {
                ca5 = new char[ca4.length + nZeros];
            }
            if (!minusSign) {
                if (this.leadingSign) {
                    ca5[0] = 43;
                }
                if (this.leadingSpace) {
                    ca5[0] = 32;
                }
            } else {
                ca5[0] = 45;
            }
            i2 = 0;
            while (i2 < nZeros) {
                ca5[j2] = 48;
                ++i2;
                ++j2;
            }
            i2 = 0;
            while (i2 < ca4.length) {
                ca5[j2] = ca4[i2];
                ++i2;
                ++j2;
            }
            int lead = 0;
            if (ca5[0] == '+' || ca5[0] == '-' || ca5[0] == ' ') {
                lead = 1;
            }
            for (dp = lead; dp < ca5.length && ca5[dp] != '.'; ++dp) {
            }
            int nThousands = (dp - lead) / 3;
            if (dp < ca5.length) {
                ca5[dp] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] ca6 = ca5;
            if (this.thousands && nThousands > 0) {
                ca6 = new char[ca5.length + nThousands + lead];
                ca6[0] = ca5[0];
                k2 = lead;
                for (i2 = lead; i2 < dp; ++i2) {
                    if (i2 > 0 && (dp - i2) % 3 == 0) {
                        ca6[k2] = PrintfFormat.this.dfs.getGroupingSeparator();
                        ca6[k2 + 1] = ca5[i2];
                        k2 += 2;
                        continue;
                    }
                    ca6[k2] = ca5[i2];
                    ++k2;
                }
                while (i2 < ca5.length) {
                    ca6[k2] = ca5[i2];
                    ++i2;
                    ++k2;
                }
            }
            return ca6;
        }

        private String fFormatString(double x2) {
            char[] ca6 = Double.isInfinite(x2) ? (x2 == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray()) : (Double.isNaN(x2) ? (this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray())) : this.fFormatDigits(x2));
            char[] ca7 = this.applyFloatPadding(ca6, false);
            return new String(ca7);
        }

        private char[] eFormatDigits(double x2, char eChar) {
            int dp;
            char[] ca3;
            int k2;
            int i2;
            int j2;
            char[] ca2;
            int i0;
            String sx;
            int expon = 0;
            boolean minusSign = false;
            if (x2 > 0.0) {
                sx = Double.toString(x2);
            } else if (x2 < 0.0) {
                sx = Double.toString(-x2);
                minusSign = true;
            } else {
                sx = Double.toString(x2);
                if (sx.charAt(0) == '-') {
                    minusSign = true;
                    sx = sx.substring(1);
                }
            }
            int ePos = sx.indexOf(69);
            if (ePos == -1) {
                ePos = sx.indexOf(101);
            }
            int rPos = sx.indexOf(46);
            if (ePos != -1) {
                int ie = ePos + 1;
                expon = 0;
                if (sx.charAt(ie) == '-') {
                    ++ie;
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = -Integer.parseInt(sx.substring(ie));
                    }
                } else {
                    if (sx.charAt(ie) == '+') {
                        ++ie;
                    }
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = Integer.parseInt(sx.substring(ie));
                    }
                }
            }
            if (rPos != -1) {
                expon += rPos - 1;
            }
            int p2 = this.precisionSet ? this.precision : 5;
            char[] ca1 = rPos != -1 && ePos != -1 ? (sx.substring(0, rPos) + sx.substring(rPos + 1, ePos)).toCharArray() : (rPos != -1 ? (sx.substring(0, rPos) + sx.substring(rPos + 1)).toCharArray() : (ePos != -1 ? sx.substring(0, ePos).toCharArray() : sx.toCharArray()));
            if (ca1[0] != '0') {
                i0 = 0;
            } else {
                for (i0 = 0; i0 < ca1.length && ca1[i0] == '0'; ++i0) {
                }
            }
            if (i0 + p2 < ca1.length - 1) {
                boolean carry = this.checkForCarry(ca1, i0 + p2 + 1);
                if (carry) {
                    carry = this.startSymbolicCarry(ca1, i0 + p2, i0);
                }
                if (carry) {
                    ca2 = new char[i0 + p2 + 1];
                    ca2[i0] = 49;
                    for (j2 = 0; j2 < i0; ++j2) {
                        ca2[j2] = 48;
                    }
                    i2 = i0;
                    for (j2 = i0 + 1; j2 < p2 + 1; ++j2) {
                        ca2[j2] = ca1[i2];
                        ++i2;
                    }
                    ++expon;
                    ca1 = ca2;
                }
            }
            int eSize = Math.abs(expon) < 100 && !this.optionalL ? 4 : 5;
            ca2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[2 + p2 + eSize] : new char[1 + eSize];
            if (ca1[0] != '0') {
                ca2[0] = ca1[0];
                j2 = 1;
            } else {
                for (j2 = 1; j2 < (ePos == -1 ? ca1.length : ePos) && ca1[j2] == '0'; ++j2) {
                }
                if (ePos != -1 && j2 < ePos || ePos == -1 && j2 < ca1.length) {
                    ca2[0] = ca1[j2];
                    expon -= j2;
                    ++j2;
                } else {
                    ca2[0] = 48;
                    j2 = 2;
                }
            }
            if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                ca2[1] = 46;
                i2 = 2;
            } else {
                i2 = 1;
            }
            for (k2 = 0; k2 < p2 && j2 < ca1.length; ++k2) {
                ca2[i2] = ca1[j2];
                ++j2;
                ++i2;
            }
            while (i2 < ca2.length - eSize) {
                ca2[i2] = 48;
                ++i2;
            }
            ca2[i2++] = eChar;
            ca2[i2++] = expon < 0 ? 45 : 43;
            if ((expon = Math.abs(expon)) >= 100) {
                switch (expon / 100) {
                    case 1: {
                        ca2[i2] = 49;
                        break;
                    }
                    case 2: {
                        ca2[i2] = 50;
                        break;
                    }
                    case 3: {
                        ca2[i2] = 51;
                        break;
                    }
                    case 4: {
                        ca2[i2] = 52;
                        break;
                    }
                    case 5: {
                        ca2[i2] = 53;
                        break;
                    }
                    case 6: {
                        ca2[i2] = 54;
                        break;
                    }
                    case 7: {
                        ca2[i2] = 55;
                        break;
                    }
                    case 8: {
                        ca2[i2] = 56;
                        break;
                    }
                    case 9: {
                        ca2[i2] = 57;
                    }
                }
                ++i2;
            }
            switch (expon % 100 / 10) {
                case 0: {
                    ca2[i2] = 48;
                    break;
                }
                case 1: {
                    ca2[i2] = 49;
                    break;
                }
                case 2: {
                    ca2[i2] = 50;
                    break;
                }
                case 3: {
                    ca2[i2] = 51;
                    break;
                }
                case 4: {
                    ca2[i2] = 52;
                    break;
                }
                case 5: {
                    ca2[i2] = 53;
                    break;
                }
                case 6: {
                    ca2[i2] = 54;
                    break;
                }
                case 7: {
                    ca2[i2] = 55;
                    break;
                }
                case 8: {
                    ca2[i2] = 56;
                    break;
                }
                case 9: {
                    ca2[i2] = 57;
                }
            }
            ++i2;
            switch (expon % 10) {
                case 0: {
                    ca2[i2] = 48;
                    break;
                }
                case 1: {
                    ca2[i2] = 49;
                    break;
                }
                case 2: {
                    ca2[i2] = 50;
                    break;
                }
                case 3: {
                    ca2[i2] = 51;
                    break;
                }
                case 4: {
                    ca2[i2] = 52;
                    break;
                }
                case 5: {
                    ca2[i2] = 53;
                    break;
                }
                case 6: {
                    ca2[i2] = 54;
                    break;
                }
                case 7: {
                    ca2[i2] = 55;
                    break;
                }
                case 8: {
                    ca2[i2] = 56;
                    break;
                }
                case 9: {
                    ca2[i2] = 57;
                }
            }
            int nZeros = 0;
            if (!this.leftJustify && this.leadingZeros) {
                int xThousands = 0;
                if (this.thousands) {
                    int xdp;
                    int xlead = 0;
                    if (ca2[0] == '+' || ca2[0] == '-' || ca2[0] == ' ') {
                        xlead = 1;
                    }
                    for (xdp = xlead; xdp < ca2.length && ca2[xdp] != '.'; ++xdp) {
                    }
                    xThousands = (xdp - xlead) / 3;
                }
                if (this.fieldWidthSet) {
                    nZeros = this.fieldWidth - ca2.length;
                }
                if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                    --nZeros;
                }
                if ((nZeros -= xThousands) < 0) {
                    nZeros = 0;
                }
            }
            j2 = 0;
            if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                ca3 = new char[ca2.length + nZeros + 1];
                ++j2;
            } else {
                ca3 = new char[ca2.length + nZeros];
            }
            if (!minusSign) {
                if (this.leadingSign) {
                    ca3[0] = 43;
                }
                if (this.leadingSpace) {
                    ca3[0] = 32;
                }
            } else {
                ca3[0] = 45;
            }
            for (k2 = 0; k2 < nZeros; ++k2) {
                ca3[j2] = 48;
                ++j2;
            }
            for (i2 = 0; i2 < ca2.length && j2 < ca3.length; ++i2, ++j2) {
                ca3[j2] = ca2[i2];
            }
            int lead = 0;
            if (ca3[0] == '+' || ca3[0] == '-' || ca3[0] == ' ') {
                lead = 1;
            }
            for (dp = lead; dp < ca3.length && ca3[dp] != '.'; ++dp) {
            }
            int nThousands = dp / 3;
            if (dp < ca3.length) {
                ca3[dp] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] ca4 = ca3;
            if (this.thousands && nThousands > 0) {
                ca4 = new char[ca3.length + nThousands + lead];
                ca4[0] = ca3[0];
                k2 = lead;
                for (i2 = lead; i2 < dp; ++i2) {
                    if (i2 > 0 && (dp - i2) % 3 == 0) {
                        ca4[k2] = PrintfFormat.this.dfs.getGroupingSeparator();
                        ca4[k2 + 1] = ca3[i2];
                        k2 += 2;
                        continue;
                    }
                    ca4[k2] = ca3[i2];
                    ++k2;
                }
                while (i2 < ca3.length) {
                    ca4[k2] = ca3[i2];
                    ++i2;
                    ++k2;
                }
            }
            return ca4;
        }

        private boolean checkForCarry(char[] ca1, int icarry) {
            boolean carry = false;
            if (icarry < ca1.length) {
                if (ca1[icarry] == '6' || ca1[icarry] == '7' || ca1[icarry] == '8' || ca1[icarry] == '9') {
                    carry = true;
                } else if (ca1[icarry] == '5') {
                    int ii;
                    for (ii = icarry + 1; ii < ca1.length && ca1[ii] == '0'; ++ii) {
                    }
                    boolean bl2 = carry = ii < ca1.length;
                    if (!carry && icarry > 0) {
                        carry = ca1[icarry - 1] == '1' || ca1[icarry - 1] == '3' || ca1[icarry - 1] == '5' || ca1[icarry - 1] == '7' || ca1[icarry - 1] == '9';
                    }
                }
            }
            return carry;
        }

        private boolean startSymbolicCarry(char[] ca, int cLast, int cFirst) {
            boolean carry = true;
            block12: for (int i2 = cLast; carry && i2 >= cFirst; --i2) {
                carry = false;
                switch (ca[i2]) {
                    case '0': {
                        ca[i2] = 49;
                        continue block12;
                    }
                    case '1': {
                        ca[i2] = 50;
                        continue block12;
                    }
                    case '2': {
                        ca[i2] = 51;
                        continue block12;
                    }
                    case '3': {
                        ca[i2] = 52;
                        continue block12;
                    }
                    case '4': {
                        ca[i2] = 53;
                        continue block12;
                    }
                    case '5': {
                        ca[i2] = 54;
                        continue block12;
                    }
                    case '6': {
                        ca[i2] = 55;
                        continue block12;
                    }
                    case '7': {
                        ca[i2] = 56;
                        continue block12;
                    }
                    case '8': {
                        ca[i2] = 57;
                        continue block12;
                    }
                    case '9': {
                        ca[i2] = 48;
                        carry = true;
                    }
                }
            }
            return carry;
        }

        private String eFormatString(double x2, char eChar) {
            char[] ca4 = Double.isInfinite(x2) ? (x2 == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray()) : (Double.isNaN(x2) ? (this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray())) : this.eFormatDigits(x2, eChar));
            char[] ca5 = this.applyFloatPadding(ca4, false);
            return new String(ca5);
        }

        private char[] applyFloatPadding(char[] ca4, boolean noDigits) {
            char[] ca5;
            block7: {
                int nBlanks;
                block9: {
                    int i2;
                    block8: {
                        ca5 = ca4;
                        if (!this.fieldWidthSet) break block7;
                        if (!this.leftJustify) break block8;
                        int nBlanks2 = this.fieldWidth - ca4.length;
                        if (nBlanks2 <= 0) break block7;
                        ca5 = new char[ca4.length + nBlanks2];
                        int i3 = ca4.length;
                        System.arraycopy(ca4, 0, ca5, 0, i3);
                        int j2 = 0;
                        while (j2 < nBlanks2) {
                            ca5[i3] = 32;
                            ++j2;
                            ++i3;
                        }
                        break block7;
                    }
                    if (this.leadingZeros && !noDigits) break block9;
                    int nBlanks3 = this.fieldWidth - ca4.length;
                    if (nBlanks3 <= 0) break block7;
                    ca5 = new char[ca4.length + nBlanks3];
                    for (i2 = 0; i2 < nBlanks3; ++i2) {
                        ca5[i2] = 32;
                    }
                    for (int j3 = 0; j3 < ca4.length; ++j3) {
                        ca5[i2] = ca4[j3];
                        ++i2;
                    }
                    break block7;
                }
                if (this.leadingZeros && (nBlanks = this.fieldWidth - ca4.length) > 0) {
                    ca5 = new char[ca4.length + nBlanks];
                    int i4 = 0;
                    int j4 = 0;
                    if (ca4[0] == '-') {
                        ca5[0] = 45;
                        ++i4;
                        ++j4;
                    }
                    for (int k2 = 0; k2 < nBlanks; ++k2) {
                        ca5[i4] = 48;
                        ++i4;
                    }
                    while (j4 < ca4.length) {
                        ca5[i4] = ca4[j4];
                        ++i4;
                        ++j4;
                    }
                }
            }
            return ca5;
        }

        private String printFFormat(double x2) {
            return this.fFormatString(x2);
        }

        private String printEFormat(double x2) {
            if (this.conversionCharacter == 'e') {
                return this.eFormatString(x2, 'e');
            }
            return this.eFormatString(x2, 'E');
        }

        private String printGFormat(double x2) {
            char[] ca4;
            int savePrecision = this.precision;
            if (Double.isInfinite(x2)) {
                ca4 = x2 == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
            } else if (Double.isNaN(x2)) {
                ca4 = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
            } else {
                StringBuilder ret;
                int ePos;
                String sx;
                if (!this.precisionSet) {
                    this.precision = 6;
                }
                if (this.precision == 0) {
                    this.precision = 1;
                }
                if (this.conversionCharacter == 'g') {
                    sx = this.eFormatString(x2, 'e').trim();
                    ePos = sx.indexOf(101);
                } else {
                    sx = this.eFormatString(x2, 'E').trim();
                    ePos = sx.indexOf(69);
                }
                int i2 = ePos + 1;
                int expon = 0;
                if (sx.charAt(i2) == '-') {
                    ++i2;
                    while (i2 < sx.length() && sx.charAt(i2) == '0') {
                        ++i2;
                    }
                    if (i2 < sx.length()) {
                        expon = -Integer.parseInt(sx.substring(i2));
                    }
                } else {
                    if (sx.charAt(i2) == '+') {
                        ++i2;
                    }
                    while (i2 < sx.length() && sx.charAt(i2) == '0') {
                        ++i2;
                    }
                    if (i2 < sx.length()) {
                        expon = Integer.parseInt(sx.substring(i2));
                    }
                }
                if (!this.alternateForm) {
                    String sy = expon >= -4 && expon < this.precision ? this.fFormatString(x2).trim() : sx.substring(0, ePos);
                    for (i2 = sy.length() - 1; i2 >= 0 && sy.charAt(i2) == '0'; --i2) {
                    }
                    if (i2 >= 0 && sy.charAt(i2) == '.') {
                        --i2;
                    }
                    String sz = i2 == -1 ? "0" : (!Character.isDigit(sy.charAt(i2)) ? sy.substring(0, i2 + 1) + '0' : sy.substring(0, i2 + 1));
                    if (expon >= -4 && expon < this.precision) {
                        ret = new StringBuilder(sz);
                    } else {
                        ret = new StringBuilder(sz);
                        ret.append(sx.substring(ePos));
                    }
                } else {
                    ret = expon >= -4 && expon < this.precision ? new StringBuilder(this.fFormatString(x2).trim()) : new StringBuilder(sx);
                }
                if (this.leadingSpace && x2 >= 0.0) {
                    ret.append(' ').append((CharSequence)ret);
                }
                ca4 = ret.toString().toCharArray();
            }
            char[] ca5 = this.applyFloatPadding(ca4, false);
            this.precision = savePrecision;
            return new String(ca5);
        }

        private String printDFormat(short x2) {
            return this.printDFormat(Short.toString(x2));
        }

        private String printDFormat(long x2) {
            return this.printDFormat(Long.toString(x2));
        }

        private String printDFormat(int x2) {
            return this.printDFormat(Integer.toString(x2));
        }

        private String printDFormat(String sx) {
            char[] ca;
            block28: {
                int jFirst;
                int j2;
                boolean neg;
                int i2;
                int nLeadingZeros;
                block31: {
                    int nBlanks;
                    block29: {
                        block32: {
                            block30: {
                                block27: {
                                    int j3;
                                    nLeadingZeros = 0;
                                    nBlanks = 0;
                                    int n2 = 0;
                                    i2 = 0;
                                    boolean bl2 = neg = sx.charAt(0) == '-';
                                    if ("0".equals(sx) && this.precisionSet && this.precision == 0) {
                                        sx = "";
                                    }
                                    if (!neg) {
                                        if (this.precisionSet && sx.length() < this.precision) {
                                            nLeadingZeros = this.precision - sx.length();
                                        }
                                    } else if (this.precisionSet && sx.length() - 1 < this.precision) {
                                        nLeadingZeros = this.precision - sx.length() + 1;
                                    }
                                    if (nLeadingZeros < 0) {
                                        nLeadingZeros = 0;
                                    }
                                    if (this.fieldWidthSet) {
                                        nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
                                        if (!neg && (this.leadingSign || this.leadingSpace)) {
                                            --nBlanks;
                                        }
                                    }
                                    if (nBlanks < 0) {
                                        nBlanks = 0;
                                    }
                                    if (this.leadingSign || this.leadingSpace) {
                                        ++n2;
                                    }
                                    n2 += nBlanks;
                                    n2 += nLeadingZeros;
                                    ca = new char[n2 += sx.length()];
                                    if (!this.leftJustify) break block27;
                                    if (neg) {
                                        ca[i2++] = 45;
                                    } else if (this.leadingSign) {
                                        ca[i2++] = 43;
                                    } else if (this.leadingSpace) {
                                        ca[i2++] = 32;
                                    }
                                    char[] csx = sx.toCharArray();
                                    int jFirst2 = neg ? 1 : 0;
                                    for (j3 = 0; j3 < nLeadingZeros; ++j3) {
                                        ca[i2] = 48;
                                        ++i2;
                                    }
                                    j3 = jFirst2;
                                    while (j3 < csx.length) {
                                        ca[i2] = csx[j3];
                                        ++j3;
                                        ++i2;
                                    }
                                    for (j3 = 0; j3 < nBlanks; ++j3) {
                                        ca[i2] = 32;
                                        ++i2;
                                    }
                                    break block28;
                                }
                                if (this.leadingZeros) break block29;
                                for (i2 = 0; i2 < nBlanks; ++i2) {
                                    ca[i2] = 32;
                                }
                                if (!neg) break block30;
                                ca[i2++] = 45;
                                break block31;
                            }
                            if (!this.leadingSign) break block32;
                            ca[i2++] = 43;
                            break block31;
                        }
                        if (!this.leadingSpace) break block31;
                        ca[i2++] = 32;
                        break block31;
                    }
                    if (neg) {
                        ca[i2++] = 45;
                    } else if (this.leadingSign) {
                        ca[i2++] = 43;
                    } else if (this.leadingSpace) {
                        ca[i2++] = 32;
                    }
                    j2 = 0;
                    while (j2 < nBlanks) {
                        ca[i2] = 48;
                        ++j2;
                        ++i2;
                    }
                }
                j2 = 0;
                while (j2 < nLeadingZeros) {
                    ca[i2] = 48;
                    ++j2;
                    ++i2;
                }
                char[] csx = sx.toCharArray();
                int j4 = jFirst = neg ? 1 : 0;
                while (j4 < csx.length) {
                    ca[i2] = csx[j4];
                    ++j4;
                    ++i2;
                }
            }
            return new String(ca);
        }

        private String printXFormat(short x2) {
            String sx = null;
            if (x2 == Short.MIN_VALUE) {
                sx = "8000";
            } else if (x2 < 0) {
                String t2 = Integer.toString(~(-x2 - 1) ^ Short.MIN_VALUE, 16);
                if (t2.charAt(0) == 'F' || t2.charAt(0) == 'f') {
                    t2 = t2.substring(16, 32);
                }
                block0 : switch (t2.length()) {
                    case 1: {
                        sx = "800" + t2;
                        break;
                    }
                    case 2: {
                        sx = "80" + t2;
                        break;
                    }
                    case 3: {
                        sx = '8' + t2;
                        break;
                    }
                    case 4: {
                        switch (t2.charAt(0)) {
                            case '1': {
                                sx = '9' + t2.substring(1, 4);
                                break block0;
                            }
                            case '2': {
                                sx = 'a' + t2.substring(1, 4);
                                break block0;
                            }
                            case '3': {
                                sx = 'b' + t2.substring(1, 4);
                                break block0;
                            }
                            case '4': {
                                sx = 'c' + t2.substring(1, 4);
                                break block0;
                            }
                            case '5': {
                                sx = 'd' + t2.substring(1, 4);
                                break block0;
                            }
                            case '6': {
                                sx = 'e' + t2.substring(1, 4);
                                break block0;
                            }
                            case '7': {
                                sx = 'f' + t2.substring(1, 4);
                            }
                        }
                    }
                }
            } else {
                sx = Integer.toString(x2, 16);
            }
            return this.printXFormat(sx);
        }

        private String printXFormat(long x2) {
            String sx = null;
            if (x2 == Long.MIN_VALUE) {
                sx = "8000000000000000";
            } else if (x2 < 0L) {
                String t2 = Long.toString(-x2 - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 16);
                block0 : switch (t2.length()) {
                    case 1: {
                        sx = "800000000000000" + t2;
                        break;
                    }
                    case 2: {
                        sx = "80000000000000" + t2;
                        break;
                    }
                    case 3: {
                        sx = "8000000000000" + t2;
                        break;
                    }
                    case 4: {
                        sx = "800000000000" + t2;
                        break;
                    }
                    case 5: {
                        sx = "80000000000" + t2;
                        break;
                    }
                    case 6: {
                        sx = "8000000000" + t2;
                        break;
                    }
                    case 7: {
                        sx = "800000000" + t2;
                        break;
                    }
                    case 8: {
                        sx = "80000000" + t2;
                        break;
                    }
                    case 9: {
                        sx = "8000000" + t2;
                        break;
                    }
                    case 10: {
                        sx = "800000" + t2;
                        break;
                    }
                    case 11: {
                        sx = "80000" + t2;
                        break;
                    }
                    case 12: {
                        sx = "8000" + t2;
                        break;
                    }
                    case 13: {
                        sx = "800" + t2;
                        break;
                    }
                    case 14: {
                        sx = "80" + t2;
                        break;
                    }
                    case 15: {
                        sx = '8' + t2;
                        break;
                    }
                    case 16: {
                        switch (t2.charAt(0)) {
                            case '1': {
                                sx = '9' + t2.substring(1, 16);
                                break block0;
                            }
                            case '2': {
                                sx = 'a' + t2.substring(1, 16);
                                break block0;
                            }
                            case '3': {
                                sx = 'b' + t2.substring(1, 16);
                                break block0;
                            }
                            case '4': {
                                sx = 'c' + t2.substring(1, 16);
                                break block0;
                            }
                            case '5': {
                                sx = 'd' + t2.substring(1, 16);
                                break block0;
                            }
                            case '6': {
                                sx = 'e' + t2.substring(1, 16);
                                break block0;
                            }
                            case '7': {
                                sx = 'f' + t2.substring(1, 16);
                            }
                        }
                    }
                }
            } else {
                sx = Long.toString(x2, 16);
            }
            return this.printXFormat(sx);
        }

        private String printXFormat(int x2) {
            String sx = null;
            if (x2 == Integer.MIN_VALUE) {
                sx = "80000000";
            } else if (x2 < 0) {
                String t2 = Integer.toString(~(-x2 - 1) ^ Integer.MIN_VALUE, 16);
                block0 : switch (t2.length()) {
                    case 1: {
                        sx = "8000000" + t2;
                        break;
                    }
                    case 2: {
                        sx = "800000" + t2;
                        break;
                    }
                    case 3: {
                        sx = "80000" + t2;
                        break;
                    }
                    case 4: {
                        sx = "8000" + t2;
                        break;
                    }
                    case 5: {
                        sx = "800" + t2;
                        break;
                    }
                    case 6: {
                        sx = "80" + t2;
                        break;
                    }
                    case 7: {
                        sx = '8' + t2;
                        break;
                    }
                    case 8: {
                        switch (t2.charAt(0)) {
                            case '1': {
                                sx = '9' + t2.substring(1, 8);
                                break block0;
                            }
                            case '2': {
                                sx = 'a' + t2.substring(1, 8);
                                break block0;
                            }
                            case '3': {
                                sx = 'b' + t2.substring(1, 8);
                                break block0;
                            }
                            case '4': {
                                sx = 'c' + t2.substring(1, 8);
                                break block0;
                            }
                            case '5': {
                                sx = 'd' + t2.substring(1, 8);
                                break block0;
                            }
                            case '6': {
                                sx = 'e' + t2.substring(1, 8);
                                break block0;
                            }
                            case '7': {
                                sx = 'f' + t2.substring(1, 8);
                            }
                        }
                    }
                }
            } else {
                sx = Integer.toString(x2, 16);
            }
            return this.printXFormat(sx);
        }

        private String printXFormat(String sx) {
            char[] csx;
            int nLeadingZeros = 0;
            int nBlanks = 0;
            if ("0".equals(sx) && this.precisionSet && this.precision == 0) {
                sx = "";
            }
            if (this.precisionSet) {
                nLeadingZeros = this.precision - sx.length();
            }
            if (nLeadingZeros < 0) {
                nLeadingZeros = 0;
            }
            if (this.fieldWidthSet) {
                nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
                if (this.alternateForm) {
                    nBlanks -= 2;
                }
            }
            if (nBlanks < 0) {
                nBlanks = 0;
            }
            int n2 = 0;
            if (this.alternateForm) {
                n2 += 2;
            }
            n2 += nLeadingZeros;
            n2 += sx.length();
            char[] ca = new char[n2 += nBlanks];
            int i2 = 0;
            if (this.leftJustify) {
                if (this.alternateForm) {
                    ca[i2++] = 48;
                    ca[i2++] = 120;
                }
                int j2 = 0;
                while (j2 < nLeadingZeros) {
                    ca[i2] = 48;
                    ++j2;
                    ++i2;
                }
                csx = sx.toCharArray();
                int j3 = 0;
                while (j3 < csx.length) {
                    ca[i2] = csx[j3];
                    ++j3;
                    ++i2;
                }
                j3 = 0;
                while (j3 < nBlanks) {
                    ca[i2] = 32;
                    ++j3;
                    ++i2;
                }
            } else {
                int j4;
                if (!this.leadingZeros) {
                    j4 = 0;
                    while (j4 < nBlanks) {
                        ca[i2] = 32;
                        ++j4;
                        ++i2;
                    }
                }
                if (this.alternateForm) {
                    ca[i2++] = 48;
                    ca[i2++] = 120;
                }
                if (this.leadingZeros) {
                    j4 = 0;
                    while (j4 < nBlanks) {
                        ca[i2] = 48;
                        ++j4;
                        ++i2;
                    }
                }
                j4 = 0;
                while (j4 < nLeadingZeros) {
                    ca[i2] = 48;
                    ++j4;
                    ++i2;
                }
                csx = sx.toCharArray();
                int j5 = 0;
                while (j5 < csx.length) {
                    ca[i2] = csx[j5];
                    ++j5;
                    ++i2;
                }
            }
            String caReturn = new String(ca);
            if (this.conversionCharacter == 'X') {
                caReturn = caReturn.toUpperCase();
            }
            return caReturn;
        }

        private String printOFormat(short x2) {
            String sx = null;
            if (x2 == Short.MIN_VALUE) {
                sx = "100000";
            } else if (x2 < 0) {
                String t2 = Integer.toString(~(-x2 - 1) ^ Short.MIN_VALUE, 8);
                switch (t2.length()) {
                    case 1: {
                        sx = "10000" + t2;
                        break;
                    }
                    case 2: {
                        sx = "1000" + t2;
                        break;
                    }
                    case 3: {
                        sx = "100" + t2;
                        break;
                    }
                    case 4: {
                        sx = "10" + t2;
                        break;
                    }
                    case 5: {
                        sx = '1' + t2;
                    }
                }
            } else {
                sx = Integer.toString(x2, 8);
            }
            return this.printOFormat(sx);
        }

        private String printOFormat(long x2) {
            String sx = null;
            if (x2 == Long.MIN_VALUE) {
                sx = "1000000000000000000000";
            } else if (x2 < 0L) {
                String t2 = Long.toString(-x2 - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 8);
                switch (t2.length()) {
                    case 1: {
                        sx = "100000000000000000000" + t2;
                        break;
                    }
                    case 2: {
                        sx = "10000000000000000000" + t2;
                        break;
                    }
                    case 3: {
                        sx = "1000000000000000000" + t2;
                        break;
                    }
                    case 4: {
                        sx = "100000000000000000" + t2;
                        break;
                    }
                    case 5: {
                        sx = "10000000000000000" + t2;
                        break;
                    }
                    case 6: {
                        sx = "1000000000000000" + t2;
                        break;
                    }
                    case 7: {
                        sx = "100000000000000" + t2;
                        break;
                    }
                    case 8: {
                        sx = "10000000000000" + t2;
                        break;
                    }
                    case 9: {
                        sx = "1000000000000" + t2;
                        break;
                    }
                    case 10: {
                        sx = "100000000000" + t2;
                        break;
                    }
                    case 11: {
                        sx = "10000000000" + t2;
                        break;
                    }
                    case 12: {
                        sx = "1000000000" + t2;
                        break;
                    }
                    case 13: {
                        sx = "100000000" + t2;
                        break;
                    }
                    case 14: {
                        sx = "10000000" + t2;
                        break;
                    }
                    case 15: {
                        sx = "1000000" + t2;
                        break;
                    }
                    case 16: {
                        sx = "100000" + t2;
                        break;
                    }
                    case 17: {
                        sx = "10000" + t2;
                        break;
                    }
                    case 18: {
                        sx = "1000" + t2;
                        break;
                    }
                    case 19: {
                        sx = "100" + t2;
                        break;
                    }
                    case 20: {
                        sx = "10" + t2;
                        break;
                    }
                    case 21: {
                        sx = '1' + t2;
                    }
                }
            } else {
                sx = Long.toString(x2, 8);
            }
            return this.printOFormat(sx);
        }

        private String printOFormat(int x2) {
            String sx = null;
            if (x2 == Integer.MIN_VALUE) {
                sx = "20000000000";
            } else if (x2 < 0) {
                String t2 = Integer.toString(~(-x2 - 1) ^ Integer.MIN_VALUE, 8);
                switch (t2.length()) {
                    case 1: {
                        sx = "2000000000" + t2;
                        break;
                    }
                    case 2: {
                        sx = "200000000" + t2;
                        break;
                    }
                    case 3: {
                        sx = "20000000" + t2;
                        break;
                    }
                    case 4: {
                        sx = "2000000" + t2;
                        break;
                    }
                    case 5: {
                        sx = "200000" + t2;
                        break;
                    }
                    case 6: {
                        sx = "20000" + t2;
                        break;
                    }
                    case 7: {
                        sx = "2000" + t2;
                        break;
                    }
                    case 8: {
                        sx = "200" + t2;
                        break;
                    }
                    case 9: {
                        sx = "20" + t2;
                        break;
                    }
                    case 10: {
                        sx = '2' + t2;
                        break;
                    }
                    case 11: {
                        sx = '3' + t2.substring(1);
                    }
                }
            } else {
                sx = Integer.toString(x2, 8);
            }
            return this.printOFormat(sx);
        }

        private String printOFormat(String sx) {
            int nLeadingZeros = 0;
            int nBlanks = 0;
            if ("0".equals(sx) && this.precisionSet && this.precision == 0) {
                sx = "";
            }
            if (this.precisionSet) {
                nLeadingZeros = this.precision - sx.length();
            }
            if (this.alternateForm) {
                ++nLeadingZeros;
            }
            if (nLeadingZeros < 0) {
                nLeadingZeros = 0;
            }
            if (this.fieldWidthSet) {
                nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
            }
            if (nBlanks < 0) {
                nBlanks = 0;
            }
            int n2 = nLeadingZeros + sx.length() + nBlanks;
            char[] ca = new char[n2];
            if (this.leftJustify) {
                int i2;
                for (i2 = 0; i2 < nLeadingZeros; ++i2) {
                    ca[i2] = 48;
                }
                char[] csx = sx.toCharArray();
                int j2 = 0;
                while (j2 < csx.length) {
                    ca[i2] = csx[j2];
                    ++j2;
                    ++i2;
                }
                j2 = 0;
                while (j2 < nBlanks) {
                    ca[i2] = 32;
                    ++j2;
                    ++i2;
                }
            } else {
                int i3;
                if (this.leadingZeros) {
                    for (i3 = 0; i3 < nBlanks; ++i3) {
                        ca[i3] = 48;
                    }
                } else {
                    for (i3 = 0; i3 < nBlanks; ++i3) {
                        ca[i3] = 32;
                    }
                }
                int j3 = 0;
                while (j3 < nLeadingZeros) {
                    ca[i3] = 48;
                    ++j3;
                    ++i3;
                }
                char[] csx = sx.toCharArray();
                int j4 = 0;
                while (j4 < csx.length) {
                    ca[i3] = csx[j4];
                    ++j4;
                    ++i3;
                }
            }
            return new String(ca);
        }

        private String printCFormat(char x2) {
            boolean nPrint = true;
            int width = this.fieldWidth;
            if (!this.fieldWidthSet) {
                width = 1;
            }
            char[] ca = new char[width];
            if (this.leftJustify) {
                ca[0] = x2;
                for (int i2 = 1; i2 <= width - 1; ++i2) {
                    ca[i2] = 32;
                }
            } else {
                for (int i3 = 0; i3 < width - 1; ++i3) {
                    ca[i3] = 32;
                }
                ca[i3] = x2;
            }
            return new String(ca);
        }

        private String printSFormat(String x2) {
            int nPrint = x2.length();
            int width = this.fieldWidth;
            if (this.precisionSet && nPrint > this.precision) {
                nPrint = this.precision;
            }
            if (!this.fieldWidthSet) {
                width = nPrint;
            }
            int n2 = 0;
            if (width > nPrint) {
                n2 += width - nPrint;
            }
            n2 = nPrint >= x2.length() ? (n2 += x2.length()) : (n2 += nPrint);
            char[] ca = new char[n2];
            if (this.leftJustify) {
                int i2;
                char[] csx;
                if (nPrint >= x2.length()) {
                    csx = x2.toCharArray();
                    i2 = x2.length();
                    System.arraycopy(csx, 0, ca, 0, i2);
                } else {
                    csx = x2.substring(0, nPrint).toCharArray();
                    i2 = nPrint;
                    System.arraycopy(csx, 0, ca, 0, i2);
                }
                int j2 = 0;
                while (j2 < width - nPrint) {
                    ca[i2] = 32;
                    ++j2;
                    ++i2;
                }
            } else {
                int i3;
                for (i3 = 0; i3 < width - nPrint; ++i3) {
                    ca[i3] = 32;
                }
                if (nPrint >= x2.length()) {
                    char[] csx = x2.toCharArray();
                    for (int j3 = 0; j3 < x2.length(); ++j3) {
                        ca[i3] = csx[j3];
                        ++i3;
                    }
                } else {
                    char[] csx = x2.substring(0, nPrint).toCharArray();
                    for (int j4 = 0; j4 < nPrint; ++j4) {
                        ca[i3] = csx[j4];
                        ++i3;
                    }
                }
            }
            return new String(ca);
        }

        private boolean setConversionCharacter() {
            char c2;
            boolean ret = false;
            this.conversionCharacter = '\u0000';
            if (this.pos < this.fmt.length() && ((c2 = this.fmt.charAt(this.pos)) == 'i' || c2 == 'd' || c2 == 'f' || c2 == 'g' || c2 == 'G' || c2 == 'o' || c2 == 'x' || c2 == 'X' || c2 == 'e' || c2 == 'E' || c2 == 'c' || c2 == 's' || c2 == '%')) {
                this.conversionCharacter = c2;
                ++this.pos;
                ret = true;
            }
            return ret;
        }

        private void setOptionalHL() {
            this.optionalh = false;
            this.optionall = false;
            this.optionalL = false;
            if (this.pos < this.fmt.length()) {
                char c2 = this.fmt.charAt(this.pos);
                switch (c2) {
                    case 'h': {
                        this.optionalh = true;
                        ++this.pos;
                        break;
                    }
                    case 'l': {
                        this.optionall = true;
                        ++this.pos;
                        break;
                    }
                    case 'L': {
                        this.optionalL = true;
                        ++this.pos;
                        break;
                    }
                }
            }
        }

        private void setPrecision() {
            int firstPos = this.pos;
            this.precisionSet = false;
            if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '.') {
                ++this.pos;
                if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '*') {
                    ++this.pos;
                    if (!this.setPrecisionArgPosition()) {
                        this.variablePrecision = true;
                        this.precisionSet = true;
                    }
                } else {
                    char c2;
                    while (this.pos < this.fmt.length() && Character.isDigit(c2 = this.fmt.charAt(this.pos))) {
                        ++this.pos;
                    }
                    if (this.pos > firstPos + 1) {
                        String sz = this.fmt.substring(firstPos + 1, this.pos);
                        this.precision = Integer.parseInt(sz);
                        this.precisionSet = true;
                    }
                }
            }
        }

        private void setFieldWidth() {
            int firstPos = this.pos;
            this.fieldWidth = 0;
            this.fieldWidthSet = false;
            if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '*') {
                ++this.pos;
                if (!this.setFieldWidthArgPosition()) {
                    this.variableFieldWidth = true;
                    this.fieldWidthSet = true;
                }
            } else {
                char c2;
                while (this.pos < this.fmt.length() && Character.isDigit(c2 = this.fmt.charAt(this.pos))) {
                    ++this.pos;
                }
                if (firstPos < this.pos && firstPos < this.fmt.length()) {
                    String sz = this.fmt.substring(firstPos, this.pos);
                    this.fieldWidth = Integer.parseInt(sz);
                    this.fieldWidthSet = true;
                }
            }
        }

        private void setArgPosition() {
            int xPos;
            for (xPos = this.pos; xPos < this.fmt.length() && Character.isDigit(this.fmt.charAt(xPos)); ++xPos) {
            }
            if (xPos > this.pos && xPos < this.fmt.length() && this.fmt.charAt(xPos) == '$') {
                this.positionalSpecification = true;
                this.argumentPosition = Integer.parseInt(this.fmt.substring(this.pos, xPos));
                this.pos = xPos + 1;
            }
        }

        private boolean setFieldWidthArgPosition() {
            int xPos;
            boolean ret = false;
            for (xPos = this.pos; xPos < this.fmt.length() && Character.isDigit(this.fmt.charAt(xPos)); ++xPos) {
            }
            if (xPos > this.pos && xPos < this.fmt.length() && this.fmt.charAt(xPos) == '$') {
                this.positionalFieldWidth = true;
                this.argumentPositionForFieldWidth = Integer.parseInt(this.fmt.substring(this.pos, xPos));
                this.pos = xPos + 1;
                ret = true;
            }
            return ret;
        }

        private boolean setPrecisionArgPosition() {
            int xPos;
            boolean ret = false;
            for (xPos = this.pos; xPos < this.fmt.length() && Character.isDigit(this.fmt.charAt(xPos)); ++xPos) {
            }
            if (xPos > this.pos && xPos < this.fmt.length() && this.fmt.charAt(xPos) == '$') {
                this.positionalPrecision = true;
                this.argumentPositionForPrecision = Integer.parseInt(this.fmt.substring(this.pos, xPos));
                this.pos = xPos + 1;
                ret = true;
            }
            return ret;
        }

        boolean isPositionalSpecification() {
            return this.positionalSpecification;
        }

        int getArgumentPosition() {
            return this.argumentPosition;
        }

        boolean isPositionalFieldWidth() {
            return this.positionalFieldWidth;
        }

        int getArgumentPositionForFieldWidth() {
            return this.argumentPositionForFieldWidth;
        }

        boolean isPositionalPrecision() {
            return this.positionalPrecision;
        }

        int getArgumentPositionForPrecision() {
            return this.argumentPositionForPrecision;
        }

        private void setFlagCharacters() {
            this.thousands = false;
            this.leftJustify = false;
            this.leadingSign = false;
            this.leadingSpace = false;
            this.alternateForm = false;
            this.leadingZeros = false;
            block8: while (this.pos < this.fmt.length()) {
                char c2 = this.fmt.charAt(this.pos);
                switch (c2) {
                    case '\'': {
                        this.thousands = true;
                        break;
                    }
                    case '-': {
                        this.leftJustify = true;
                        this.leadingZeros = false;
                        break;
                    }
                    case '+': {
                        this.leadingSign = true;
                        this.leadingSpace = false;
                        break;
                    }
                    case ' ': {
                        if (this.leadingSign) break;
                        this.leadingSpace = true;
                        break;
                    }
                    case '#': {
                        this.alternateForm = true;
                        break;
                    }
                    case '0': {
                        if (this.leftJustify) break;
                        this.leadingZeros = true;
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                ++this.pos;
            }
        }
    }
}

