/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.json;

import org.jpedal.render.output.json.Json;
import org.jpedal.render.output.json.JsonArray;
import org.jpedal.render.output.json.JsonPreformattedElement;

public class JsonObject {
    private final StringBuilder output = new StringBuilder();
    private boolean isFinal;

    public JsonObject() {
        this.output.append('{');
    }

    private void appendKey(String key) {
        if (this.output.length() > 1) {
            this.output.append(',');
        }
        this.output.append('\"').append(key).append("\":");
    }

    public JsonObject add(String key, String value) {
        this.appendKey(key);
        this.output.append(Json.format(value != null ? value : ""));
        return this;
    }

    public JsonObject add(String key, int value) {
        this.appendKey(key);
        this.output.append(value);
        return this;
    }

    public JsonObject add(String key, JsonObject value) {
        this.appendKey(key);
        this.output.append(value);
        return this;
    }

    public JsonObject add(String key, boolean value) {
        this.appendKey(key);
        this.output.append(value);
        return this;
    }

    public JsonObject add(String key, String[] value) {
        this.appendKey(key);
        this.output.append(Json.format(value));
        return this;
    }

    public JsonObject add(String key, int[] value) {
        this.appendKey(key);
        this.output.append(Json.format(value));
        return this;
    }

    public JsonObject add(String key, float[] value) {
        this.appendKey(key);
        this.output.append(Json.format(value));
        return this;
    }

    public JsonObject add(String key, JsonObject[] value) {
        this.appendKey(key);
        this.output.append(Json.format(value));
        return this;
    }

    public JsonObject add(String key, boolean[] value) {
        this.appendKey(key);
        this.output.append(Json.format(value));
        return this;
    }

    public JsonObject add(String key, JsonArray value) {
        this.appendKey(key);
        this.output.append(value);
        return this;
    }

    public JsonObject add(String key, JsonPreformattedElement value) {
        this.appendKey(key);
        this.output.append(value);
        return this;
    }

    public String toString() {
        if (!this.isFinal) {
            this.output.append('}');
            this.isFinal = true;
        }
        return this.output.toString();
    }
}

