/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.json;

import org.jpedal.render.output.json.JsonArray;
import org.jpedal.render.output.json.JsonObject;
import org.jpedal.render.output.json.JsonPreformattedElement;

public final class Json {
    private static final String[] CONTROL_CHARACTER_REPLACEMENTS = new String[32];

    private Json() {
    }

    public static JsonArray array() {
        return new JsonArray();
    }

    public static JsonObject object() {
        return new JsonObject();
    }

    public static JsonPreformattedElement preformatted(String value) {
        return new JsonPreformattedElement(value);
    }

    public static String format(String value) {
        StringBuilder formatted = new StringBuilder(value.length() << 1);
        formatted.append('\"');
        for (char c2 : value.toCharArray()) {
            if (c2 < ' ') {
                formatted.append(CONTROL_CHARACTER_REPLACEMENTS[c2]);
                continue;
            }
            if (c2 == '\\') {
                formatted.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                formatted.append("\\\"");
                continue;
            }
            formatted.append(c2);
        }
        formatted.append('\"');
        return formatted.toString();
    }

    public static String format(String[] values) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        if (values.length != 0) {
            result.append(Json.format(values[0]));
            for (int i2 = 1; i2 < values.length; ++i2) {
                result.append(',').append(Json.format(values[i2]));
            }
        }
        result.append(']');
        return result.toString();
    }

    public static String format(int[] values) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        if (values.length != 0) {
            result.append(values[0]);
            for (int i2 = 1; i2 < values.length; ++i2) {
                result.append(',').append(values[i2]);
            }
        }
        result.append(']');
        return result.toString();
    }

    public static String format(float[] values) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        if (values.length != 0) {
            result.append(values[0]);
            for (int i2 = 1; i2 < values.length; ++i2) {
                result.append(',').append(values[i2]);
            }
        }
        result.append(']');
        return result.toString();
    }

    public static String format(JsonObject[] values) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        if (values.length != 0) {
            result.append(values[0]);
            for (int i2 = 1; i2 < values.length; ++i2) {
                result.append(',').append(values[i2]);
            }
        }
        result.append(']');
        return result.toString();
    }

    public static String format(boolean[] values) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        if (values.length != 0) {
            result.append(values[0]);
            for (int i2 = 1; i2 < values.length; ++i2) {
                result.append(',').append(values[i2]);
            }
        }
        result.append(']');
        return result.toString();
    }

    static {
        for (int i2 = 0; i2 < 32; ++i2) {
            Json.CONTROL_CHARACTER_REPLACEMENTS[i2] = String.format("\\u%04x", i2);
        }
        Json.CONTROL_CHARACTER_REPLACEMENTS[9] = "\\t";
        Json.CONTROL_CHARACTER_REPLACEMENTS[8] = "\\b";
        Json.CONTROL_CHARACTER_REPLACEMENTS[10] = "\\n";
        Json.CONTROL_CHARACTER_REPLACEMENTS[13] = "\\r";
        Json.CONTROL_CHARACTER_REPLACEMENTS[12] = "\\f";
    }
}

