/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.util.Arrays;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public final class HTMLFontHandler {
    private HTMLFontHandler() {
    }

    public static void processFont(PdfFont restoredFont, DynamicVectorRenderer current, PdfObject newFont, PdfObjectReader currentPdfFile) {
        if (!restoredFont.isFontEmbedded) {
            LogWriter.writeLog("[HTML/SVG] Font " + restoredFont.getFontName() + " is not embedded and will be replaced with a fallback");
        }
        HTMLFontHandler.handleFontInHTML(newFont, current, restoredFont, currentPdfFile);
    }

    private static void handleFontInHTML(PdfObject newFont, DynamicVectorRenderer current, PdfFont restoredFont, PdfObjectReader currentPdfFile) {
        PdfObject Descendant;
        PdfObject pdfFontDescriptor = newFont.getDictionary(-1044665361);
        boolean isCidType2 = false;
        if (pdfFontDescriptor == null && (Descendant = newFont.getDictionary(-1547306032)) != null) {
            pdfFontDescriptor = Descendant.getDictionary(-1044665361);
            boolean bl2 = isCidType2 = Descendant.getNameAsConstant(1147962727) == -1684566724;
        }
        if (pdfFontDescriptor != null && current.getBooleanValue(45)) {
            PdfObject font = pdfFontDescriptor.getDictionary(746093177);
            font = font == null ? pdfFontDescriptor.getDictionary(2021292334) : font;
            font = font == null ? pdfFontDescriptor.getDictionary(2021292335) : font;
            restoredFont.getGlyphData().setRenderer(current);
            if (font != null) {
                byte[] stream = currentPdfFile.readStream(font, true, true, false, false, false, font.getCacheName(currentPdfFile.getObjectReader()));
                String tag = HTMLFontHandler.checkStreamType(stream, 0, isCidType2);
                if (tag == null) {
                    int offset = 0;
                    while (tag == null && offset + 5 < stream.length) {
                        tag = HTMLFontHandler.checkStreamType(stream, ++offset, isCidType2);
                    }
                    if (tag != null) {
                        stream = Arrays.copyOfRange(stream, offset, stream.length);
                    }
                }
                if (tag != null) {
                    current.writeCustom(10, new Object[]{restoredFont, stream, tag});
                } else {
                    LogWriter.writeLog("Skipping font " + restoredFont.getBaseFontName() + " due to unrecognised font tag.");
                }
            }
        }
    }

    private static String checkStreamType(byte[] stream, int offset, boolean isCidType2) {
        if (stream.length > offset + 4) {
            String cffString = new String(new byte[]{1, 0, 4}, 0, 3);
            String ttString = new String(new byte[]{0, 1, 0, 0}, 0, 4);
            String tag = new String(stream, offset, 4);
            if (isCidType2 || "true".equalsIgnoreCase(tag) || ttString.equals(tag)) {
                return "ttf";
            }
            if (tag.startsWith(cffString)) {
                return "cff";
            }
            if ("otto".equalsIgnoreCase(tag)) {
                return "otf";
            }
            if ("%!PS".equalsIgnoreCase(tag) || "%!FO".equalsIgnoreCase(tag)) {
                return "t1";
            }
        }
        return null;
    }
}

