/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageNameCollector;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.MarkerGlyph;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.UnrendererGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.ImageDataToJavaImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.downsample.DownSampler;
import org.jpedal.render.ClipUtils;
import org.jpedal.render.GUIDisplay;
import org.jpedal.render.Pointers;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Area;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Shape;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class SwingDisplay
extends GUIDisplay {
    private float lastStrokeOpacity = -1.0f;
    private float lastFillOpacity = -1.0f;
    private boolean noRepaint;
    private int pageX1 = 9999;
    private int pageX2 = -9999;
    private int pageY1 = -9999;
    private int pageY2 = 9999;
    private BufferedImage singleImage;
    private int imageCount;
    private static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private final Map<String, Integer> cachedWidths = new HashMap<String, Integer>(10);
    private final Map<String, Integer> cachedHeights = new HashMap<String, Integer>(10);
    private Map<Object, Object> fonts = new HashMap<Object, Object>(50);
    private final Set<String> fontsUsed = new HashSet<String>(50);
    private PdfGlyphs glyphs;
    private final Map<String, Integer> imageID = new HashMap<String, Integer>(10);
    private final Map<String, double[]> storedImageValues = new HashMap<String, double[]>(10);
    private boolean stopG2setting;
    private float[] x_coord;
    private float[] y_coord;
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Int shapeType;
    private Vector_Shape shapes;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Area clips;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private Vector_Int BMvalues;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeTextCol;
    private int lastStrokeCol;
    private Stroke lastStroke;
    private double[] lastAf = new double[4];
    private int lastTR = 2;
    private int lastFS = -1;
    private int lastLW = -1;
    private boolean resetTextColors = true;
    private boolean fillSet;
    private boolean strokeSet;
    private int paintThreadCount;
    private int paintThreadID;
    private ImageNameCollector imageNameCollector = new ImageNameCollector(){};
    private Rectangle[] objectAreas;

    public SwingDisplay() {
        this.currentItem = 0;
        this.type = 1;
    }

    void setupArrays(int defaultSize) {
        this.x_coord = new float[defaultSize];
        this.y_coord = new float[defaultSize];
        this.text_color = new Vector_Object(defaultSize);
        this.textFillType = new Vector_Int(defaultSize);
        this.stroke_color = new Vector_Object(defaultSize);
        this.fill_color = new Vector_Object(defaultSize);
        this.stroke = new Vector_Object(defaultSize);
        this.pageObjects = new Vector_Object(defaultSize);
        this.javaObjects = new Vector_Object(defaultSize);
        this.shapes = new Vector_Shape(defaultSize);
        this.shapeType = new Vector_Int(defaultSize);
        this.areas = new Vector_Rectangle_Int(defaultSize);
        this.af1 = new Vector_Double(defaultSize);
        this.af2 = new Vector_Double(defaultSize);
        this.af3 = new Vector_Double(defaultSize);
        this.af4 = new Vector_Double(defaultSize);
        this.clips = new Vector_Area(defaultSize);
        this.objectType = new Vector_Int(defaultSize);
        this.opacity = new Vector_Float(defaultSize);
        this.currentItem = 0;
    }

    public SwingDisplay(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
        this.type = 1;
    }

    public SwingDisplay(int pageNumber, ObjectStore newObjectRef, boolean isPrinting) {
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.isPrinting = isPrinting;
        this.setupArrays(5000);
        this.type = 1;
    }

    public void stopG2HintSetting(boolean isSet) {
        this.stopG2setting = isSet;
    }

    private void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        this.objectAreas = null;
        if (this.shapeType != null) {
            this.shapes.clear();
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.javaObjects.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[5000];
            this.y_coord = new float[5000];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues = null;
            }
            if (this.fs != null) {
                this.fs = null;
            }
            if (this.lw != null) {
                this.lw = null;
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            if (this.BMvalues != null) {
                this.BMvalues.clear();
            }
            this.lastStrokeOpacity = -1.0f;
            this.lastFillOpacity = -1.0f;
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeTextCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    @Override
    public void paint(Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot) {
        int currentThreadID = ++this.paintThreadID;
        ++this.paintThreadCount;
        if (this.paintThreadCount > 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
            if (currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return;
            }
        }
        Shape defaultClip = null;
        Rectangle dirtyRegion = null;
        if (this.g2 != null) {
            Shape rawClip = this.g2.getClip();
            if (rawClip != null) {
                dirtyRegion = rawClip.getBounds();
            }
            defaultClip = this.g2.getClip();
        }
        if (this.noRepaint) {
            this.noRepaint = false;
        } else {
            this.paintBackground(dirtyRegion);
        }
        AffineTransform rawScaling = null;
        if (this.g2 != null) {
            rawScaling = this.g2.getTransform();
            if (viewScaling != null) {
                this.g2.transform(viewScaling);
                defaultClip = this.g2.getClip();
            }
        }
        if (!this.stopG2setting && this.g2 != null) {
            if (userHints != null) {
                this.g2.setRenderingHints(userHints);
            } else {
                this.g2.setRenderingHints(hints);
            }
        }
        this.renderPage(userAnnot, defaultClip, dirtyRegion);
        this.itemToRender = -1;
        if (this.g2 != null) {
            this.g2.setClip(defaultClip);
        }
        if (this.g2 != null) {
            this.g2.setTransform(rawScaling);
        }
        --this.paintThreadCount;
        this.lastScaling = this.scaling;
    }

    private void renderPage(Rectangle userAnnot, Shape defaultClip, Rectangle dirtyRegion) {
        float a10 = 0.0f;
        float b2 = 0.0f;
        float c2 = 0.0f;
        float d2 = 0.0f;
        int count = this.currentItem;
        Pointers ptrs = new Pointers();
        RenderData data = new RenderData();
        if (this.colorsLocked) {
            data.strokeCol = this.strokeCol;
            data.fillCol = this.fillCol;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            boolean ignoreItem;
            this.itemToRender = i2;
            int type = data.objectTypes[i2];
            Rectangle currentArea = null;
            if (type < 0) {
                currentArea = this.setupText(a10, b2, c2, d2, type, data, i2);
                type = -type;
            }
            if (type <= 0) continue;
            float x2 = this.x_coord[i2];
            float y2 = this.y_coord[i2];
            if (currentArea == null) {
                currentArea = this.getObjectArea(data, type, x2, y2, ptrs.fsCount, ptrs.afCount, ptrs.sCount, i2);
            }
            boolean bl2 = ignoreItem = currentArea != null && userAnnot != null && type < 7 && SwingDisplay.testIfAnnotVisible(currentArea, userAnnot);
            if (ignoreItem) {
                ptrs.increment(type);
                continue;
            }
            if (type == 200) {
                MarkerGlyph marker = (MarkerGlyph)data.pageObjs[i2];
                String fontUsed = marker.fontName;
                a10 = marker.a;
                b2 = marker.b;
                c2 = marker.c;
                d2 = marker.d;
                this.glyphs = (PdfGlyphs)this.fonts.get(fontUsed);
            } else {
                this.renderContent(data, ptrs, defaultClip, dirtyRegion, i2, x2, y2, type);
            }
            ptrs.increment2(type);
        }
    }

    private void renderContent(RenderData data, Pointers ptrs, Shape defaultClip, Rectangle dirtyRegion, int i2, float x2, float y2, int type) {
        switch (type) {
            case 2: {
                this.paintShape(data.fillType[ptrs.sCount], defaultClip, data.shape[ptrs.sCount], data, i2);
                break;
            }
            case 1: {
                this.paintText(data, (Area)data.pageObjs[i2], x2, y2, ptrs.afCount);
                break;
            }
            case 4: {
                this.paintEmbeddedText(4, data, data.pageObjs[i2], x2, y2, ptrs.afCount);
                break;
            }
            case 5: {
                this.paintEmbeddedText(6, data, data.pageObjs[i2], x2, y2, ptrs.afCount);
                break;
            }
            case 6: {
                this.paintEmbeddedText(5, data, data.pageObjs[i2], x2, y2, ptrs.afCount);
                break;
            }
            case 3: {
                this.renderImage(data, data.pageObjs[i2], x2, y2, ptrs.iCount, ptrs.afCount, i2);
                break;
            }
            case 7: {
                if (this.g2 == null) break;
                RenderUtils.renderClip(data.pageClips[ptrs.cCount], dirtyRegion, defaultClip, this.g2);
                break;
            }
            case 31: {
                this.blendMode = data.BM[ptrs.BMCount];
                break;
            }
            case 16: {
                this.renderStringText(data, ptrs, data.javaObjs[ptrs.stringCount], defaultClip, (String)data.pageObjs[i2], x2, y2);
                break;
            }
            case 23: {
                this.renderCustom(defaultClip, (JPedalCustomDrawObject)data.pageObjs[i2]);
                break;
            }
            default: {
                data.updateValues(type, ptrs);
            }
        }
    }

    private Rectangle setupText(float a10, float b2, float c2, float d2, int type, RenderData data, int i2) {
        Rectangle currentArea = null;
        UnrendererGlyph glyph = (UnrendererGlyph)data.pageObjs[i2];
        float[][] trm = new float[][]{{a10, b2}, {c2, d2}, {glyph.x, glyph.y}};
        Object newGlyph = this.getGlyph(type, glyph, trm);
        if (type == -1) {
            currentArea = RenderUtils.getAreaForGlyph(trm);
        }
        data.objectTypes[i2] = -type;
        data.pageObjs[i2] = newGlyph;
        return currentArea;
    }

    private Object getGlyph(int type, UnrendererGlyph glyph, float[][] trm) {
        int raw = glyph.rawInt;
        Integer key = raw;
        String disp = this.glyphs.getDisplayValue(key);
        String charGlyph = this.glyphs.getCharGlyph(key);
        String emb = this.glyphs.getEmbeddedEnc(key);
        float width = glyph.currentWidth;
        Object newGlyph = type == -1 ? SwingDisplay.getGlyph(glyph, trm, raw, disp, width, this.glyphs) : this.glyphs.getEmbeddedGlyph(charGlyph, trm, raw, disp, width, emb);
        return newGlyph;
    }

    private static Object getGlyph(UnrendererGlyph glyph, float[][] trm, int raw, String disp, float width, PdfGlyphs glyphs) {
        boolean isSTD = DecoderOptions.isRunningOnMac || StandardFonts.isStandardFont(glyphs.getBaseFontName(), false);
        Area transformedGlyph2 = glyphs.getStandardGlyph(trm, raw, disp, width, isSTD);
        AffineTransform at2 = AffineTransform.getTranslateInstance(glyph.x, glyph.y);
        transformedGlyph2.transform(at2);
        Area newGlyph = transformedGlyph2;
        return newGlyph;
    }

    private void renderCustom(Shape defaultClip, JPedalCustomDrawObject currentObject) {
        Shape s2 = this.g2.getClip();
        this.g2.setClip(defaultClip);
        AffineTransform af2 = this.g2.getTransform();
        if (this.isPrinting) {
            currentObject.print(this.g2, this.rawPageNumber);
        } else {
            currentObject.paint(this.g2);
        }
        this.g2.setTransform(af2);
        this.g2.setClip(s2);
    }

    private void renderStringText(RenderData data, Pointers ptrs, Object javaObject, Shape defaultClip, String currentObject, float x2, float y2) {
        int afCount = ptrs.afCount;
        AffineTransform affine1 = new AffineTransform(data.afValues1[afCount], data.afValues2[afCount], data.afValues3[afCount], data.afValues4[afCount], 0.0, 0.0);
        Shape s1 = this.g2.getClip();
        this.g2.setClip(defaultClip);
        AffineTransform defaultAf = this.g2.getTransform();
        double[] af2 = new double[6];
        this.g2.getTransform().getMatrix(af2);
        if (af2[2] != 0.0) {
            af2[2] = -af2[2];
        }
        if (af2[3] != 0.0) {
            af2[3] = -af2[3];
        }
        this.g2.setTransform(new AffineTransform(af2));
        Font javaFont = (Font)javaObject;
        this.g2.setFont(javaFont);
        if ((data.currentTR & 2) == 2) {
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, data.textFillCol, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, data.textFillCol, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(data.textFillCol);
            }
        }
        if ((data.currentTR & 1) == 1) {
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, data.textFillCol, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, data.textFillCol, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(data.textFillCol);
            }
        }
        double scaleFactorX = 1.0 / affine1.getScaleX();
        double scaleFactorY = 1.0 / affine1.getScaleY();
        this.g2.translate(x2, y2);
        if (affine1.getScaleX() == 0.0) {
            scaleFactorX = 1.0 / affine1.getShearX();
        }
        if (affine1.getScaleY() == 0.0) {
            scaleFactorY = 1.0 / affine1.getShearY();
        }
        double scaleFactor = Math.min(scaleFactorX, scaleFactorY);
        affine1.scale(Math.abs(scaleFactor), Math.abs(scaleFactor));
        this.g2.scale(1.0, -1.0);
        this.g2.transform(affine1);
        this.g2.scale(1.0, -1.0);
        this.g2.drawString(currentObject, 0, 0);
        this.g2.setTransform(defaultAf);
        this.g2.setClip(s1);
    }

    private static boolean testIfAnnotVisible(Rectangle currentArea, Rectangle userAnnot) {
        boolean ignoreItem = false;
        Rectangle testRect = currentArea.getBounds();
        if (testRect.width == 0) {
            ++testRect.width;
        }
        if (testRect.height == 0) {
            ++testRect.height;
        }
        if (!userAnnot.intersects(testRect)) {
            ignoreItem = true;
        }
        return ignoreItem;
    }

    private void paintEmbeddedText(int type, RenderData data, Object currentObject, float x2, float y2, int afCount) {
        if (afCount != -1) {
            double[] afValues1 = data.afValues1;
            double[] afValues2 = data.afValues2;
            double[] afValues3 = data.afValues3;
            double[] afValues4 = data.afValues4;
            AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x2, (double)y2);
            Stroke originalStroke = this.g2.getStroke();
            if (data.currentStroke != null) {
                this.g2.setStroke(data.currentStroke);
            }
            this.renderEmbeddedText(data.currentTR, currentObject, type, aff, data.textStrokeCol, data.textFillCol, data.strokeOpacity, data.fillOpacity, data.lwidth);
            this.g2.setStroke(originalStroke);
        }
    }

    private void paintShape(int fillType, Shape defaultClip, Shape currentObject, RenderData data, int i2) {
        Shape s2 = null;
        if (this.endItem != -1 && this.endItem < i2) {
            s2 = this.g2.getClip();
            this.g2.setClip(defaultClip);
        }
        this.renderShape(defaultClip, fillType, data.strokeCol, data.fillCol, data.currentStroke, currentObject, data.strokeOpacity, data.fillOpacity);
        if (this.endItem != -1 && this.endItem < i2) {
            this.g2.setClip(s2);
        }
    }

    private void paintText(RenderData data, Area currentObject, float x2, float y2, int afCount) {
        AffineTransform def = this.g2.getTransform();
        if (afCount != -1) {
            double[] afValues1 = data.afValues1;
            double[] afValues2 = data.afValues2;
            double[] afValues3 = data.afValues3;
            double[] afValues4 = data.afValues4;
            this.g2.transform(new AffineTransform(afValues1[afCount], afValues2[afCount], -afValues3[afCount], -afValues4[afCount], (double)x2, (double)y2));
            this.renderText(data.currentTR, currentObject, data.textStrokeCol, data.textFillCol, data.strokeOpacity, data.fillOpacity);
            this.g2.setTransform(def);
        }
    }

    private Rectangle getObjectArea(RenderData data, int type, float x2, float y2, int fsCount, int afCount, int sCount, int i2) {
        double[] afValues1;
        Rectangle currentArea = null;
        int[][] rectParams = data.areasUsed;
        if (this.objectAreas == null || this.objectAreas.length != rectParams.length) {
            this.objectAreas = new Rectangle[rectParams.length];
            for (int r2 = 0; r2 < this.objectAreas.length; ++r2) {
                if (this.objectAreas[r2] == null) continue;
                this.objectAreas[r2] = new Rectangle(rectParams[r2][0], rectParams[r2][1], rectParams[r2][2], rectParams[r2][3]);
            }
        }
        if ((afValues1 = data.afValues1) != null) {
            double[] afValues2 = data.afValues2;
            double[] afValues3 = data.afValues3;
            double[] afValues4 = data.afValues4;
            if (type == 3) {
                currentArea = this.objectAreas[i2];
            } else if (type == 2) {
                currentArea = this.shapes.get()[sCount].getBounds();
            } else if (type == 1 && afCount > -1) {
                currentArea = RenderUtils.getAreaForGlyph(new float[][]{{(float)afValues1[afCount], (float)afValues2[afCount], 0.0f}, {(float)afValues3[afCount], (float)afValues4[afCount], 0.0f}, {x2, y2, 1.0f}});
            } else if (fsCount != -1) {
                int realSize = data.fsValues[fsCount];
                currentArea = realSize < 0 ? new Rectangle((int)x2 + realSize, (int)y2, -realSize, -realSize) : new Rectangle((int)x2, (int)y2, realSize, realSize);
            }
        }
        return currentArea;
    }

    private void renderImage(RenderData data, Object currentObject, float x2, float y2, int iCount, int afCount, int i2) {
        BufferedImage img;
        String key = Integer.toString(this.rawPageNumber) + iCount;
        if (!this.isType3Font && this.objectStoreRef.isRawImageDataSaved(key)) {
            currentObject = this.getResampledImage(key, data.pageObjs, i2, currentObject);
        }
        if ((img = currentObject != null ? (BufferedImage)currentObject : this.reloadCachedImage(i2)) != null) {
            double[] afValues1 = data.afValues1;
            double[] afValues2 = data.afValues2;
            double[] afValues3 = data.afValues3;
            double[] afValues4 = data.afValues4;
            if (this.isPrinting && img.getTransparency() == 3 && img.getHeight() == 1 && afValues4[afCount] < 1.0) {
                AffineTransform imageAf = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], 1.0, (double)x2, (double)y2);
                this.renderImage(imageAf, img, data.fillOpacity, null, x2, y2);
            } else {
                AffineTransform imageAf = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x2, (double)y2);
                this.renderImage(imageAf, img, data.fillOpacity, null, x2, y2);
            }
        }
    }

    private Object getResampledImage(String key, Object[] pageObjects1, int i2, Object currentObject) {
        int sampling = 1;
        float scalingToUse = this.scaling;
        if (this.scaling < 1.0f) {
            scalingToUse = 1.0f;
        }
        int defaultX = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_pX);
        int pX = (int)((float)defaultX * scalingToUse);
        int defaultY = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_pY);
        int pY = (int)((float)defaultY * scalingToUse);
        int w1 = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_WIDTH);
        int h1 = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_HEIGHT);
        int bpc = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_DEPTH);
        byte[] maskCol = (byte[])this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_MASKCOL);
        BufferedImage image = null;
        if (pX > 0) {
            int scaleY;
            int newW = w1;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (int newH = h1; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w1 / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h1 / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
            int defnewW = w1;
            int defsmallestH = pY << 2;
            int defsmallestW = pX << 2;
            for (int defnewH = h1; defnewW > defsmallestW && defnewH > defsmallestH; defnewW >>= 1, defnewH >>= 1) {
            }
            if ((this.scaling > 1.0f || this.lastScaling > 1.0f) && this.lastScaling != this.scaling) {
                try {
                    image = this.resampleImageData(sampling, w1, h1, bpc, maskCol, key);
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception rescaling image: " + e2.getMessage());
                }
            }
        }
        if (image != null) {
            if (this.singleImage != null && currentObject == null) {
                this.singleImage = image;
            }
            pageObjects1[i2] = image;
            currentObject = image;
        }
        return currentObject;
    }

    private BufferedImage resampleImageData(int sampling, int w1, int h1, int bpc, byte[] maskCol, String key) {
        byte[] data = this.objectStoreRef.getRawImageData(key);
        int comps = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_COMPONENT_COUNT);
        ImageData imageData = new ImageData(data);
        imageData.setWidth(w1);
        imageData.setHeight(h1);
        imageData.setCompCount(comps);
        imageData.setDepth(bpc);
        GenericColorSpace decodeColorData = new DeviceRGBColorSpace(comps == 4);
        if (sampling > 1) {
            decodeColorData = DownSampler.downSampleImage(decodeColorData, imageData, maskCol, sampling);
        }
        BufferedImage image = maskCol != null ? ImageDataToJavaImage.makeMaskImage(new ParserOptions(), null, null, imageData, decodeColorData, maskCol) : ImageDataToJavaImage.makeImage(decodeColorData, imageData);
        return image;
    }

    private BufferedImage reloadCachedImage(int i2) {
        BufferedImage img = null;
        BufferedImage currentObject = null;
        try {
            if (this.singleImage != null) {
                currentObject = this.singleImage.getSubimage(0, 0, this.singleImage.getWidth(), this.singleImage.getHeight());
            }
            if (currentObject == null) {
                currentObject = this.rawKey == null ? this.objectStoreRef.loadStoredImage(this.rawPageNumber + "_HIRES_" + i2) : this.objectStoreRef.loadStoredImage(this.rawPageNumber + "_HIRES_" + i2 + '_' + this.rawKey);
            }
            img = currentObject;
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return img;
    }

    @Override
    public void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x2, float y2, Font javaFont) {
        PdfPaint currentCol;
        int text_fill_type;
        if (Trm != null) {
            double[] nextAf;
            if (Matrix.hasShears(Trm)) {
                float a10 = Math.abs(Trm[0][0]);
                float b2 = Math.abs(Trm[1][1]);
                if ((double)a10 < 0.2 && (double)b2 < 0.2) {
                    Trm[0][0] = 0.0f;
                    Trm[1][1] = 0.0f;
                }
            }
            if (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3]) {
                this.drawAffine(nextAf);
                this.lastAf[0] = nextAf[0];
                this.lastAf[1] = nextAf[1];
                this.lastAf[2] = nextAf[2];
                this.lastAf[3] = nextAf[3];
            }
        }
        if (((text_fill_type = currentGraphicsState.getTextRenderType()) & 2) == 2) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                int newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                int newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeTextCol != newCol) {
                    this.lastStrokeTextCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        this.pageObjects.addElement(text);
        this.javaObjects.addElement(javaFont);
        this.objectType.addElement(16);
        int fontSize = javaFont.getSize();
        int[] rectParams = new int[]{(int)x2, (int)y2, fontSize, fontSize};
        if (fontSize > 100) {
            this.areas.addElement(rectParams);
        } else {
            this.areas.addElement(null);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x2;
        this.y_coord[this.currentItem] = y2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int previousUse) {
        int h2;
        int w2;
        this.rawPageNumber = pageNumber;
        float[][] CTM = currentGraphicsState.CTM;
        float x2 = currentGraphicsState.x;
        float y2 = currentGraphicsState.y;
        double[] nextAf = new double[6];
        boolean cacheInMemory = (image.getWidth() < 100 && image.getHeight() < 100 || image.getHeight() == 1) && !this.imageNameCollector.cacheAllToDisk();
        String key = this.rawKey == null ? pageNumber + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        AffineTransform upside_down = Matrix.toAffine(CTM);
        upside_down.getMatrix(nextAf);
        this.drawAffine(nextAf);
        this.lastAf[0] = nextAf[0];
        this.lastAf[1] = nextAf[1];
        this.lastAf[2] = nextAf[2];
        this.lastAf[3] = nextAf[3];
        if (!alreadyCached || this.cachedWidths.get(key) == null) {
            w2 = image.getWidth();
            h2 = image.getHeight();
        } else {
            w2 = this.cachedWidths.get(key);
            h2 = this.cachedHeights.get(key);
        }
        if (!alreadyCached && !cacheInMemory) {
            this.cacheImageToDisk(image, name, pageNumber, w2, h2);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x2;
        this.y_coord[this.currentItem] = y2;
        this.objectType.addElement(3);
        if (CTM[0][0] > 0.0f && (double)CTM[0][0] < 0.05 && CTM[0][1] != 0.0f && CTM[1][0] != 0.0f && CTM[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            int[] rectParams = SwingDisplay.getImageRectParams(CTM, currentGraphicsState);
            this.areas.addElement(rectParams);
            this.checkWidth(rectParams);
        }
        if (!cacheInMemory) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(image);
        }
        this.imageID.put(name, this.currentItem);
        this.storedImageValues.put("imageAff-" + this.currentItem, nextAf);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private static int[] getImageRectParams(float[][] CTM, GraphicsState currentGraphicsState) {
        int h2;
        int w2 = (int)CTM[0][0];
        if (w2 == 0) {
            w2 = (int)CTM[0][1];
        }
        if ((h2 = (int)CTM[1][1]) == 0) {
            h2 = (int)CTM[1][0];
        }
        int x1 = (int)currentGraphicsState.x;
        int y1 = (int)currentGraphicsState.y;
        int w1 = w2;
        int h1 = h2;
        if (h1 < 0) {
            y1 += h1;
            h1 = -h1;
        }
        if (h1 == 0) {
            h1 = 1;
        }
        return new int[]{x1, y1, w1, h1};
    }

    private void cacheImageToDisk(BufferedImage image, String name, int pageNumber, int w2, int h2) {
        String key;
        String cachedImageName;
        if (!this.isPrinting) {
            if (this.imageCount == 0) {
                this.singleImage = image.getSubimage(0, 0, image.getWidth(), image.getHeight());
                ++this.imageCount;
            } else {
                this.singleImage = null;
            }
        }
        if (this.rawKey == null) {
            cachedImageName = pageNumber + "_HIRES_" + this.currentItem;
            key = pageNumber + "_" + this.currentItem;
        } else {
            cachedImageName = pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey;
            key = this.rawKey + '_' + this.currentItem;
        }
        this.objectStoreRef.saveStoredImageAsBytes(cachedImageName, image, false);
        this.imageIDtoName.put(this.currentItem, cachedImageName);
        this.cachedWidths.put(key, w2);
        this.cachedHeights.put(key, h2);
        this.imageNameCollector.put(name, cachedImageName);
    }

    private void checkWidth(int[] rect) {
        int x1 = rect[0];
        int y2 = rect[1];
        int y1 = y2 + rect[3];
        int x2 = x1 + rect[2];
        if (x1 < this.pageX1) {
            this.pageX1 = x1;
        }
        if (x2 > this.pageX2) {
            this.pageX2 = x2;
        }
        if (y1 > this.pageY1) {
            this.pageY1 = y1;
        }
        if (y2 < this.pageY2) {
            this.pageY2 = y2;
        }
    }

    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageX1, this.pageY1 - this.pageY2);
    }

    @Override
    public void drawShape(PdfShape pdfShape, GraphicsState currentGraphicsState, int cmd) {
        Stroke newStroke;
        int newCol;
        PdfPaint currentCol;
        Shape currentShape = pdfShape.getShape();
        int fillType = currentGraphicsState.getFillType();
        if (fillType == 2 || fillType == 3) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol == null) {
                currentCol = new PdfColor(0, 0, 0);
            }
            if (currentCol.isPattern()) {
                this.drawFillColor(currentCol);
                this.fillSet = true;
            } else {
                newCol = currentCol.getRGB();
                if (!this.fillSet || this.lastFillCol != newCol) {
                    this.lastFillCol = newCol;
                    this.drawFillColor(currentCol);
                    this.fillSet = true;
                }
            }
        }
        if (fillType == 1 || fillType == 3) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol instanceof Color) {
                newCol = currentCol.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawStrokeColor(currentCol);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(currentCol);
                this.strokeSet = true;
            }
        }
        if (!(newStroke = currentGraphicsState.getStroke()).equals(this.lastStroke)) {
            this.lastStroke = newStroke;
            this.drawStroke(newStroke);
        }
        this.pageObjects.addElement(null);
        this.objectType.addElement(2);
        int[] shapeParams = new int[]{currentShape.getBounds().x, currentShape.getBounds().y, currentShape.getBounds().width, currentShape.getBounds().height};
        this.areas.addElement(shapeParams);
        this.checkWidth(shapeParams);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = currentGraphicsState.x;
        this.y_coord[this.currentItem] = currentGraphicsState.y;
        this.shapeType.addElement(fillType);
        this.shapes.addElement(currentShape);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    private void drawColor(PdfPaint currentCol, int type) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(type);
        this.text_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    @Override
    public synchronized void writeCustom(int section, Object str) {
        switch (section) {
            case 18: {
                this.fillSet = false;
                this.strokeSet = false;
                break;
            }
            case 42: {
                this.flushAdditionalObjOnPage();
                break;
            }
            case 43: {
                this.flush();
                break;
            }
            default: {
                super.writeCustom(section, str);
            }
        }
    }

    private void drawFillColor(PdfPaint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = currentCol.getRGB();
    }

    @Override
    public void setGraphicsState(int fillType, float value, int BM) {
        if (BM != 1111314299 || this.BMvalues != null) {
            if (this.BMvalues == null) {
                this.BMvalues = new Vector_Int(5000);
                this.BMvalues.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            this.objectType.addElement(31);
            this.BMvalues.addElement(BM);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
        if (fillType == 1) {
            if (this.lastFillOpacity == value) {
                return;
            }
            this.lastFillOpacity = value;
        }
        if (fillType == 2) {
            if (this.lastStrokeOpacity == value) {
                return;
            }
            this.lastStrokeOpacity = value;
        }
        if (value != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(5000);
                this.opacity.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            if (fillType == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(value);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (obj == null) {
            return;
        }
        if (this.endItem == -1) {
            this.endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapes.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
            }
            this.TRvalues.setCheckpoint();
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
            }
            this.fs.setCheckpoint();
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
            }
            this.lw.setCheckpoint();
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
            if (this.BMvalues != null) {
                this.BMvalues.setCheckpoint();
            }
        }
        this.drawUserContent(type, obj, colors);
    }

    public void flushAdditionalObjOnPage() {
        if (this.endItem != -1) {
            this.currentItem = this.endItem;
        }
        this.endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapes.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        if (this.BMvalues != null) {
            this.BMvalues.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeTextCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
    }

    private void drawStrokeColor(Paint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    @Override
    public void drawCustom(Object value) {
        this.pageObjects.addElement(value);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawTR(int value) {
        if (value != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
                this.TRvalues.setCheckpoint();
            }
            this.lastTR = value;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(value);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    private void drawStroke(Stroke current) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(current);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean canBeCached) {
        boolean resetClip = false;
        Area clip = currentGraphicsState.getClippingShape();
        if (!canBeCached || !this.hasClips || this.lastClip != null || clip != null) {
            if (!canBeCached || this.lastClip == null || clip == null) {
                resetClip = true;
            } else {
                Rectangle bounds = clip.getBounds();
                Rectangle oldBounds = this.lastClip.getBounds();
                if (bounds.x != oldBounds.x || bounds.y != oldBounds.y || bounds.width != oldBounds.width || bounds.height != oldBounds.height) {
                    resetClip = true;
                }
            }
        }
        if (resetClip) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = clip;
            if (clip == null) {
                this.clips.addElement(null);
            } else if (this.useSoftclipForShapes) {
                if (clip.isSingular() && clip.isRectangular()) {
                    this.clips.addElement(ClipUtils.convertPDFClipToJavaClip(clip));
                } else {
                    this.clips.addElement(clip);
                }
            } else if (clip.isSingular() && clip.isRectangular()) {
                this.clips.addElement(ClipUtils.convertPDFClipToJavaClip(clip));
            } else {
                PathIterator it = clip.getPathIterator(null);
                int count = 0;
                while (!it.isDone()) {
                    ++count;
                    it.next();
                }
                if (clip.getBounds2D().getHeight() > 0.5 && count < 700) {
                    Area a10 = (Area)clip.clone();
                    BasicStroke stroke = new BasicStroke(0.5f, 2, 0, 10.0f);
                    Area strokeShape = new Area(stroke.createStrokedShape(a10));
                    a10.add(strokeShape);
                    this.clips.addElement(a10);
                } else {
                    this.clips.addElement(clip);
                }
            }
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = currentGraphicsState.x;
            this.y_coord[this.currentItem] = currentGraphicsState.y;
            ++this.currentItem;
            this.hasClips = true;
        }
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, double[] at2, String glyf, PdfFont currentFontData, float glyfWidth) {
        if (Trm == null) {
            return;
        }
        int text_fill_type = gs.getTextRenderType();
        if ((text_fill_type & 2) == 2) {
            this.fillEmbeddedText(gs);
        }
        if ((text_fill_type & 1) == 1) {
            this.strokeEmbeddedText(gs);
        }
        this.setLineWidth((int)gs.getLineWidth());
        this.drawFontSize(fontSize);
        if (javaGlyph != null) {
            this.handleJavaGlyph(Trm, fontSize, javaGlyph, type);
        } else {
            this.handleGlyph(Trm, fontSize, embeddedGlyph, type, at2);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = Trm[2][0];
        this.y_coord[this.currentItem] = Trm[2][1];
        ++this.currentItem;
    }

    private void fillEmbeddedText(GraphicsState gs) {
        PdfPaint currentCol = gs.getNonstrokeColor();
        if (currentCol.isPattern()) {
            this.drawColor(currentCol, 2);
            this.resetTextColors = true;
        } else {
            int newCol = currentCol.getRGB();
            if (this.resetTextColors || this.lastFillTextCol != newCol) {
                this.lastFillTextCol = newCol;
                this.drawColor(currentCol, 2);
                this.resetTextColors = false;
            }
        }
    }

    private void strokeEmbeddedText(GraphicsState gs) {
        PdfPaint currentCol = gs.getStrokeColor();
        Stroke newStroke = gs.getStroke();
        if (!newStroke.equals(this.lastStroke)) {
            this.lastStroke = newStroke;
            this.drawStroke(newStroke);
        }
        if (currentCol.isPattern()) {
            this.drawColor(currentCol, 1);
            this.resetTextColors = true;
        } else {
            int newCol = currentCol.getRGB();
            if (this.resetTextColors || this.lastStrokeTextCol != newCol) {
                this.resetTextColors = false;
                this.lastStrokeTextCol = newCol;
                this.drawColor(currentCol, 1);
            }
        }
    }

    private void handleJavaGlyph(float[][] Trm, int fontSize, Object javaGlyph, int type) {
        double[] nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]};
        if (this.lastAf[0] != nextAf[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3]) {
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
        }
        if (!(javaGlyph instanceof Area)) {
            type = -type;
        }
        this.pageObjects.addElement(javaGlyph);
        this.objectType.addElement(type);
        if (type < 0) {
            this.areas.addElement(null);
        } else {
            int[] rectParams = new int[]{(int)Trm[2][0], (int)Trm[2][1], fontSize, fontSize};
            this.areas.addElement(rectParams);
            this.checkWidth(rectParams);
        }
    }

    private void handleGlyph(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, int type, double[] at2) {
        if (this.lastAf[0] != at2[0] || this.lastAf[1] != at2[1] || this.lastAf[2] != at2[2] || this.lastAf[3] != at2[3]) {
            this.drawAffine(at2);
            this.lastAf[0] = at2[0];
            this.lastAf[1] = at2[1];
            this.lastAf[2] = at2[2];
            this.lastAf[3] = at2[3];
        }
        this.pageObjects.addElement(embeddedGlyph);
        this.objectType.addElement(type);
        if (type < 0) {
            this.areas.addElement(null);
        } else {
            int realSize = fontSize;
            if (realSize < 0) {
                realSize = -realSize;
            }
            int[] area = new int[]{(int)Trm[2][0], (int)Trm[2][1], realSize, realSize};
            this.areas.addElement(area);
            this.checkWidth(area);
        }
    }

    @Override
    void drawAffine(double[] afValues) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(afValues[0]);
        this.af2.addElement(afValues[1]);
        this.af3.addElement(afValues[2]);
        this.af4.addElement(afValues[3]);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)afValues[4];
        this.y_coord[this.currentItem] = (float)afValues[5];
        ++this.currentItem;
    }

    private void drawFontSize(int fontSize) {
        int realSize = fontSize;
        if (realSize < 0) {
            realSize = -realSize;
        }
        if (realSize != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
                this.fs.setCheckpoint();
            }
            this.fs.addElement(fontSize);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = realSize;
        }
    }

    private void setLineWidth(int lineWidth) {
        if (lineWidth != this.lastLW) {
            this.areas.addElement(null);
            this.pageObjects.addElement(null);
            this.objectType.addElement(22);
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
                this.lw.setCheckpoint();
            }
            this.lw.addElement(lineWidth);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastLW = lineWidth;
        }
    }

    public SwingDisplay(byte[] stream, Map<Object, Object> fonts) {
        try {
            this.fonts = fonts;
            ByteArrayInputStream bis = new ByteArrayInputStream(stream);
            int version = bis.read();
            if (version != 1) {
                throw new PdfException("Unknown version in serialised object " + version);
            }
            bis.read();
            this.rawPageNumber = bis.read();
            this.x_coord = (float[])RenderUtils.restoreFromStream(bis);
            this.y_coord = (float[])RenderUtils.restoreFromStream(bis);
            this.text_color = (Vector_Object)RenderUtils.restoreFromStream(bis);
            this.textFillType = (Vector_Int)RenderUtils.restoreFromStream(bis);
            this.stroke_color = new Vector_Object();
            this.stroke_color.restoreFromStream(bis);
            this.fill_color = new Vector_Object();
            this.fill_color.restoreFromStream(bis);
            this.stroke = new Vector_Object();
            this.stroke.restoreFromStream(bis);
            this.pageObjects = new Vector_Object();
            this.pageObjects.restoreFromStream(bis);
            this.javaObjects = (Vector_Object)RenderUtils.restoreFromStream(bis);
            this.shapes = (Vector_Shape)RenderUtils.restoreFromStream(bis);
            this.shapeType = (Vector_Int)RenderUtils.restoreFromStream(bis);
            this.af1 = (Vector_Double)RenderUtils.restoreFromStream(bis);
            this.af2 = (Vector_Double)RenderUtils.restoreFromStream(bis);
            this.af3 = (Vector_Double)RenderUtils.restoreFromStream(bis);
            this.af4 = (Vector_Double)RenderUtils.restoreFromStream(bis);
            this.clips = new Vector_Area();
            this.clips.restoreFromStream(bis);
            this.objectType = (Vector_Int)RenderUtils.restoreFromStream(bis);
            this.opacity = (Vector_Float)RenderUtils.restoreFromStream(bis);
            this.BMvalues = (Vector_Int)RenderUtils.restoreFromStream(bis);
            this.TRvalues = (Vector_Int)RenderUtils.restoreFromStream(bis);
            this.fs = (Vector_Int)RenderUtils.restoreFromStream(bis);
            this.lw = (Vector_Int)RenderUtils.restoreFromStream(bis);
            int fontCount = (Integer)RenderUtils.restoreFromStream(bis);
            for (int ii = 0; ii < fontCount; ++ii) {
                Object key = RenderUtils.restoreFromStream(bis);
                Object glyphs = RenderUtils.restoreFromStream(bis);
                fonts.put(key, glyphs);
            }
            int alteredFontCount = (Integer)RenderUtils.restoreFromStream(bis);
            for (int ii = 0; ii < alteredFontCount; ++ii) {
                Object key = RenderUtils.restoreFromStream(bis);
                PdfJavaGlyphs updatedFont = (PdfJavaGlyphs)fonts.get(key);
                updatedFont.setDisplayValues((Map)RenderUtils.restoreFromStream(bis));
                updatedFont.setCharGlyphs((Map)RenderUtils.restoreFromStream(bis));
                updatedFont.setEmbeddedEncs((Map)RenderUtils.restoreFromStream(bis));
            }
            bis.close();
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        this.type = 1;
        this.currentItem = this.pageObjects.get().length;
    }

    public void stopClearOnNextRepaint(boolean flag) {
        this.noRepaint = flag;
    }

    @Override
    public byte[] serializeToByteArray(Set<String> fontsAlreadyOnClient) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(1);
        bos.write(1);
        bos.write(this.rawPageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.shapes.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.BMvalues != null) {
            this.BMvalues.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        RenderUtils.writeToStream(bos, this.x_coord);
        RenderUtils.writeToStream(bos, this.y_coord);
        RenderUtils.writeToStream(bos, this.text_color);
        RenderUtils.writeToStream(bos, this.textFillType);
        this.stroke_color.writeToStream(bos);
        this.fill_color.writeToStream(bos);
        this.stroke.writeToStream(bos);
        this.pageObjects.writeToStream(bos);
        RenderUtils.writeToStream(bos, this.javaObjects);
        RenderUtils.writeToStream(bos, this.shapes);
        RenderUtils.writeToStream(bos, this.shapeType);
        RenderUtils.writeToStream(bos, this.af1);
        RenderUtils.writeToStream(bos, this.af2);
        RenderUtils.writeToStream(bos, this.af3);
        RenderUtils.writeToStream(bos, this.af4);
        this.clips.writeToStream(bos);
        RenderUtils.writeToStream(bos, this.objectType);
        RenderUtils.writeToStream(bos, this.opacity);
        RenderUtils.writeToStream(bos, this.BMvalues);
        RenderUtils.writeToStream(bos, this.TRvalues);
        RenderUtils.writeToStream(bos, this.fs);
        RenderUtils.writeToStream(bos, this.lw);
        int fontCount = 0;
        int updateCount = 0;
        HashSet<String> fontsAlreadySent = new HashSet<String>(10);
        HashSet<String> newFontsToSend = new HashSet<String>(10);
        for (String fontUsed : this.fontsUsed) {
            if (!fontsAlreadyOnClient.contains(fontUsed)) {
                ++fontCount;
                newFontsToSend.add(fontUsed);
                continue;
            }
            ++updateCount;
            fontsAlreadySent.add(fontUsed);
        }
        RenderUtils.writeToStream(bos, fontCount);
        for (String key : newFontsToSend) {
            RenderUtils.writeToStream(bos, key);
            RenderUtils.writeToStream(bos, this.fonts.get(key));
            fontsAlreadyOnClient.add(key);
        }
        RenderUtils.writeToStream(bos, updateCount);
        for (String key : fontsAlreadySent) {
            RenderUtils.writeToStream(bos, key);
            PdfJavaGlyphs aa2 = (PdfJavaGlyphs)this.fonts.get(key);
            RenderUtils.writeToStream(bos, aa2.getDisplayValues());
            RenderUtils.writeToStream(bos, aa2.getCharGlyphs());
            RenderUtils.writeToStream(bos, aa2.getEmbeddedEncs());
        }
        bos.close();
        this.fontsUsed.clear();
        return bos.toByteArray();
    }

    public void checkFontSaved(Object glyph, String name, PdfFont currentFontData) {
        this.pageObjects.addElement(glyph);
        this.objectType.addElement(200);
        this.areas.addElement(null);
        ++this.currentItem;
        if (this.fontsUsed.contains(name) || currentFontData.isFontSubsetted()) {
            this.fonts.put(name, currentFontData.getGlyphData());
            this.fontsUsed.add(name);
        }
    }

    public void setPrintPage(int currentPrintPage) {
        this.rawPageNumber = currentPrintPage;
    }

    @Override
    public void setImageNameCollector(ImageNameCollector imageNameCollector) {
        this.imageNameCollector = imageNameCollector;
    }

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    class RenderData {
        final int[] objectTypes;
        final int[] textFill;
        final Area[] pageClips;
        final double[] afValues1;
        int[] fsValues;
        int[] lwValues;
        final double[] afValues2;
        final double[] afValues3;
        final double[] afValues4;
        final Object[] textCols;
        final Object[] fillCols;
        final Object[] strokeCols;
        final Object[] pageObjs;
        final Object[] javaObjs;
        final Object[] strokes;
        final int[] fillType;
        final Shape[] shape;
        float[] alpha;
        int[] BM;
        int[] TR;
        int[][] areasUsed;
        float fillOpacity = 1.0f;
        float strokeOpacity = 1.0f;
        PdfPaint textStrokeCol;
        PdfPaint textFillCol;
        PdfPaint fillCol;
        PdfPaint strokeCol;
        Stroke currentStroke;
        int TFill;
        int currentTR = 2;
        int lwidth;

        RenderData() {
            this.objectTypes = SwingDisplay.this.objectType.get();
            this.textFill = SwingDisplay.this.textFillType.get();
            this.pageClips = SwingDisplay.this.clips.get();
            this.afValues1 = SwingDisplay.this.af1.get();
            if (SwingDisplay.this.fs != null) {
                this.fsValues = SwingDisplay.this.fs.get();
            }
            if (SwingDisplay.this.lw != null) {
                this.lwValues = SwingDisplay.this.lw.get();
            }
            this.afValues2 = SwingDisplay.this.af2.get();
            this.afValues3 = SwingDisplay.this.af3.get();
            this.afValues4 = SwingDisplay.this.af4.get();
            this.textCols = SwingDisplay.this.text_color.get();
            this.fillCols = SwingDisplay.this.fill_color.get();
            this.strokeCols = SwingDisplay.this.stroke_color.get();
            this.pageObjs = SwingDisplay.this.pageObjects.get();
            this.javaObjs = SwingDisplay.this.javaObjects.get();
            this.strokes = SwingDisplay.this.stroke.get();
            this.fillType = SwingDisplay.this.shapeType.get();
            this.shape = SwingDisplay.this.shapes.get();
            if (SwingDisplay.this.opacity != null) {
                this.alpha = SwingDisplay.this.opacity.get();
            }
            if (SwingDisplay.this.BMvalues != null) {
                this.BM = SwingDisplay.this.BMvalues.get();
            }
            if (SwingDisplay.this.TRvalues != null) {
                this.TR = SwingDisplay.this.TRvalues.get();
            }
            if (SwingDisplay.this.areas != null) {
                this.areasUsed = SwingDisplay.this.areas.get();
            }
        }

        void updateValues(int type, Pointers ptrs) {
            switch (type) {
                case 17: {
                    this.strokeOpacity = this.alpha[ptrs.opCount];
                    break;
                }
                case 18: {
                    this.fillOpacity = this.alpha[ptrs.opCount];
                    break;
                }
                case 14: {
                    this.currentStroke = (Stroke)this.strokes[ptrs.stCount];
                    break;
                }
                case 10: {
                    this.TFill = this.textFill[ptrs.tCount];
                    if (this.TFill == 1) {
                        this.textStrokeCol = (PdfPaint)this.textCols[ptrs.tCount];
                        break;
                    }
                    this.textFillCol = (PdfPaint)this.textCols[ptrs.tCount];
                    break;
                }
                case 11: {
                    if (SwingDisplay.this.colorsLocked) break;
                    this.fillCol = (PdfPaint)this.fillCols[ptrs.fillCount];
                    break;
                }
                case 12: {
                    if (SwingDisplay.this.colorsLocked) break;
                    this.strokeCol = (PdfPaint)this.strokeCols[ptrs.strokeCount];
                    break;
                }
                case 15: {
                    this.currentTR = this.TR[ptrs.trCount];
                    break;
                }
                case 22: {
                    this.lwidth = this.lwValues[ptrs.lwCount];
                }
            }
        }
    }
}

