/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import com.idrsolutions.image.JDeli;
import java.awt.Color;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.SwingShape;
import org.jpedal.render.G2Display;
import org.jpedal.render.ImageObject;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;

public abstract class GUIDisplay
extends G2Display {
    private boolean needsHorizontalInvert;
    private boolean needsVerticalInvert;

    public void saveImage(int id2, String des, String type) {
        String name = (String)this.imageIDtoName.get(id2);
        BufferedImage image = this.objectStoreRef.loadStoredImage(name);
        if (image == null) {
            image = (BufferedImage)this.pageObjects.elementAt(id2);
        }
        if (image != null) {
            if (image.getType() == 0 || "jpg".equals(type) && image.getType() == 2) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
            if (this.needsHorizontalInvert) {
                image = RenderUtils.invertImageBeforeSave(image, true);
            }
            if (this.needsVerticalInvert) {
                image = RenderUtils.invertImageBeforeSave(image, false);
            }
            try {
                JDeli.write(image, type, new File(des));
            }
            catch (Exception ex) {
                LogWriter.writeLog("Exception in writing image " + ex);
            }
        }
    }

    public void setneedsVerticalInvert(boolean b2) {
        this.needsVerticalInvert = b2;
    }

    public void setneedsHorizontalInvert(boolean b2) {
        this.needsHorizontalInvert = b2;
    }

    public int getObjectUnderneath(int x2, int y2) {
        int typeFound = -1;
        int[][] areas = this.areas.get();
        int count = areas.length;
        if (this.objectType != null) {
            int[] types = this.objectType.get();
            boolean nothing = true;
            for (int i2 = count - 1; i2 > -1; --i2) {
                if (areas[i2] == null || !RenderUtils.rectangleContains(areas[i2], x2, y2) || types[i2] == 2 || types[i2] == 7) continue;
                nothing = false;
                typeFound = types[i2];
                i2 = -1;
            }
            if (nothing) {
                return -1;
            }
        }
        return typeFound;
    }

    public int[] getAreaAsArray(int i2) {
        return this.areas.elementAt(i2);
    }

    public int isInsideImage(int x2, int y2) {
        int outLine = -1;
        int[][] areas = this.areas.get();
        int[] possArea = null;
        int count = areas.length;
        if (this.objectType != null) {
            int[] types = this.objectType.get();
            for (int i2 = 0; i2 < count; ++i2) {
                if (areas[i2] == null || !RenderUtils.rectangleContains(areas[i2], x2, y2) || types[i2] != 3) continue;
                if (possArea != null) {
                    int area2 = areas[i2][3] * areas[i2][2];
                    void area1 = possArea[3] * possArea[2];
                    if (area2 < area1) {
                        possArea = areas[i2];
                    }
                } else {
                    possArea = areas[i2];
                }
                outLine = i2;
            }
        }
        return outLine;
    }

    void drawUserContent(int[] type1, Object[] obj, Color[] colors) throws PdfException {
        int count = type1.length;
        block10: for (int i2 = 0; i2 < count; ++i2) {
            int currentType = type1[i2];
            switch (currentType) {
                case 18: {
                    this.setGraphicsState(2, ((Number)obj[i2]).floatValue(), 1111314299);
                    continue block10;
                }
                case 17: {
                    this.setGraphicsState(1, ((Number)obj[i2]).floatValue(), 1111314299);
                    continue block10;
                }
                case 19: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(1);
                    gs.strokeColorSpace.setColor(new PdfColor(colors[i2].getRed(), colors[i2].getGreen(), colors[i2].getBlue()));
                    this.drawShape(new SwingShape((Shape)obj[i2]), gs, 83);
                    continue block10;
                }
                case 20: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(2);
                    gs.nonstrokeColorSpace.setColor(new PdfColor(colors[i2].getRed(), colors[i2].getGreen(), colors[i2].getBlue()));
                    this.drawShape(new SwingShape((Shape)obj[i2]), gs, 70);
                    continue block10;
                }
                case 23: {
                    this.drawCustom(obj[i2]);
                    continue block10;
                }
                case 3: {
                    ImageObject imgObj = (ImageObject)obj[i2];
                    GraphicsState gs = new GraphicsState();
                    gs.CTM = new float[][]{{imgObj.image.getWidth(), 0.0f, 0.0f}, {0.0f, imgObj.image.getHeight(), 0.0f}, {0.0f, 0.0f, 1.0f}};
                    gs.x = imgObj.x;
                    gs.y = imgObj.y;
                    if (imgObj.renderer == null) {
                        this.drawImage(this.rawPageNumber, imgObj.image, gs, false, "extImg" + i2, -1);
                        continue block10;
                    }
                    imgObj.renderer.paint(imgObj.image, this.g2, gs);
                    continue block10;
                }
                case 16: {
                    TextObject textObj = (TextObject)obj[i2];
                    GraphicsState gs = new GraphicsState();
                    float fontSize = textObj.font.getSize();
                    double[] afValues = new double[]{fontSize, 0.0, 0.0, fontSize, 0.0, 0.0};
                    this.drawAffine(afValues);
                    this.drawTR(2);
                    gs.setTextRenderType(2);
                    gs.nonstrokeColorSpace.setColor(new PdfColor(colors[i2].getRed(), colors[i2].getGreen(), colors[i2].getBlue()));
                    this.drawText(null, textObj.text, gs, textObj.x, -textObj.y, textObj.font);
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    throw new PdfException("Unrecognised type " + currentType);
                }
            }
        }
    }

    void drawCustom(Object value) {
        throw new UnsupportedOperationException("drawCustom base method in GUI data should not be called " + value);
    }

    void drawAffine(double[] afValues) {
        throw new UnsupportedOperationException("drawAffine only supported in Swing Viewer " + Arrays.toString(afValues));
    }
}

