/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.GlyphTracker;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.MarkerGlyph;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.UnrendererGlyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.CommandWindow;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FallbackFont;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.CIDTextUtils;
import org.jpedal.parser.text.CharReader;
import org.jpedal.parser.text.EscapedTextUtils;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.HexTextUtils;
import org.jpedal.parser.text.JavaTextRenderer;
import org.jpedal.parser.text.Leading;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class Tj
extends BaseDecoder {
    public static boolean showInvisibleText;
    private PdfData pdfData;
    private PdfFont currentFontData;
    private final Vector_Rectangle_Int textAreas;
    private final Vector_Int textDirections;
    private final Vector_Rectangle_Int urlAreas;
    private final Vector_String urlText;
    private TextState currentTextState = new TextState();
    private final GlyphData glyphData = new GlyphData();
    private GlyphTracker customGlyphTracker;
    private boolean ttHintingRequired;
    private String tjTextValue = "";
    private static final String[] hex;
    private float charSpacing;
    private PdfJavaGlyphs glyphs;
    private float[][] Trm;
    private boolean returnText;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float lastWidth;
    private float currentWidth;
    private String actualText;
    private final DynamicVectorRenderer current;
    private int streamLength;
    private float[][] TrmBeforeSpace = new float[3][3];
    private boolean isTabRemapped;
    private boolean isCRRemapped;
    private boolean isReturnRemapped;
    private final ErrorTracker errorTracker;
    public static CommandWindow commandWindow;

    public Tj(ParserOptions parserOptions, PdfData pdfData, boolean isXMLExtraction, Vector_Rectangle_Int textAreas, Vector_Int textDirections, Vector_Rectangle_Int urlAreas, Vector_String urlText, DynamicVectorRenderer current, ErrorTracker errorTracker) {
        this.parserOptions = parserOptions;
        this.pdfData = pdfData;
        this.glyphData.setXMLExtraction(isXMLExtraction);
        this.textAreas = textAreas;
        this.textDirections = textDirections;
        this.urlAreas = urlAreas;
        this.urlText = urlText;
        this.current = current;
        this.errorTracker = errorTracker;
    }

    public Tj(ParserOptions parserOptions, Vector_Rectangle_Int textAreas, Vector_Int textDirections, Vector_Rectangle_Int urlAreas, Vector_String urlText, DynamicVectorRenderer current, ErrorTracker errorTracker) {
        this.parserOptions = parserOptions;
        this.textAreas = textAreas;
        this.textDirections = textDirections;
        this.urlAreas = urlAreas;
        this.urlText = urlText;
        this.current = current;
        this.errorTracker = errorTracker;
    }

    private void calcCoordinates(float x2, float[][] Trm, float charSpacing) {
        float[][] trm = new float[3][3];
        for (int xx = 0; xx < 3; ++xx) {
            System.arraycopy(Trm[xx], 0, trm[xx], 0, 3);
        }
        this.x1 = x2;
        this.x2 = trm[2][0] - charSpacing * trm[0][0];
        if (this.glyphData.isHorizontal()) {
            if (trm[1][0] < 0.0f) {
                this.x1 = x2 + trm[1][0] - charSpacing * trm[0][0];
                this.x2 = trm[2][0];
            } else if (trm[1][0] > 0.0f) {
                this.x1 = x2;
                this.x2 = trm[2][0];
            }
        } else if (trm[1][0] > 0.0f) {
            this.x1 = trm[2][0];
            this.x2 = x2 + trm[1][0] - charSpacing * trm[0][0];
        } else if (trm[1][0] < 0.0f) {
            this.x2 = trm[2][0];
            this.x1 = x2 + trm[1][0] - charSpacing * trm[0][0];
        }
    }

    public String TJ(TextState currentTextState, PdfFont currentFontData, byte[] characterStream, int startCommand, int dataPointer, boolean multipleTJs) {
        this.currentTextState = currentTextState;
        this.currentFontData = currentFontData;
        this.customGlyphTracker = this.parserOptions.getCustomGlyphTracker();
        StructuredContentHandler contentHandler = this.parserOptions.getContentHandler();
        this.isTabRemapped = currentFontData.getDiffMapping(9) != null;
        this.isCRRemapped = currentFontData.getDiffMapping(10) != null;
        this.isReturnRemapped = currentFontData.getDiffMapping(13) != null;
        this.streamLength = characterStream.length;
        this.glyphs = currentFontData.getGlyphData();
        StringBuilder current_value = this.processTextArray(characterStream, startCommand, dataPointer, this.multiplyer, multipleTJs);
        int fontSize = this.glyphData.getFontSize();
        if (fontSize == 0) {
            fontSize = (int)currentTextState.getTfs();
        }
        if (fontSize < 0) {
            fontSize = -fontSize;
        }
        if (current_value != null && this.parserOptions.isPageContent()) {
            String currentColor = null;
            if (this.parserOptions.isTextColorExtracted()) {
                currentColor = (this.gs.getTextRenderType() & 2) == 2 ? this.gs.nonstrokeColorSpace.getXMLColorToken() : this.gs.strokeColorSpace.getXMLColorToken();
            }
            if (contentHandler != null) {
                contentHandler.setText(current_value);
            } else if (this.parserOptions.isTextExtracted()) {
                this.pdfData.addRawTextElement(currentTextState.writingMode, Fonts.createFontToken(currentFontData.getFontName(), fontSize), currentFontData.getCurrentFontSpaceWidth(), fontSize, this.x1, this.y1, this.x2, this.y2, current_value, this.glyphData.getTextLength(), currentColor, this.glyphData.isXMLExtraction());
            }
        }
        return this.tjTextValue;
    }

    private void resetValues(GlyphData glyphData) {
        glyphData.setText(false);
        this.isHTML = this.current.isHTMLorSVG();
        glyphData.reset();
        this.TrmBeforeSpace = new float[3][3];
        this.lastWidth = 0.0f;
        this.currentWidth = 0.0f;
        this.Trm = Matrix.multiply(this.currentTextState.Tm, this.gs.CTM);
    }

    private StringBuilder processTextArray(byte[] stream, int startCommand, int dataPointer, float multiplyer, boolean multipleTJs) {
        this.resetValues(this.glyphData);
        int Tmode = this.gs.getTextRenderType();
        boolean hasContent = false;
        boolean isMultiple = false;
        float TFS = this.currentTextState.getTfs();
        if (TFS < 0.0f) {
            TFS = -TFS;
        }
        int type = this.currentFontData.getFontType();
        float spaceWidth = this.currentFontData.getCurrentFontSpaceWidth();
        StringBuilder textData = null;
        if (this.parserOptions.isTextExtracted()) {
            textData = new StringBuilder(50);
        }
        boolean isTextShifted = false;
        if (stream[startCommand = StreamReaderUtils.skipSpaces(stream, startCommand)] == 91) {
            isMultiple = true;
            ++startCommand;
        }
        startCommand = StreamReaderUtils.skipSpaces(stream, startCommand);
        if (this.currentFontData.codeSpaceRange != null) {
            this.glyphData.setCodeSpaceRange(this.currentFontData.codeSpaceRange);
        }
        this.glyphData.setDefaultCharSize(this.currentFontData);
        this.charSpacing = this.currentTextState.getCharacterSpacing() / TFS;
        float wordSpacing = this.currentTextState.getWordSpacing() / TFS;
        this.initTrm(multipleTJs);
        if (isMultiple && stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93) {
            startCommand = Tj.getOffset(stream, this.Trm, startCommand, this.currentFontData.isFontVertical());
        }
        int fontSize = Tj.calcFontSize(this.glyphData, this.currentTextState, this.Trm, this.currentFontData.isFontVertical());
        int textPrint = this.parserOptions.getTextPrint();
        Font javaFont = this.getJavaFont(fontSize, textPrint);
        float x2 = this.Trm[2][0];
        if (this.Trm[1][0] < 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][0] == 0.0f) {
            isTextShifted = true;
        }
        int i2 = startCommand;
        StringBuilder buff = null;
        if (this.returnText) {
            buff = new StringBuilder(this.streamLength);
        }
        boolean resetCoords = true;
        boolean isCID = this.currentFontData.isCIDFont();
        StringBuilder buffer = new StringBuilder();
        float[] urlCoordinates = new float[4];
        boolean firstTc = true;
        while (i2 < dataPointer) {
            this.glyphData.setActualWidth(-1.0f);
            i2 = CharReader.getNextValue(i2, stream, this.glyphData, isCID);
            if (this.glyphData.isText()) {
                i2 = this.getNextValue(stream, i2, isCID);
                if (firstTc) {
                    this.Trm = Tj.updateTrm(this.Trm, this.currentFontData, this.currentWidth, this.glyphData, 0.0f, this.glyphData.getRawInt());
                    firstTc = false;
                } else {
                    this.Trm = Tj.updateTrm(this.Trm, this.currentFontData, this.currentWidth, this.glyphData, this.charSpacing, this.glyphData.getRawInt());
                }
                if (this.glyphData.getRawChar() == ' ' && this.glyphData.getLastChar() != ' ') {
                    this.TrmBeforeSpace = this.Trm;
                }
                this.glyphData.setLeading(0.0f);
                this.decodeGlyf();
                if (buff != null) {
                    buff.append(this.glyphData.getDisplayValue());
                }
                float halfCW = this.currentWidth * 0.5f;
                int glyphID = this.glyphData.getRawInt();
                if (this.currentFontData.isFontVertical()) {
                    float vx;
                    float f2 = vx = this.currentFontData.vMatrix != null ? this.currentFontData.vMatrix[glyphID][2] : 0.0f;
                    if (vx != 0.0f) {
                        halfCW = vx;
                    }
                    float[][] mm = Matrix.getIdentity();
                    mm[2][0] = -halfCW;
                    this.Trm = Matrix.concatenate(this.Trm, mm);
                }
                this.renderGlyf(Tmode, javaFont, textPrint, fontSize, type, multiplyer, isTextShifted);
                String spaces = this.updateWidth(spaceWidth, wordSpacing, isCID);
                String displayValue = this.glyphData.getDisplayValue();
                if (!displayValue.isEmpty()) {
                    this.checkForURLInText(displayValue, buffer, urlCoordinates);
                }
                if (this.customGlyphTracker != null) {
                    this.customGlyphTracker.addGlyph(this.Trm, this.glyphData.getRawInt(), this.glyphData.getDisplayValue(), this.glyphData.getUnicodeValue());
                }
                if (this.parserOptions.isTextExtracted()) {
                    hasContent = Tj.writeOutText(this.glyphData, this.Trm, hasContent, this.currentWidth, textData, spaces);
                }
                if (this.currentFontData.isFontVertical()) {
                    float[][] mm = Matrix.getIdentity();
                    mm[2][1] = this.currentFontData.vMatrix[glyphID][0] + this.currentFontData.vMatrix[glyphID][1];
                    this.Trm = Matrix.concatenate(this.Trm, mm);
                    mm = Matrix.getIdentity();
                    mm[2][0] = halfCW;
                    this.Trm = Matrix.concatenate(this.Trm, mm);
                }
            } else if (this.glyphData.getRawChar() == '(' || this.glyphData.getRawChar() == '<') {
                this.glyphData.setText(true);
                this.glyphData.setOpenChar(this.glyphData.getRawChar());
            } else if (this.glyphData.getRawChar() == ')' || this.glyphData.getRawChar() == '>' && this.glyphData.getOpenChar() == '<' || !this.glyphData.isText() && (this.glyphData.getRawChar() == '-' || this.glyphData.getRawChar() >= '0' && this.glyphData.getRawChar() <= '9')) {
                i2 = Leading.readLeading(i2, stream, this.glyphData);
            }
            if (this.parserOptions.isTextExtracted()) {
                resetCoords = this.setExtractedText(this.currentWidth, resetCoords);
            }
            ++i2;
        }
        this.checkForURLInText(" ", buffer, urlCoordinates);
        if (buff != null) {
            this.appendText(buff);
        }
        this.Trm = Tj.updateMatrixPosition(this.currentFontData, this.Trm, this.glyphData.getLeading(), this.currentWidth, this.currentTextState);
        if (this.parserOptions.isTextExtracted()) {
            return this.setExtractedText(this.glyphData.getLastTextChar(), x2, textData, hasContent);
        }
        return null;
    }

    private String updateWidth(float spaceWidth, float wordSpacing, boolean isCID) {
        this.currentWidth = this.currentFontData.isFontVertical() ? (this.currentWidth -= this.charSpacing) : (this.currentWidth += this.charSpacing);
        if (this.glyphData.getRawChar() == ' ' && (!isCID || " ".equals(this.glyphData.getUnicodeValue()))) {
            this.currentWidth += wordSpacing;
        }
        float currentGap = this.glyphData.getWidth() + this.charSpacing - this.lastWidth;
        String spaces = "";
        if (currentGap > 0.0f && this.lastWidth > 0.0f) {
            spaces = PdfFont.getSpaces(currentGap, spaceWidth, 0.595f);
        }
        this.glyphData.addToWidth(this.currentWidth);
        this.lastWidth = this.glyphData.getWidth();
        return spaces;
    }

    private void appendText(StringBuilder buff) {
        this.tjTextValue = !this.tjTextValue.isEmpty() ? this.tjTextValue + ' ' + buff.toString() : buff.toString();
    }

    private void checkForURLInText(String displayValue, StringBuilder buffer, float[] urlCoordinates) {
        char first = displayValue.charAt(0);
        boolean containsSpace = displayValue.contains(" ");
        if (!(buffer.length() <= 0 && first != 'h' && first != 'H' && first != 'w' && first != 'W' || containsSpace)) {
            if (buffer.length() == 0) {
                urlCoordinates[0] = this.Trm[2][0];
            }
            urlCoordinates[1] = this.y2;
            urlCoordinates[2] = this.Trm[2][0] + this.glyphData.getWidth();
            urlCoordinates[3] = this.y1;
            buffer.append(displayValue);
        }
        if (containsSpace) {
            String url = buffer.toString();
            if (url.matches("((https?|ftp|sftp|telnet):(//))?[a-zA-Z0-9]+(\\.)[a-zA-Z0-9_-]+(\\.)[^<) ]*")) {
                this.urlText.addElement(url);
                this.urlAreas.addElement(new int[]{(int)urlCoordinates[0], (int)urlCoordinates[1], (int)urlCoordinates[2], (int)urlCoordinates[3]});
            }
            buffer.delete(0, buffer.length());
        }
    }

    private void decodeGlyf() {
        int diff;
        int idx2;
        float actualWidth = this.glyphData.getActualWidth();
        int idx = this.glyphData.getRawInt();
        if (this.glyphs.isIdentity() && (idx2 = this.glyphs.getCMAPValue(idx)) > 0) {
            idx = idx2;
            this.glyphData.setRawInt(idx);
        }
        if (this.currentFontData.isCIDFont() && !this.glyphs.isIdentity()) {
            if (!this.glyphs.hasCIDtoGID()) {
                idx2 = this.glyphs.getConvertedGlyph(idx);
                if (idx2 != -1) {
                    idx = idx2;
                }
            } else if (this.glyphs.getTable(2) == null && (idx2 = this.currentFontData.getEncodedCMAPValue(idx)) > 0) {
                idx = idx2;
                this.glyphData.setRawInt(idx);
            }
        } else if (this.currentFontData.getFontType() == 1228944677 && (diff = this.currentFontData.getDiffChar(idx)) > 0) {
            this.glyphData.setRawInt(diff);
        }
        this.getWidth(actualWidth, idx);
        if (this.isHTML && !this.currentFontData.isFontSubsetted() && this.currentFontData.getFontEncoding(true) == 2 && this.glyphData.getUnicodeValue().charAt(0) - idx == 32) {
            this.glyphData.setUnicodeValue(String.valueOf((char)idx).intern());
        }
    }

    private void getWidth(float actualWidth, int idx) {
        if (actualWidth > 0.0f) {
            this.currentWidth = actualWidth;
            this.currentFontData.setLastWidth(actualWidth);
        } else {
            this.currentWidth = this.currentFontData.getWidth(idx);
        }
        if (this.currentWidth == 0.0f && this.parserOptions.isXFA()) {
            Float value = StandardFonts.getStandardWidth("Arial", this.currentFontData.getMappedChar(this.glyphData.getRawInt(), false));
            this.currentWidth = value != null ? value.floatValue() : 0.0f;
            this.currentFontData.setLastWidth(this.currentWidth);
        }
        if (this.currentWidth == 0.0f && this.parserOptions.isXFA()) {
            int rawInt = this.glyphData.getRawInt();
            String glyfName = rawInt > 255 ? String.valueOf(rawInt) : StandardFonts.getUnicodeChar(2, rawInt);
            this.currentWidth = this.currentFontData.getGlyphWidth(glyfName, rawInt);
        }
    }

    private void renderGlyf(int Tmode, Font javaFont, int textPrint, int fontSize, int type, float multiplyer1, boolean isTextShifted) throws RuntimeException {
        if (this.parserOptions.isRenderText() && (Tmode != 4 || this.isHTML)) {
            boolean useTextPrintingForNonEmbeddedFonts;
            boolean bl2 = useTextPrintingForNonEmbeddedFonts = PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted());
            if (javaFont != null && this.parserOptions.isPrinting() && (textPrint == 3 || textPrint == 2 || useTextPrintingForNonEmbeddedFonts)) {
                if ((Tmode & 8) == 8) {
                    boolean isSTD = DecoderOptions.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false);
                    Area transformedGlyph2 = this.glyphs.getStandardGlyph(this.Trm, this.glyphData.getRawInt(), this.glyphData.getDisplayValue(), this.currentWidth, isSTD);
                    if (transformedGlyph2 != null) {
                        this.gs.addClip(transformedGlyph2);
                    }
                    this.current.drawClip(this.gs, null, true);
                }
                if (Tmode != 8 && this.glyphData.getDisplayValue() != null && !this.glyphData.getDisplayValue().startsWith("&#")) {
                    if (this.isHTML) {
                        this.current.drawEmbeddedText(this.Trm, fontSize, null, null, 1, this.gs, null, this.glyphData.getDisplayValue(), this.currentFontData, -100.0f);
                    } else {
                        this.current.drawText(this.Trm, this.glyphData.getDisplayValue(), this.gs, this.Trm[2][0], -this.Trm[2][1], javaFont);
                    }
                }
            } else if (!((textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded && !this.currentFontData.isCIDFont() && this.currentFontData.isFontSubstituted() && (this.glyphData.getRawInt() == 9 && !this.isTabRemapped || this.glyphData.getRawInt() == 10 && !this.isCRRemapped || this.glyphData.getRawInt() == 13 && !this.isReturnRemapped) || (textPrint != 1 || javaFont == null) && this.currentFontData.isFontSubstituted() && this.currentWidth == 0.0f && this.glyphData.getDisplayValue().charAt(0) == '\r')) {
                if ((textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded) {
                    this.renderText(this.currentWidth, type, Tmode, multiplyer1, isTextShifted);
                } else if (!this.glyphData.getDisplayValue().isEmpty() && !this.glyphData.getDisplayValue().startsWith("&#")) {
                    JavaTextRenderer.renderTextWithJavaFonts(this.gs, this.current, this.streamType, this.parserOptions, this.currentFontData, this.glyphData, Tmode, this.currentWidth, isTextShifted, this.glyphs, this.Trm);
                }
            }
        }
    }

    private void initTrm(boolean multipleTJs) {
        if (multipleTJs) {
            this.Trm[2][0] = this.currentTextState.Tm[2][0];
            this.Trm[2][1] = this.currentTextState.Tm[2][1];
        }
        float[][] temp = new float[3][3];
        temp[0][0] = this.currentTextState.getTfs() * this.currentTextState.getHorizontalScaling();
        temp[1][1] = this.currentTextState.getTfs();
        temp[2][1] = this.currentTextState.getTextRise();
        temp[2][2] = 1.0f;
        this.Trm = Matrix.multiply(temp, this.Trm);
    }

    private static float[][] updateTrm(float[][] Trm, PdfFont currentFontData, float currentWidth, GlyphData glyphData, float charSpacing, int glyphID) {
        float[][] temp = new float[3][3];
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        if (currentFontData.isFontVertical()) {
            temp[2][0] = 0.0f;
            temp[2][1] = -currentFontData.vMatrix[glyphID][0] + charSpacing + glyphData.getLeading();
        } else {
            temp[2][0] = currentWidth + glyphData.getLeading();
            temp[2][1] = 0.0f;
        }
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        return Trm;
    }

    private int getNextValue(byte[] stream, int i2, boolean isCID) {
        char lastTextChar = this.glyphData.getRawChar();
        if (this.glyphData.getOpenChar() == '<') {
            FallbackFont fallbackFont;
            i2 = isCID && !this.currentFontData.isFontSubstituted() && this.glyphData.getCodeSpaceRange() == null && this.currentFontData.isFontEmbedded && (stream[i2] != 48 || stream[i2 + 1] != 48) ? HexTextUtils.getHexCIDValue(stream, i2, this.glyphData, this.currentFontData, this.parserOptions) : (isCID && this.glyphData.getCodeSpaceRange() != null && this.glyphData.getCodeSpaceRange().hasEncoding && !this.currentFontData.hasToUnicode() ? ((fallbackFont = this.currentFontData.getFallbackFont()) != null && fallbackFont.isUnicode() ? HexTextUtils.getHexValueForceUnicode(stream, i2, this.glyphData, this.currentFontData) : HexTextUtils.getHexValueFromNonEmbedAdobeCMAP(stream, i2, this.glyphData, this.currentFontData)) : HexTextUtils.getHexValue(stream, i2, this.glyphData, this.currentFontData, this.parserOptions));
        } else if (lastTextChar == '\\' && !isCID) {
            i2 = EscapedTextUtils.getEscapedValue(i2, stream, this.glyphData, this.currentFontData, this.streamLength, this.parserOptions, this.current);
        } else if (isCID) {
            i2 = this.glyphData.getCodeSpaceRange() != null && this.glyphData.getCodeSpaceRange().hasEncoding && !this.currentFontData.hasToUnicode() ? CIDTextUtils.getNonEmbedCIDCharValues(i2, stream, this.streamLength, this.glyphData, this.currentFontData) : (this.currentFontData.getCIDToGIDMap() != null && this.currentFontData.getCIDToGIDMap().length <= 256 && this.currentFontData.hasToUnicode() ? CIDTextUtils.getCIDtoGIDandUNICharValues(i2, stream, this.streamLength, this.glyphData, this.currentFontData) : CIDTextUtils.getCIDCharValues(i2, stream, this.streamLength, this.glyphData, this.currentFontData, this.parserOptions));
        } else {
            lastTextChar = Tj.getValue(lastTextChar, this.glyphData, this.currentFontData, this.current);
        }
        this.glyphData.setLastTextChar(lastTextChar);
        if (!(this.currentFontData.isCIDFont() || this.isTabRemapped || this.glyphData.getRawInt() != 9 || !this.currentFontData.isFontSubstituted() && this.currentFontData.getFallbackFont() == null)) {
            this.glyphData.setRawInt(32);
            this.glyphData.set(" ");
        }
        return i2;
    }

    private Font getJavaFont(int fontSize, int textPrint) {
        Font javaFont = null;
        if (textPrint == 3 && StandardFonts.isStandardFont(this.currentFontData.getFontName(), true) && this.parserOptions.isPrinting()) {
            javaFont = this.currentFontData.getJavaFontX(fontSize);
        } else if (!(this.currentFontData.isFontEmbedded && !this.currentFontData.isFontSubstituted() || !PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts && textPrint == 0 || this.currentFontData.isCIDFont() || !this.parserOptions.isPrinting())) {
            javaFont = this.currentFontData.getJavaFontX(fontSize);
        }
        return javaFont;
    }

    private static int getOffset(byte[] stream, float[][] Trm, int startCommand, boolean isVerticalFont) {
        float offset = 0.0f;
        while (stream[startCommand] != 40 && stream[startCommand] != 60 && stream[startCommand] != 93) {
            StringBuilder kerning = new StringBuilder(10);
            while (stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93 && stream[startCommand] != 32) {
                kerning.append((char)stream[startCommand]);
                ++startCommand;
            }
            offset += Float.parseFloat(kerning.toString());
            while (stream[startCommand] == 32) {
                ++startCommand;
            }
        }
        if (Trm[0][0] == 0.0f && Trm[1][1] == 0.0f && Trm[0][1] != 0.0f && Trm[1][0] != 0.0f) {
            if (isVerticalFont) {
                offset = Trm[1][0] * offset / 1000.0f;
                float[] fArray = Trm[2];
                fArray[0] = fArray[0] - offset;
            } else {
                offset = Trm[0][1] * offset / 1000.0f;
                float[] fArray = Trm[2];
                fArray[1] = fArray[1] - offset;
            }
        } else if (isVerticalFont) {
            offset = Trm[1][1] * offset / 1000.0f;
            float[] fArray = Trm[2];
            fArray[1] = fArray[1] - offset;
        } else {
            offset = Trm[0][0] * offset / 1000.0f;
            float[] fArray = Trm[2];
            fArray[0] = fArray[0] - offset;
        }
        return startCommand;
    }

    private static float[][] updateMatrixPosition(PdfFont currentFontData, float[][] Trm, float leading, float currentWidth, TextState currentTextState) {
        float[][] temp = new float[3][3];
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = currentWidth + leading;
        temp[2][1] = 0.0f;
        if (currentFontData.isFontVertical()) {
            temp[2][0] = 0.0f;
        }
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        currentTextState.Tm[2][0] = Trm[2][0];
        currentTextState.Tm[2][1] = Trm[2][1] - currentTextState.getTextRise();
        return Trm;
    }

    private StringBuilder setExtractedText(char lastTextChar, float x2, StringBuilder textData, boolean hasContent) {
        if (lastTextChar == ' ') {
            this.Trm = this.TrmBeforeSpace;
        }
        this.calcCoordinates(x2, this.Trm, this.charSpacing);
        if (textData != null && this.actualText != null && !this.actualText.isEmpty()) {
            int startValue = textData.indexOf(PdfData.marker, 2);
            if (startValue > 0) {
                startValue = textData.indexOf(PdfData.marker, startValue + 1);
            }
            if (startValue > 0) {
                textData.setLength(startValue + 1);
                textData.append(this.actualText);
            }
            this.actualText = null;
        }
        if (textData != null && textData.length() == 0 || !hasContent) {
            textData = null;
        }
        if (commandWindow != null) {
            if (textData == null) {
                commandWindow.printCommand("no data", -2);
            } else {
                commandWindow.printCommand("data=" + this.x1 + ' ' + this.y1 + ',' + this.x2 + ' ' + this.y2 + ' ' + PdfGroupingAlgorithms.removeHiddenMarkers(textData.toString()), -2);
            }
        }
        return textData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderText(float currentWidth, int type, int Tmode, float multiplyer, boolean isTextShifted) throws RuntimeException {
        String charGlyph = "notdef";
        int rawInt = this.glyphData.getRawInt();
        float lw = this.gs.getLineWidth();
        try {
            PdfGlyph glyph;
            if (!this.currentFontData.isCIDFont()) {
                charGlyph = this.currentFontData.getMappedChar(rawInt, false);
            }
            if ((glyph = this.getPdfGlyph(currentWidth, type, charGlyph, rawInt)) != null || this.isHTML) {
                if (glyph != null && type == 1228944677) {
                    glyph.setWidth(currentWidth * 1000.0f);
                }
                Object finalTrm = new float[][]{{this.Trm[0][0], this.Trm[0][1], 0.0f}, {this.Trm[1][0], this.Trm[1][1], 0.0f}, {this.Trm[2][0], this.Trm[2][1], 1.0f}};
                float[][] finalScale = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                finalTrm = Matrix.multiply(finalScale, finalTrm);
                finalTrm[2][0] = this.Trm[2][0];
                finalTrm[2][1] = this.Trm[2][1];
                if (finalTrm[1][0] < 0.0f && finalTrm[0][1] < 0.0f) {
                    finalTrm[1][0] = -finalTrm[1][0];
                    finalTrm[0][1] = -finalTrm[0][1];
                }
                AffineTransform at2 = Matrix.toAffine(finalTrm);
                int fontType = Tj.getFontType(type, this.currentFontData, this.parserOptions);
                if ((Tmode & 8) == 8 && glyph != null && glyph.getShape() != null) {
                    Tj.renderClipText(glyph, at2, this.gs);
                }
                if (Tmode != 8 || this.isHTML) {
                    float lineWidth = 0.0f;
                    if (multiplyer > 0.0f) {
                        lineWidth = lw / multiplyer;
                    }
                    double[] textTrans = new double[6];
                    at2.getMatrix(textTrans);
                    float[][] ctm = this.gs.CTM;
                    float ctmScaling = this.isHTML ? 1.0f : (ctm[0][1] != 0.0f || ctm[1][0] != 0.0f || ctm[0][0] < 0.0f || ctm[1][1] < 0.0f ? (float)Math.sqrt(ctm[1][0] * ctm[1][0] + ctm[1][1] * ctm[1][1]) : ctm[1][1]);
                    float trmScaling = finalTrm[0][1] != 0.0f || finalTrm[1][0] != 0.0f || finalTrm[0][0] < 0.0f || finalTrm[1][1] < 0.0f ? (float)Math.sqrt(finalTrm[1][0] * finalTrm[1][0] + finalTrm[1][1] * finalTrm[1][1]) : finalTrm[1][1];
                    this.gs.setLineWidth(lineWidth / trmScaling * ctmScaling);
                    if (isTextShifted) {
                        this.current.drawEmbeddedText(this.Trm, -this.glyphData.getFontSize(), glyph, null, fontType, this.gs, textTrans, this.glyphData.getUnicodeValue(), this.currentFontData, -100.0f);
                    } else {
                        this.current.drawEmbeddedText(this.Trm, this.glyphData.getFontSize(), glyph, null, fontType, this.gs, textTrans, this.glyphData.getUnicodeValue(), this.currentFontData, -100.0f);
                    }
                }
            } else {
                this.glyphData.set(" ");
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
            this.errorTracker.addPageFailureMessage("Exception " + e2 + " on embedded font renderer");
        }
        finally {
            this.gs.setLineWidth(lw);
        }
    }

    private static void renderClipText(PdfGlyph glyph, AffineTransform at2, GraphicsState gs) {
        Area glyphShape = (Area)glyph.getShape().clone();
        if (glyph.hasHinting() && glyph instanceof TTGlyph) {
            glyphShape.transform(AffineTransform.getScaleInstance(0.01, 0.01));
        }
        glyphShape.transform(at2);
        if (glyphShape.getBounds().getWidth() > 0.0 && glyphShape.getBounds().getHeight() > 0.0) {
            gs.addClip(glyphShape);
        }
    }

    private static int getFontType(int type, PdfFont currentFontData, ParserOptions parserOptions) {
        int fontType = 5;
        if (type == 1217103210 || type == -1684566724 || currentFontData.isFontSubstituted() && type != 1228944677) {
            fontType = 4;
        } else if (type == 1228944679) {
            fontType = 6;
        }
        if (parserOptions.generateGlyphOnRender()) {
            fontType = -fontType;
        }
        return fontType;
    }

    private PdfGlyph getPdfGlyph(float currentWidth, int type, String charGlyph, int rawInt) {
        PdfGlyph glyph = this.parserOptions.generateGlyphOnRender() && !this.parserOptions.renderDirectly() ? this.getPdfGlyph(currentWidth, charGlyph, rawInt) : this.getPdfGlyph2(currentWidth, charGlyph, rawInt);
        if (type == 1228944679) {
            if (glyph != null && glyph.getmaxWidth() == 0.0f) {
                glyph = null;
            } else if (glyph != null && glyph.ignoreColors()) {
                glyph.setT3Colors(this.gs.getNonstrokeColor(), this.gs.getNonstrokeColor(), true);
            }
        }
        return glyph;
    }

    private PdfGlyph getPdfGlyph2(float currentWidth, String charGlyph, int rawInt) {
        PdfGlyph glyph = this.glyphs.getEmbeddedGlyph(charGlyph, this.Trm, rawInt, this.glyphData.getDisplayValue(), currentWidth, this.currentFontData.getEmbeddedChar(rawInt));
        if (glyph instanceof TTGlyph) {
            if (glyph.containsBrokenData()) {
                if (this.glyphData.getDisplayValue() != null && !this.glyphData.getDisplayValue().startsWith("&#")) {
                    if (this.current.isHTMLorSVG()) {
                        this.current.drawEmbeddedText(this.Trm, this.glyphData.getFontSize(), null, null, 1, this.gs, null, this.glyphData.getDisplayValue(), this.currentFontData, -100.0f);
                    } else {
                        this.current.drawText(this.Trm, this.glyphData.getDisplayValue(), this.gs, this.Trm[2][0], -this.Trm[2][1], this.currentFontData.getJavaFontX(this.glyphData.getFontSize()));
                    }
                }
                glyph = null;
            } else {
                this.ttHintingRequired = this.ttHintingRequired || ((TTGlyph)glyph).isTTHintingRequired();
            }
        }
        return glyph;
    }

    private PdfGlyph getPdfGlyph(float currentWidth, String charGlyph, int rawInt) {
        PdfGlyph glyph;
        if (this.glyphData.isfirstTime()) {
            glyph = new MarkerGlyph(this.Trm[0][0], this.Trm[0][1], this.Trm[1][0], this.Trm[1][1], this.currentFontData.getBaseFontName());
            ((SwingDisplay)this.current).checkFontSaved(glyph, this.currentFontData.getBaseFontName(), this.currentFontData);
            this.glyphData.setFirstTime();
        }
        this.currentFontData.setValuesForGlyph(rawInt, charGlyph, this.glyphData.getDisplayValue(), this.currentFontData.getEmbeddedChar(rawInt));
        glyph = new UnrendererGlyph(this.Trm[2][0], this.Trm[2][1], rawInt, currentWidth);
        return glyph;
    }

    private static char getValue(char lastTextChar, GlyphData glyphData, PdfFont currentFontData, DynamicVectorRenderer current) {
        String possAltValue;
        String newValue = currentFontData.getGlyphValue(glyphData.getRawInt());
        glyphData.setDisplayValue(newValue);
        int rawInt = glyphData.getRawInt();
        if (rawInt == 32 && !" ".equals(glyphData.getDisplayValue())) {
            lastTextChar = (char)90;
        }
        glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), rawInt));
        if (currentFontData.getFontType() == 1228944677 && current.isHTMLorSVG() && (possAltValue = currentFontData.getMappedChar(rawInt, true)) != null && possAltValue.length() == 1 && possAltValue.equalsIgnoreCase(glyphData.getUnicodeValue())) {
            glyphData.set(possAltValue);
        }
        return lastTextChar;
    }

    private static int calcFontSize(GlyphData glyphData, TextState currentTextState, float[][] Trm, boolean isVertical) throws RuntimeException {
        int fontSize;
        if (Trm[1][1] != 0.0f && !isVertical) {
            glyphData.setHorizontal(true);
            currentTextState.writingMode = 0;
            fontSize = Trm[1][1] < 0.0f ? (int)(Trm[1][1] - 0.5f) : (int)(Trm[1][1] + 0.5f);
            if (fontSize == 0) {
                fontSize = Trm[0][1] < 0.0f ? (int)(Trm[0][1] - 0.5f) : (int)(Trm[0][1] + 0.5f);
            }
            glyphData.setFontScale(Trm[0][0]);
            if (Trm[0][0] == 0.0f && Trm[0][1] > 0.0f && Trm[1][0] < 0.0f && Trm[1][1] > 0.0f) {
                currentTextState.writingMode = 3;
            }
        } else {
            glyphData.setHorizontal(false);
            fontSize = Trm[1][0] < 0.0f ? (int)(Trm[1][0] - 0.5f) : (int)(Trm[1][0] + 0.5f);
            if (fontSize == 0) {
                fontSize = Trm[0][0] < 0.0f ? (int)(Trm[0][0] - 0.5f) : (int)(Trm[0][0] + 0.5f);
            }
            if (fontSize < 0) {
                fontSize = -fontSize;
                currentTextState.writingMode = 3;
            } else {
                currentTextState.writingMode = 2;
            }
            glyphData.setFontScale(Trm[0][1]);
        }
        if (fontSize == 0) {
            fontSize = 1;
        } else if (fontSize < 0) {
            fontSize = -fontSize;
        }
        glyphData.setFontSize(fontSize);
        return fontSize;
    }

    private static boolean writeOutText(GlyphData glyphData, float[][] Trm, boolean hasContent, float currentWidth, StringBuilder textData, String spaces) {
        String unicodeValue = glyphData.getUnicodeValue();
        float fontScale = glyphData.getFontScale();
        if (!unicodeValue.isEmpty()) {
            if (DecoderOptions.embedWidthData) {
                float xx = Trm[2][0];
                float yy = Trm[2][1];
                textData.append(spaces);
                if (glyphData.isHorizontal()) {
                    textData.append(PdfData.marker);
                    textData.append(xx);
                    textData.append(PdfData.marker);
                } else {
                    textData.append(PdfData.marker);
                    textData.append(yy);
                    textData.append(PdfData.marker);
                }
                textData.append(currentWidth * fontScale);
                textData.append(PdfData.marker);
            } else {
                textData.append(spaces);
            }
            int length = unicodeValue.length();
            boolean isXMLExtraction = glyphData.isXMLExtraction();
            for (int ii = 0; ii < length; ++ii) {
                char next = unicodeValue.charAt(ii);
                hasContent = true;
                if (next == '\t') {
                    next = ' ';
                }
                if (next == '<' && isXMLExtraction) {
                    textData.append("&lt;");
                    continue;
                }
                if (next == '>' && isXMLExtraction) {
                    textData.append("&gt;");
                    continue;
                }
                if (next == '\ufb02') {
                    textData.append("fl");
                    continue;
                }
                if (next > '\u001f') {
                    textData.append(next);
                    continue;
                }
                if (next == '\r' || next == '\n') {
                    textData.append(' ');
                    continue;
                }
                textData.append(hex[next]);
            }
        } else {
            textData.append(spaces);
        }
        return hasContent;
    }

    private boolean setExtractedText(float currentWidth, boolean resetCoords) {
        String displayValue = this.glyphData.getDisplayValue();
        if (!displayValue.isEmpty() && !" ".equals(displayValue)) {
            float fy;
            float xx = (int)this.Trm[2][0];
            float yy = (int)this.Trm[2][1];
            float fontScale = this.glyphData.getFontScale();
            if (fontScale < 0.0f) {
                fontScale = -fontScale;
            }
            float ww = currentWidth * fontScale;
            Rectangle fontbb = this.currentFontData.getBoundingBox();
            float hh = Tj.getHeight(fontbb, this.Trm, this.currentFontData);
            if (ww < 0.0f) {
                ww = -ww;
                xx -= ww;
            }
            if (hh < 0.0f) {
                hh = -hh;
                yy -= hh;
            }
            if (fontbb.y < 0) {
                fontbb.height -= fontbb.y;
                fontbb.y = 0;
            }
            if ((fy = (float)fontbb.y) == 0.0f) {
                fy = 100.0f;
            }
            float h2 = 1000.0f + fy;
            h2 = 1000.0f / h2;
            switch (this.currentTextState.writingMode) {
                case 0: {
                    float fontHeight = hh / h2;
                    yy -= fontHeight - hh;
                    hh = fontHeight;
                    break;
                }
                case 1: {
                    System.out.println("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                    break;
                }
                case 2: {
                    float fontHeight = ww / h2;
                    xx -= fontHeight - ww;
                    ww = fontHeight;
                    break;
                }
                case 3: {
                    float fontHeight = ww / h2;
                    xx -= fontHeight;
                    ww = fontHeight;
                }
            }
            xx -= 1.0f;
            ww += 2.0f;
            if (resetCoords) {
                this.y2 = yy;
                this.y1 = yy + hh;
                resetCoords = false;
            }
            if (yy < this.y2) {
                this.y2 = yy;
            }
            if (yy + hh > this.y1) {
                this.y1 = yy + hh;
            }
            if (this.textAreas != null && this.parserOptions.isRenderText()) {
                this.textAreas.addElement(new int[]{(int)xx, (int)yy, (int)ww, (int)hh});
                this.textDirections.addElement(this.currentTextState.writingMode);
            }
        }
        return resetCoords;
    }

    private static float getHeight(Rectangle fontbb, float[][] trm, PdfFont currentFontData) {
        int d1Value;
        float hh = trm[1][1];
        if (hh == 0.0f) {
            hh = trm[0][1];
        }
        if (currentFontData.getFontType() == 1228944679 && hh != 0.0f && (int)hh == 0 && currentFontData.FontMatrix[3] == -1.0) {
            hh *= currentFontData.FontBBox[3] - currentFontData.FontBBox[1];
            hh = -hh;
        }
        if (currentFontData.getFontType() == 1228944679 && currentFontData.FontBBox[2] == 0.0f && currentFontData.FontBBox[3] == 0.0f && (d1Value = currentFontData.type3_d1_Max) != 0) {
            hh = (float)d1Value / 1000.0f * trm[1][1];
            fontbb.y = 1;
        }
        hh = (int)hh;
        return hh;
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    public void setReturnText(boolean returnText) {
        this.returnText = returnText;
    }

    public void setActualText(String actualText) {
        this.actualText = actualText;
    }

    static {
        hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    }
}

