/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.objects.TextState;
import org.jpedal.parser.text.CoreHexTextUtils;
import org.jpedal.utils.Matrix;

public final class TD {
    private static final int[] multiply8 = new int[]{0, 3, 6, 9, 12, 15};

    private TD() {
    }

    public static void execute(boolean isLowerCase, float x2, float y2, TextState currentTextState) {
        TD.relativeMove(x2, y2, currentTextState);
        float TL = -y2;
        if (!isLowerCase) {
            currentTextState.setLeading(TL);
        }
        currentTextState.setLastTdValue(TL);
    }

    public static void relativeMove(float new_x, float new_y, TextState currentTextState) {
        float[][] temp = new float[3][3];
        currentTextState.Tm = currentTextState.getTMAtLineStart();
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = new_x;
        temp[2][1] = new_y;
        temp[2][2] = 1.0f;
        currentTextState.Tm = Matrix.multiply(temp, currentTextState.Tm);
        currentTextState.setTMAtLineStart();
    }

    static int readEscapeValue(int start, int count, int base, byte[] characterStream) {
        int val;
        switch (base) {
            case 8: {
                val = TD.getOctal(start, count, characterStream);
                break;
            }
            case 16: {
                val = CoreHexTextUtils.getHexValue(start, count, characterStream);
                break;
            }
            default: {
                val = TD.getGeneral(start, count, base, characterStream);
            }
        }
        return val;
    }

    private static int getGeneral(int start, int count, int base, byte[] characterStream) {
        StringBuilder chars = new StringBuilder(10);
        for (int pointer = 0; pointer < count; ++pointer) {
            chars.append((char)characterStream[start + pointer]);
        }
        return Integer.parseInt(chars.toString(), base);
    }

    private static int getOctal(int start, int count, byte[] characterStream) {
        int ptr = 0;
        int val = 0;
        for (int aa2 = 1; aa2 < count + 1; ++aa2) {
            int topHex = characterStream[start + count - aa2];
            if (topHex < 48 || topHex > 55) continue;
            val += (topHex -= 48) << multiply8[ptr];
            ++ptr;
        }
        return val;
    }

    static String getString(int start, int end, byte[] dataStream) {
        while (dataStream[end] == 32 || dataStream[end] == 13 || dataStream[end] == 10) {
            --end;
        }
        int count = end - start + 1;
        int spaces = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii <= 0 || dataStream[start + ii] != 32 && dataStream[start + ii] != 13 && dataStream[start + ii] != 10 || dataStream[start + ii - 1] != 32 && dataStream[start + ii - 1] != 13 && dataStream[start + ii - 1] != 10) continue;
            ++spaces;
        }
        char[] charString = new char[count - spaces];
        int pos = 0;
        boolean previouslyWhitespace = false;
        for (int ii = 0; ii < count; ++ii) {
            boolean currentlyWhitespace;
            boolean bl2 = currentlyWhitespace = dataStream[start + ii] == 32 || dataStream[start + ii] == 13 || dataStream[start + ii] == 10;
            if (!previouslyWhitespace || !currentlyWhitespace) {
                charString[pos] = currentlyWhitespace ? 32 : (char)dataStream[start + ii];
                ++pos;
            }
            previouslyWhitespace = currentlyWhitespace;
        }
        String s2 = String.copyValueOf(charString);
        return s2;
    }
}

