/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;
import org.jpedal.render.DynamicVectorRenderer;

final class EscapedTextUtils {
    private EscapedTextUtils() {
    }

    static int getEscapedValue(int i2, byte[] stream, GlyphData glyphData, PdfFont currentFontData, int streamLength, ParserOptions parserOptions, DynamicVectorRenderer current) {
        String possAltValue;
        glyphData.setLastChar(glyphData.getRawChar());
        if (streamLength > ++i2 + 2 && Character.isDigit((char)stream[i2])) {
            int numberCount = EscapedTextUtils.getNumberCount(i2, stream);
            int rawInt = TD.readEscapeValue(i2, numberCount, 8, stream) & 0xFF;
            i2 = i2 + numberCount - 1;
            glyphData.setRawChar((char)rawInt);
            glyphData.setRawInt(rawInt);
            glyphData.setDisplayValue(currentFontData.getGlyphValue(rawInt));
            if (parserOptions.isTextExtracted()) {
                glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), rawInt));
            }
            if (glyphData.getRawChar() == '\\') {
                glyphData.setRawChar('x');
            }
        } else {
            int rawInt = stream[i2] & 0xFF;
            glyphData.setRawChar((char)rawInt);
            if (glyphData.getRawChar() == 'u') {
                rawInt = TD.readEscapeValue(i2 + 1, 4, 16, stream);
                i2 += 4;
                glyphData.setDisplayValue(currentFontData.getGlyphValue(rawInt));
                if (parserOptions.isTextExtracted()) {
                    glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), rawInt));
                }
            } else {
                char testChar = glyphData.getRawChar();
                switch (testChar) {
                    case 'n': {
                        rawInt = 10;
                        glyphData.setRawChar('\n');
                        break;
                    }
                    case 'b': {
                        rawInt = 8;
                        glyphData.setRawChar('\b');
                        break;
                    }
                    case 't': {
                        rawInt = 9;
                        glyphData.setRawChar('\t');
                        break;
                    }
                    case 'r': {
                        rawInt = 13;
                        glyphData.setRawChar('\r');
                        break;
                    }
                    case 'f': {
                        rawInt = 12;
                        glyphData.setRawChar('\f');
                        break;
                    }
                }
                glyphData.setDisplayValue(currentFontData.getGlyphValue(rawInt));
                if (parserOptions.isTextExtracted()) {
                    glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), rawInt));
                }
                if (!glyphData.getDisplayValue().isEmpty()) {
                    glyphData.setRawChar(glyphData.getDisplayValue().charAt(0));
                }
            }
            glyphData.setRawInt(rawInt);
        }
        if (currentFontData.getFontType() == 1228944677 && current.isHTMLorSVG() && (possAltValue = currentFontData.getMappedChar(glyphData.getRawInt(), true)) != null && possAltValue.length() == 1 && possAltValue.equalsIgnoreCase(glyphData.getUnicodeValue())) {
            glyphData.set(possAltValue);
        }
        return i2;
    }

    private static int getNumberCount(int i2, byte[] stream) {
        int numberCount = 1;
        if (Character.isDigit((char)stream[i2 + 1])) {
            ++numberCount;
            if (Character.isDigit((char)stream[i2 + 2])) {
                ++numberCount;
            }
        }
        return numberCount;
    }
}

