/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.io.ObjectUtils;
import org.jpedal.parser.text.GlyphData;

final class CharReader {
    private CharReader() {
    }

    static int getNextValue(int i2, byte[] stream, GlyphData glyphData, boolean isCID) {
        while (true) {
            glyphData.setLastChar();
            int rawInt = stream[i2];
            if (rawInt < 0) {
                rawInt = 256 + rawInt;
            }
            glyphData.setRawChar((char)rawInt);
            if (glyphData.getRawChar() == '\\' && (stream[i2 + 1] == 13 || stream[i2 + 1] == 10)) {
                rawInt = stream[i2 += 2];
                if (rawInt < 0) {
                    rawInt = 256 + rawInt;
                }
                glyphData.setRawChar((char)rawInt);
            }
            glyphData.setRawInt(rawInt);
            if ((glyphData.getRawChar() != '\n' || isCID && glyphData.getOpenChar() != '<') && glyphData.getRawChar() != '\r') break;
            ++i2;
        }
        if (glyphData.isText()) {
            char testChar = glyphData.getRawChar();
            if (!(testChar != '(' && testChar != ')' || ObjectUtils.isEscaped(stream, i2))) {
                glyphData.updatePrefixCount(testChar);
            } else if (testChar == '>' && glyphData.getOpenChar() == '<') {
                glyphData.setText(false);
            }
        }
        return i2;
    }
}

